/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security.client;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.exceptions.YarnException;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class TimelineDelegationTokenIdentifier
extends AbstractDelegationTokenIdentifier {
    public static final Text KIND_NAME = new Text("TIMELINE_DELEGATION_TOKEN");

    public TimelineDelegationTokenIdentifier() {
    }

    public TimelineDelegationTokenIdentifier(Text owner, Text renewer, Text realUser) {
        super(owner, renewer, realUser);
    }

    public Text getKind() {
        return KIND_NAME;
    }

    @InterfaceAudience.Private
    public static class Renewer
    extends TokenRenewer {
        public boolean handleKind(Text kind) {
            return KIND_NAME.equals((Object)kind);
        }

        public boolean isManaged(Token<?> token) throws IOException {
            return true;
        }

        public long renew(Token<?> token, Configuration conf) throws IOException, InterruptedException {
            TimelineClient client = TimelineClient.createTimelineClient();
            try {
                client.init(conf);
                client.start();
                long l = client.renewDelegationToken(token);
                return l;
            }
            catch (YarnException e) {
                throw new IOException(e);
            }
            finally {
                client.stop();
            }
        }

        public void cancel(Token<?> token, Configuration conf) throws IOException, InterruptedException {
            TimelineClient client = TimelineClient.createTimelineClient();
            try {
                client.init(conf);
                client.start();
                client.cancelDelegationToken(token);
            }
            catch (YarnException e) {
                throw new IOException(e);
            }
            finally {
                client.stop();
            }
        }
    }
}

