/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.streaming;

import org.pentaho.di.trans.dataservice.client.api.IDataServiceClientService;

public abstract class WindowParametersHelper {
    public static String getCacheKey(String query, IDataServiceClientService.StreamingMode windowMode, long windowSize, long windowEvery, int windowMaxRowLimit, long windowMaxTimeLimit, long windowLimit, int serviceExecutorCacheKeyHash) {
        long maxTime;
        boolean timeBased = IDataServiceClientService.StreamingMode.TIME_BASED.equals((Object)windowMode);
        boolean rowBased = IDataServiceClientService.StreamingMode.ROW_BASED.equals((Object)windowMode);
        int maxRows = WindowParametersHelper.getMaxRows(windowMaxRowLimit, windowLimit, timeBased);
        if ((windowSize = WindowParametersHelper.getWindowSize(windowSize, timeBased, maxRows, maxTime = WindowParametersHelper.getMaxTime(windowMaxTimeLimit, windowLimit, rowBased))) == 0L) {
            return null;
        }
        windowEvery = WindowParametersHelper.getWindowEvery(windowEvery, timeBased, maxRows, maxTime);
        return String.valueOf(serviceExecutorCacheKeyHash).concat("-").concat(query.concat(windowMode.toString())).concat("-").concat(String.valueOf(windowSize)).concat("-").concat(String.valueOf(windowEvery)).concat("-").concat(String.valueOf(maxRows)).concat("-").concat(String.valueOf(maxTime));
    }

    public static long getWindowEvery(long windowEvery, boolean timeBased, int maxRows, long maxTime) {
        windowEvery = windowEvery <= 0L ? 0L : (timeBased ? Math.min(windowEvery, maxTime) : Math.min(windowEvery, (long)maxRows));
        return windowEvery;
    }

    public static long getWindowSize(long windowSize, boolean timeBased, int maxRows, long maxTime) {
        windowSize = windowSize <= 0L ? 0L : (timeBased ? Math.min(windowSize, maxTime) : Math.min(windowSize, (long)maxRows));
        return windowSize;
    }

    public static long getMaxTime(long windowMaxTimeLimit, long windowLimit, boolean rowBased) {
        return windowLimit > 0L && rowBased ? Math.min(windowLimit, windowMaxTimeLimit) : windowMaxTimeLimit;
    }

    public static int getMaxRows(int windowMaxRowLimit, long windowLimit, boolean timeBased) {
        return windowLimit > 0L && timeBased ? (int)Math.min(windowLimit, (long)windowMaxRowLimit) : windowMaxRowLimit;
    }
}

