/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.CanonicalNamer;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.SchemaMergeException;
import org.apache.pig.impl.util.MultiMap;

public class Schema
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2L;
    private List<FieldSchema> mFields;
    private Map<String, FieldSchema> mAliases;
    private MultiMap<String, String> mFieldSchemas;
    private static Log log = LogFactory.getLog(Schema.class);
    private boolean twoLevelAccessRequired = false;
    static int[] primeList = new int[]{3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 1133};

    public Schema() {
        this.mFields = new ArrayList<FieldSchema>();
        this.mAliases = new HashMap<String, FieldSchema>();
        this.mFieldSchemas = new MultiMap();
    }

    public Schema(List<FieldSchema> fields) {
        this.mFields = fields;
        this.mAliases = new HashMap<String, FieldSchema>(fields.size());
        this.mFieldSchemas = new MultiMap();
        for (FieldSchema fs : fields) {
            if (null == fs || fs.alias == null) continue;
            this.mAliases.put(fs.alias, fs);
            this.mFieldSchemas.put(fs.canonicalName, fs.alias);
        }
    }

    public Schema(FieldSchema fieldSchema) {
        this.mFields = new ArrayList<FieldSchema>(1);
        this.mFields.add(fieldSchema);
        this.mAliases = new HashMap<String, FieldSchema>(1);
        this.mFieldSchemas = new MultiMap();
        if (null != fieldSchema && fieldSchema.alias != null) {
            this.mAliases.put(fieldSchema.alias, fieldSchema);
            this.mFieldSchemas.put(fieldSchema.canonicalName, fieldSchema.alias);
        }
    }

    public Schema(Schema s) {
        if (null != s) {
            this.twoLevelAccessRequired = s.twoLevelAccessRequired;
            this.mFields = new ArrayList<FieldSchema>(s.size());
            this.mAliases = new HashMap<String, FieldSchema>();
            this.mFieldSchemas = new MultiMap();
            try {
                for (int i = 0; i < s.size(); ++i) {
                    FieldSchema fs = new FieldSchema(s.getField(i));
                    this.mFields.add(fs);
                    if (null == fs || fs.alias == null) continue;
                    this.mAliases.put(fs.alias, fs);
                    this.mFieldSchemas.put(fs.canonicalName, fs.alias);
                }
            }
            catch (FrontendException pe) {
                this.mFields = new ArrayList<FieldSchema>();
                this.mAliases = new HashMap<String, FieldSchema>();
                this.mFieldSchemas = new MultiMap();
            }
        } else {
            this.mFields = new ArrayList<FieldSchema>();
            this.mAliases = new HashMap<String, FieldSchema>();
            this.mFieldSchemas = new MultiMap();
        }
    }

    public FieldSchema getField(String alias) throws FrontendException {
        FieldSchema fs = this.mAliases.get(alias);
        if (null == fs) {
            String cocoPrefix = "::" + alias;
            HashMap<String, Integer> aliasMatches = new HashMap<String, Integer>();
            for (String string : this.mAliases.keySet()) {
                if (!string.endsWith(cocoPrefix)) continue;
                Integer count = (Integer)aliasMatches.get(string);
                if (null == count) {
                    aliasMatches.put(string, 1);
                    continue;
                }
                count = count + 1;
                aliasMatches.put(string, count);
            }
            if (aliasMatches.keySet().size() == 0) {
                return null;
            }
            if (aliasMatches.keySet().size() == 1) {
                Object[] keys = aliasMatches.keySet().toArray();
                String string = (String)keys[0];
                if ((Integer)aliasMatches.get(string) > 1) {
                    int errCode = 1024;
                    throw new FrontendException("Found duplicate aliases: " + string, errCode, 2);
                }
                return this.mAliases.get(string);
            }
            HashSet<FieldSchema> set = new HashSet<FieldSchema>();
            for (String key : aliasMatches.keySet()) {
                set.add(this.mAliases.get(key));
            }
            if (set.size() == 1) {
                return (FieldSchema)set.iterator().next();
            }
            boolean bl = false;
            StringBuilder sb = new StringBuilder("Found more than one match: ");
            for (String key : aliasMatches.keySet()) {
                boolean bl2;
                if (bl2) {
                    sb.append(", ");
                } else {
                    bl2 = true;
                }
                sb.append(key);
            }
            int errCode = 1025;
            throw new FrontendException(sb.toString(), errCode, 2);
        }
        return fs;
    }

    public FieldSchema getFieldSubNameMatch(String alias) throws FrontendException {
        if (alias == null) {
            return null;
        }
        FieldSchema fs = this.getField(alias);
        if (fs != null) {
            return fs;
        }
        String sep = "::";
        ArrayList<FieldSchema> matchedFieldSchemas = new ArrayList<FieldSchema>();
        if (alias.contains("::")) {
            for (FieldSchema field : this.mFields) {
                if (!alias.endsWith("::" + field.alias)) continue;
                matchedFieldSchemas.add(field);
            }
        }
        if (matchedFieldSchemas.size() > 1) {
            boolean hasNext = false;
            StringBuilder sb = new StringBuilder("Found more than one sub alias name match: ");
            for (FieldSchema matchFs : matchedFieldSchemas) {
                if (hasNext) {
                    sb.append(", ");
                } else {
                    hasNext = true;
                }
                sb.append(matchFs.alias);
            }
            int errCode = 1116;
            throw new FrontendException(sb.toString(), errCode, 2);
        }
        if (matchedFieldSchemas.size() == 1) {
            fs = (FieldSchema)matchedFieldSchemas.get(0);
        }
        return fs;
    }

    public FieldSchema getField(int fieldNum) throws FrontendException {
        if (fieldNum >= this.mFields.size()) {
            int errCode = 1026;
            String detailedMsg = "Attempt to access field: " + fieldNum + " from schema: " + this;
            String msg = "Attempt to fetch field " + fieldNum + " from schema of size " + this.mFields.size();
            throw new FrontendException(msg, errCode, 2, false, detailedMsg);
        }
        return this.mFields.get(fieldNum);
    }

    public int size() {
        return this.mFields.size();
    }

    public void reconcile(Schema other) throws FrontendException {
        if (other != null) {
            if (other.size() != this.size()) {
                int errCode = 1027;
                String msg = "Cannot reconcile schemas with different sizes.  This schema has size " + this.size() + " other has size " + "of " + other.size();
                String detailedMsg = "Schema size mismatch. This schema: " + this + " other schema: " + other;
                throw new FrontendException(msg, errCode, 2, false, detailedMsg);
            }
            Iterator<FieldSchema> i = other.mFields.iterator();
            int j = 0;
            while (i.hasNext()) {
                FieldSchema otherFs = i.next();
                FieldSchema ourFs = this.mFields.get(j);
                log.debug((Object)("ourFs: " + ourFs + " otherFs: " + otherFs));
                if (otherFs.alias != null) {
                    log.debug((Object)("otherFs.alias: " + otherFs.alias));
                    if (ourFs.alias != null) {
                        log.debug((Object)("Removing ourFs.alias: " + ourFs.alias));
                        this.mAliases.remove(ourFs.alias);
                        List<String> aliases = this.mFieldSchemas.get(ourFs.canonicalName);
                        if (aliases != null) {
                            ArrayList<String> listAliases = new ArrayList<String>();
                            for (String alias : aliases) {
                                listAliases.add(alias);
                            }
                            for (String alias : listAliases) {
                                log.debug((Object)("Removing alias " + alias + " from multimap"));
                                this.mFieldSchemas.remove(ourFs.canonicalName, alias);
                            }
                        }
                    }
                    ourFs.alias = otherFs.alias;
                    log.debug((Object)("Setting alias to: " + otherFs.alias));
                    this.mAliases.put(ourFs.alias, ourFs);
                    if (null != ourFs.alias) {
                        this.mFieldSchemas.put(ourFs.canonicalName, ourFs.alias);
                    }
                }
                if (otherFs.type != 0) {
                    ourFs.type = otherFs.type;
                    log.debug((Object)("Setting type to: " + DataType.findTypeName(otherFs.type)));
                }
                if (otherFs.schema != null) {
                    ourFs.schema = otherFs.schema;
                    log.debug((Object)("Setting schema to: " + otherFs.schema));
                }
                ++j;
            }
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof Schema)) {
            return false;
        }
        Schema s = (Schema)other;
        return Schema.equals(this, s, false, false);
    }

    public Schema clone() throws CloneNotSupportedException {
        Schema s = new Schema();
        HashMap<FieldSchema, FieldSchema> fsMap = new HashMap<FieldSchema, FieldSchema>(this.size());
        HashMap<String, FieldSchema> fsCanonicalNameMap = new HashMap<String, FieldSchema>(this.size());
        for (FieldSchema fs : this.mFields) {
            FieldSchema copy = fs.clone();
            s.mFields.add(copy);
            fsMap.put(fs, copy);
            fsCanonicalNameMap.put(fs.canonicalName, copy);
        }
        for (String alias : this.mAliases.keySet()) {
            FieldSchema oldFs = this.mAliases.get(alias);
            assert (oldFs != null);
            FieldSchema newFs = (FieldSchema)fsMap.get(oldFs);
            assert (newFs != null);
            s.mAliases.put(alias, newFs);
        }
        for (String oldFsCanonicalName : this.mFieldSchemas.keySet()) {
            FieldSchema newFs = (FieldSchema)fsCanonicalNameMap.get(oldFsCanonicalName);
            assert (newFs != null);
            s.mFieldSchemas.put(newFs.canonicalName, this.mFieldSchemas.get(oldFsCanonicalName));
        }
        s.twoLevelAccessRequired = this.twoLevelAccessRequired;
        return s;
    }

    public int hashCode() {
        int idx = 0;
        int hashCode = 0;
        for (FieldSchema fs : this.mFields) {
            hashCode += fs.hashCode() * primeList[idx % primeList.length];
            ++idx;
        }
        return hashCode;
    }

    public String toString() {
        return this.toIndentedString(Integer.MIN_VALUE);
    }

    public String prettyPrint() {
        return this.toIndentedString(0);
    }

    private String toIndentedString(int indentLevel) {
        StringBuilder sb = new StringBuilder();
        try {
            Schema.stringifySchema(sb, this, (byte)120, indentLevel);
        }
        catch (FrontendException fee) {
            throw new RuntimeException("PROBLEM PRINTING SCHEMA");
        }
        return sb.toString();
    }

    public static void stringifySchema(StringBuilder sb, Schema schema, byte type) throws FrontendException {
        Schema.stringifySchema(sb, schema, type, 0);
    }

    public static void stringifySchema(StringBuilder sb, Schema schema, byte type, int indentLevel) throws FrontendException {
        if (type == 110) {
            sb.append("(");
        } else if (type == 120) {
            sb.append("{");
        }
        ++indentLevel;
        if (schema != null) {
            boolean isFirst = true;
            for (int i = 0; i < schema.size(); ++i) {
                if (!isFirst) {
                    sb.append(",");
                } else {
                    isFirst = false;
                }
                Schema.indent(sb, indentLevel);
                FieldSchema fs = schema.getField(i);
                if (fs == null) continue;
                if (fs.alias != null) {
                    sb.append(fs.alias);
                    sb.append(": ");
                }
                if (DataType.isAtomic(fs.type)) {
                    sb.append(DataType.findTypeName(fs.type));
                    continue;
                }
                if (fs.type == 110 || fs.type == 120) {
                    if (schema != fs.schema) {
                        Schema.stringifySchema(sb, fs.schema, fs.type, indentLevel);
                        continue;
                    }
                    throw new AssertionError((Object)"Schema refers to itself as inner schema");
                }
                if (fs.type == 100) {
                    sb.append(DataType.findTypeName(fs.type) + "[");
                    if (fs.schema != null) {
                        Schema.stringifySchema(sb, fs.schema, fs.type, indentLevel);
                    }
                    sb.append("]");
                    continue;
                }
                sb.append(DataType.findTypeName(fs.type));
            }
        }
        Schema.indent(sb, --indentLevel);
        if (type == 110) {
            sb.append(")");
        } else if (type == 120) {
            sb.append("}");
        }
    }

    private static void indent(StringBuilder sb, int indentLevel) {
        if (indentLevel >= 0) {
            sb.append("\n");
        }
        while (indentLevel-- > 0) {
            sb.append("    ");
        }
    }

    public void add(FieldSchema f) {
        this.mFields.add(f);
        if (null != f) {
            this.mFieldSchemas.put(f.canonicalName, f.alias);
            if (null != f.alias) {
                this.mAliases.put(f.alias, f);
            }
        }
    }

    public int getPosition(String alias) throws FrontendException {
        return this.getPosition(alias, false);
    }

    public int getPositionSubName(String alias) throws FrontendException {
        return this.getPosition(alias, true);
    }

    private int getPosition(String alias, boolean isSubNameMatch) throws FrontendException {
        FieldSchema fs;
        if (isSubNameMatch && this.twoLevelAccessRequired) {
            int errCode = 2248;
            String msg = "twoLevelAccessRequired==true is not supported withand isSubNameMatch==true ";
            throw new FrontendException(msg, errCode, 4);
        }
        if (this.twoLevelAccessRequired) {
            if (this.mFields.size() != 1) {
                int errCode = 1008;
                String msg = "Expected a bag schema with a single element of type " + DataType.findTypeName((byte)110) + " but got a bag schema with multiple elements.";
                throw new FrontendException(msg, errCode, 2);
            }
            FieldSchema tupleFS = this.mFields.get(0);
            if (tupleFS.type != 110) {
                int errCode = 1009;
                String msg = "Expected a bag schema with a single element of type " + DataType.findTypeName((byte)110) + " but got an element of type " + DataType.findTypeName(tupleFS.type);
                throw new FrontendException(msg, errCode, 2);
            }
            if (alias.equals(tupleFS.alias)) {
                int errCode = 1028;
                String msg = "Access to the tuple (" + alias + ") of " + "the bag is disallowed. Only access to the elements of " + "the tuple in the bag is allowed.";
                throw new FrontendException(msg, errCode, 2);
            }
            return tupleFS.schema.getPosition(alias);
        }
        FieldSchema fieldSchema = fs = isSubNameMatch ? this.getFieldSubNameMatch(alias) : this.getField(alias);
        if (null == fs) {
            return -1;
        }
        log.debug((Object)("fs: " + fs));
        int index = -1;
        for (int i = 0; i < this.mFields.size(); ++i) {
            log.debug((Object)("mFields(" + i + "): " + this.mFields.get(i) + " alias: " + this.mFields.get((int)i).alias));
            if (fs != this.mFields.get(i)) continue;
            index = i;
        }
        log.debug((Object)("index: " + index));
        return index;
    }

    public void addAlias(String alias, FieldSchema fs) {
        if (null != alias) {
            this.mAliases.put(alias, fs);
            if (null != fs) {
                this.mFieldSchemas.put(fs.canonicalName, alias);
            }
        }
    }

    public Set<String> getAliases() {
        return this.mAliases.keySet();
    }

    public void printAliases() {
        Set<String> aliasNames = this.mAliases.keySet();
        for (String alias : aliasNames) {
            log.debug((Object)("Schema Alias: " + alias));
        }
    }

    public List<FieldSchema> getFields() {
        return this.mFields;
    }

    public static boolean castable(Schema cast, Schema input) {
        if (cast == null && input == null) {
            return false;
        }
        if (cast == null) {
            return false;
        }
        if (input == null) {
            return false;
        }
        if (cast.size() > input.size()) {
            return false;
        }
        Iterator<FieldSchema> i = cast.mFields.iterator();
        Iterator<FieldSchema> j = input.mFields.iterator();
        while (i.hasNext()) {
            FieldSchema inputFs;
            FieldSchema castFs = i.next();
            if (FieldSchema.castable(castFs, inputFs = j.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Schema schema, Schema other, boolean relaxInner, boolean relaxAlias) {
        if (schema == null && other == null) {
            return true;
        }
        if (schema == null) {
            return false;
        }
        if (other == null) {
            return false;
        }
        if (schema.isTwoLevelAccessRequired() || other.isTwoLevelAccessRequired()) {
            if (schema.isTwoLevelAccessRequired()) {
                try {
                    schema = schema.getField((int)0).schema;
                }
                catch (FrontendException fee) {
                    return false;
                }
            }
            if (other.isTwoLevelAccessRequired()) {
                try {
                    other = other.getField((int)0).schema;
                }
                catch (FrontendException fee) {
                    return false;
                }
            }
            return Schema.equals(schema, other, relaxInner, relaxAlias);
        }
        if (schema.size() != other.size()) {
            return false;
        }
        Iterator<FieldSchema> i = schema.mFields.iterator();
        Iterator<FieldSchema> j = other.mFields.iterator();
        while (i.hasNext()) {
            FieldSchema myFs = i.next();
            FieldSchema otherFs = j.next();
            if (!(relaxAlias || myFs.alias == null && otherFs.alias == null)) {
                if (myFs.alias != null && otherFs.alias == null) {
                    return false;
                }
                if (myFs.alias == null && otherFs.alias != null) {
                    return false;
                }
                if (!myFs.alias.equals(otherFs.alias)) {
                    return false;
                }
            }
            if (myFs.type != otherFs.type) {
                return false;
            }
            if (relaxInner || FieldSchema.equals(myFs, otherFs, false, relaxAlias)) continue;
            return false;
        }
        return true;
    }

    public Schema merge(Schema other, boolean otherTakesAliasPrecedence) {
        return Schema.mergeSchema(this, other, otherTakesAliasPrecedence);
    }

    public static Schema mergeSchema(Schema schema, Schema other, boolean otherTakesAliasPrecedence) {
        try {
            Schema newSchema = Schema.mergeSchema(schema, other, otherTakesAliasPrecedence, false, false);
            return newSchema;
        }
        catch (SchemaMergeException schemaMergeException) {
            return null;
        }
    }

    public static Schema mergeSchema(Schema schema, Schema other, boolean otherTakesAliasPrecedence, boolean allowDifferentSizeMerge, boolean allowIncompatibleTypes) throws SchemaMergeException {
        if (schema == null && other == null) {
            return null;
        }
        if (schema == null) {
            if (allowIncompatibleTypes) {
                return null;
            }
            int errCode = 1029;
            String msg = "One of the schemas is null for merging schemas. Schema: " + schema + " Other schema: " + other;
            throw new SchemaMergeException(msg, errCode, 2);
        }
        if (other == null) {
            if (allowIncompatibleTypes) {
                return null;
            }
            int errCode = 1029;
            String msg = "One of the schemas is null for merging schemas. Schema: " + schema + " Other schema: " + other;
            throw new SchemaMergeException(msg, errCode, 2);
        }
        if (schema.size() != other.size() && !allowDifferentSizeMerge) {
            int errCode = 1030;
            String msg = "Different schema sizes for merging schemas. Schema size: " + schema.size() + " Other schema size: " + other.size();
            throw new SchemaMergeException(msg, errCode, 2);
        }
        ArrayList<FieldSchema> outputList = new ArrayList<FieldSchema>();
        List<FieldSchema> mylist = schema.mFields;
        List<FieldSchema> otherlist = other.mFields;
        int iterateLimit = schema.mFields.size() > other.mFields.size() ? other.mFields.size() : schema.mFields.size();
        for (int idx = 0; idx < iterateLimit; ++idx) {
            FieldSchema myFs = mylist.get(idx);
            FieldSchema otherFs = otherlist.get(idx);
            byte mergedType = DataType.mergeType(myFs.type, otherFs.type);
            if (mergedType == -1) {
                if (allowIncompatibleTypes) {
                    mergedType = 50;
                } else {
                    int errCode = 1031;
                    String msg = "Incompatible types for merging schemas. Field schema type: " + DataType.findTypeName(myFs.type) + " Other field schema type: " + DataType.findTypeName(otherFs.type);
                    throw new SchemaMergeException(msg, errCode, 2);
                }
            }
            String mergedAlias = Schema.mergeAlias(myFs.alias, otherFs.alias, otherTakesAliasPrecedence);
            FieldSchema mergedFs = null;
            if (!DataType.isSchemaType(mergedType)) {
                mergedFs = new FieldSchema(mergedAlias, mergedType);
            } else {
                Schema mergedSubSchema = Schema.mergeSchema(myFs.schema, otherFs.schema, otherTakesAliasPrecedence, allowDifferentSizeMerge, allowIncompatibleTypes);
                try {
                    mergedFs = new FieldSchema(mergedAlias, mergedSubSchema, mergedType);
                }
                catch (FrontendException e) {
                    int errCode = 2124;
                    String errMsg = "Internal Error: Unexpected error creating field schema";
                    throw new SchemaMergeException(errMsg, errCode, 4, (Throwable)e);
                }
            }
            outputList.add(mergedFs);
        }
        if (allowDifferentSizeMerge) {
            FieldSchema fs;
            int i;
            for (i = idx; i < mylist.size(); ++i) {
                fs = mylist.get(i);
                if (!DataType.isSchemaType(fs.type)) {
                    outputList.add(new FieldSchema(fs.alias, fs.type));
                    continue;
                }
                FieldSchema tmp = new FieldSchema(fs.alias, fs.schema);
                tmp.type = fs.type;
                outputList.add(tmp);
            }
            for (i = idx; i < otherlist.size(); ++i) {
                fs = otherlist.get(i);
                if (!DataType.isSchemaType(fs.type)) {
                    outputList.add(new FieldSchema(fs.alias, fs.type));
                    continue;
                }
                FieldSchema tmp = new FieldSchema(fs.alias, fs.schema);
                tmp.type = fs.type;
                outputList.add(tmp);
            }
        }
        Schema result = new Schema(outputList);
        if (schema.isTwoLevelAccessRequired() != other.isTwoLevelAccessRequired()) {
            int errCode = 2124;
            String errMsg = "Cannot merge schema " + schema + " and " + other + ". One with twoLeverAccess flag, the other doesn't.";
            throw new SchemaMergeException(errMsg, errCode, 4);
        }
        if (schema.isTwoLevelAccessRequired()) {
            result.setTwoLevelAccessRequired(true);
        }
        return result;
    }

    private static String mergeAlias(String alias, String other, boolean otherTakesPrecedence) {
        if (alias == null) {
            return other;
        }
        if (other == null) {
            return alias;
        }
        if (otherTakesPrecedence) {
            return other;
        }
        return alias;
    }

    public static Schema mergeSchemasByAlias(Collection<Schema> schemas) throws SchemaMergeException {
        Schema mergedSchema = null;
        ArrayList<Schema> mergedSchemas = new ArrayList<Schema>(schemas.size());
        for (Schema sch : schemas) {
            if (mergedSchema == null) {
                mergedSchema = new Schema(sch);
                mergedSchemas.add(sch);
                continue;
            }
            try {
                mergedSchema = Schema.mergeSchemaByAlias(mergedSchema, sch);
                mergedSchemas.add(sch);
            }
            catch (SchemaMergeException e) {
                String msg = "Error merging schema: (" + sch + ") with " + "merged schema: (" + mergedSchema + ")" + " of schemas : " + mergedSchemas;
                SchemaMergeException sme = new SchemaMergeException(msg, e.getErrorCode(), e);
                sme.setMarkedAsShowToUser(true);
                throw sme;
            }
        }
        return mergedSchema;
    }

    public static Schema mergeSchemaByAlias(Schema schema1, Schema schema2) throws SchemaMergeException {
        Schema mergedSchema = new Schema();
        HashSet<FieldSchema> schema2colsAdded = new HashSet<FieldSchema>();
        for (FieldSchema fs1 : schema1.getFields()) {
            Schema.checkNullAlias(fs1, schema1);
            FieldSchema fs2 = Schema.getFieldSubNameMatchThrowSchemaMergeException(schema2, fs1.alias);
            if (fs2 != null) {
                if (schema2colsAdded.contains(fs2)) {
                    Schema.getFieldSubNameMatchThrowSchemaMergeException(schema1, fs2.alias);
                }
                schema2colsAdded.add(fs2);
            }
            FieldSchema mergedFs = Schema.mergeFieldSchemaFirstLevelSameAlias(fs1, fs2);
            mergedSchema.add(mergedFs);
        }
        for (FieldSchema fs2 : schema2.getFields()) {
            Schema.checkNullAlias(fs2, schema2);
            if (schema2colsAdded.contains(fs2)) continue;
            try {
                mergedSchema.add(fs2.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new SchemaMergeException("Error encountered while merging schemas", e);
            }
        }
        return mergedSchema;
    }

    private static void checkNullAlias(FieldSchema fs, Schema schema) throws SchemaMergeException {
        if (fs.alias == null) {
            throw new SchemaMergeException("Schema having field with null alias cannot be merged using alias. Schema :" + schema, 1126);
        }
    }

    private static FieldSchema mergeFieldSchemaFirstLevelSameAlias(FieldSchema fs1, FieldSchema fs2) throws SchemaMergeException {
        if (fs1 == null) {
            return fs2;
        }
        if (fs2 == null) {
            return fs1;
        }
        Schema innerSchema = null;
        String alias = Schema.mergeNameSpacedAlias(fs1.alias, fs2.alias);
        byte mergedType = DataType.mergeType(fs1.type, fs2.type);
        if (mergedType == -1) {
            int errCode = 1031;
            String msg = "Incompatible types for merging schemas. Field schema: " + fs1 + " Other field schema: " + fs2;
            throw new SchemaMergeException(msg, errCode, 2);
        }
        if (DataType.isSchemaType(mergedType)) {
            if (fs1.type == 50) {
                innerSchema = fs2.schema;
            } else if (fs2.type == 50) {
                innerSchema = fs1.schema;
            } else {
                if (!Schema.equals(fs1.schema, fs2.schema, false, false)) {
                    int errCode = 1032;
                    String msg = "Incompatible types for merging inner schemas of  Field schema type: " + fs1 + " Other field schema type: " + fs2;
                    throw new SchemaMergeException(msg, errCode, 2);
                }
                innerSchema = fs1.schema;
            }
        }
        try {
            return new FieldSchema(alias, innerSchema, mergedType);
        }
        catch (FrontendException e) {
            int errCode = 2124;
            throw new SchemaMergeException("Error in creating fieldSchema", errCode, 4);
        }
    }

    private static String mergeNameSpacedAlias(String alias1, String alias2) throws SchemaMergeException {
        if (alias1.equals(alias2)) {
            return alias1;
        }
        if (alias1.endsWith("::" + alias2)) {
            return alias2;
        }
        if (alias2.endsWith("::" + alias1)) {
            return alias1;
        }
        return null;
    }

    private static FieldSchema getFieldSubNameMatchThrowSchemaMergeException(Schema schema, String alias) throws SchemaMergeException {
        FieldSchema fs = null;
        try {
            fs = schema.getFieldSubNameMatch(alias);
        }
        catch (FrontendException e) {
            String msg = "Caught exception finding FieldSchema for alias " + alias;
            throw new SchemaMergeException(msg, e.getErrorCode(), e);
        }
        return fs;
    }

    public static Schema generateNestedSchema(byte topLevelType, byte ... innerTypes) throws FrontendException {
        Schema innerSchema = new Schema();
        for (int i = 0; i < innerTypes.length; ++i) {
            innerSchema.add(new FieldSchema(null, innerTypes[i]));
        }
        FieldSchema outerSchema = new FieldSchema(null, innerSchema, topLevelType);
        return new Schema(outerSchema);
    }

    public Schema mergePrefixSchema(Schema other, boolean otherTakesAliasPrecedence) throws SchemaMergeException {
        return this.mergePrefixSchema(other, otherTakesAliasPrecedence, false);
    }

    public Schema mergePrefixSchema(Schema other, boolean otherTakesAliasPrecedence, boolean allowMergeableTypes) throws SchemaMergeException {
        Schema schema = this;
        if (other == null) {
            return this;
        }
        if (schema.size() < other.size()) {
            int errCode = 1033;
            String msg = "Schema size mismatch for merging schemas. Other schema size greater than schema size. Schema: " + this + ". Other schema: " + other;
            throw new SchemaMergeException(msg, errCode, 2);
        }
        ArrayList<FieldSchema> outputList = new ArrayList<FieldSchema>();
        List<FieldSchema> mylist = schema.mFields;
        List<FieldSchema> otherlist = other.mFields;
        int iterateLimit = other.mFields.size();
        for (int idx = 0; idx < iterateLimit; ++idx) {
            FieldSchema myFs = mylist.get(idx);
            FieldSchema otherFs = otherlist.get(idx);
            FieldSchema mergedFs = myFs.mergePrefixFieldSchema(otherFs, otherTakesAliasPrecedence, allowMergeableTypes);
            outputList.add(mergedFs);
        }
        for (int i = idx; i < mylist.size(); ++i) {
            FieldSchema fs = mylist.get(i);
            if (!DataType.isSchemaType(fs.type)) {
                outputList.add(new FieldSchema(fs.alias, fs.type));
                continue;
            }
            try {
                FieldSchema tmp = new FieldSchema(fs.alias, fs.schema, fs.type);
                outputList.add(tmp);
                continue;
            }
            catch (FrontendException fee) {
                int errCode = 1023;
                String msg = "Unable to create field schema.";
                throw new SchemaMergeException(msg, errCode, 2, (Throwable)fee);
            }
        }
        Schema s = new Schema(outputList);
        s.setTwoLevelAccessRequired(other.twoLevelAccessRequired);
        return s;
    }

    public static void setSchemaDefaultType(Schema s, byte t) {
        if (null == s) {
            return;
        }
        for (FieldSchema fs : s.getFields()) {
            FieldSchema.setFieldSchemaDefaultType(fs, t);
        }
    }

    @Deprecated
    public boolean isTwoLevelAccessRequired() {
        return this.twoLevelAccessRequired;
    }

    @Deprecated
    public void setTwoLevelAccessRequired(boolean twoLevelAccess) {
        this.twoLevelAccessRequired = twoLevelAccess;
    }

    public static Schema getPigSchema(ResourceSchema rSchema) throws FrontendException {
        if (rSchema == null) {
            return null;
        }
        ArrayList<FieldSchema> fsList = new ArrayList<FieldSchema>();
        for (ResourceSchema.ResourceFieldSchema rfs : rSchema.getFields()) {
            FieldSchema fs = new FieldSchema(rfs.getName(), rfs.getSchema() == null ? null : Schema.getPigSchema(rfs.getSchema()), rfs.getType());
            if (rfs.getType() == 120 && fs.schema != null) {
                if (fs.schema.size() == 1) {
                    FieldSchema innerFs = fs.schema.getField(0);
                    if (innerFs.type != 110) {
                        ResourceSchema.ResourceFieldSchema.throwInvalidSchemaException();
                    }
                } else {
                    ResourceSchema.ResourceFieldSchema.throwInvalidSchemaException();
                }
            }
            fsList.add(fs);
        }
        return new Schema(fsList);
    }

    public FieldSchema findFieldSchema(String canonicalName) {
        for (FieldSchema fs : this.mFields) {
            FieldSchema result;
            if (fs.canonicalName.equals(canonicalName)) {
                return fs;
            }
            if (fs.schema == null || (result = fs.schema.findFieldSchema(canonicalName)) == null) continue;
            return result;
        }
        return null;
    }

    public static class FieldSchema
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 2L;
        public String alias;
        public byte type;
        public Schema schema;
        public String canonicalName = null;
        public static final CanonicalNamer canonicalNamer = new CanonicalNamer();
        private static Log log = LogFactory.getLog(FieldSchema.class);

        public FieldSchema(String a, byte t) {
            this.alias = a;
            this.type = t;
            this.schema = null;
            this.canonicalName = CanonicalNamer.getNewName();
        }

        public FieldSchema(String a, Schema s) {
            this.alias = a;
            this.type = (byte)110;
            this.schema = s;
            this.canonicalName = CanonicalNamer.getNewName();
        }

        public FieldSchema(String a, Schema s, byte t) throws FrontendException {
            this.alias = a;
            this.schema = s;
            log.debug((Object)("t: " + t + " Bag: " + 120 + " tuple: " + 110));
            if (null != s && !DataType.isSchemaType(t)) {
                int errCode = 1020;
                throw new FrontendException("Only a BAG, TUPLE or MAP can have schemas. Got " + DataType.findTypeName(t), errCode, 2);
            }
            this.type = t;
            this.canonicalName = CanonicalNamer.getNewName();
        }

        public FieldSchema(FieldSchema fs) {
            if (null != fs) {
                this.alias = fs.alias;
                this.schema = null != fs.schema ? new Schema(fs.schema) : null;
                this.type = fs.type;
            } else {
                this.alias = null;
                this.schema = null;
                this.type = 0;
            }
            this.canonicalName = CanonicalNamer.getNewName();
        }

        public boolean equals(Object other) {
            if (!(other instanceof FieldSchema)) {
                return false;
            }
            FieldSchema otherfs = (FieldSchema)other;
            return FieldSchema.equals(this, otherfs, false, false);
        }

        public int hashCode() {
            return this.type * 17 + (this.schema == null ? 0 : this.schema.hashCode()) * 23 + (this.alias == null ? 0 : this.alias.hashCode()) * 29;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static boolean castable(FieldSchema castFs, FieldSchema inputFs) {
            if (castFs == null && inputFs == null) {
                return false;
            }
            if (castFs == null) {
                return false;
            }
            if (inputFs == null) {
                return false;
            }
            byte inputType = inputFs.type;
            byte castType = castFs.type;
            if (DataType.isSchemaType(castFs.type)) {
                if (inputType == 50) return true;
                if (inputType != castType) return false;
                if (castFs.schema == null && inputFs.schema == null || Schema.castable(castFs.schema, inputFs.schema)) return true;
                return false;
            }
            if (inputType == castType || inputType == 5 && (castType == 55 || castType == 50 || DataType.isNumberType(castType)) || DataType.isNumberType(inputType) && (castType == 55 || castType == 50 || DataType.isNumberType(castType) || castType == 5 || castType == 30) || inputType == 30 && (castType == 55 || castType == 50 || DataType.isNumberType(castType)) || inputType == 55 && (castType == 50 || DataType.isNumberType(castType) || castType == 5 || castType == 30) || inputType == 50) return true;
            return false;
        }

        public static boolean equals(FieldSchema fschema, FieldSchema fother, boolean relaxInner, boolean relaxAlias) {
            if (fschema == null) {
                return false;
            }
            if (fother == null) {
                return false;
            }
            if (fschema.type != fother.type) {
                return false;
            }
            if (!(relaxAlias || fschema.alias == null && fother.alias == null)) {
                if (fschema.alias != null && fother.alias == null) {
                    return false;
                }
                if (fschema.alias == null && fother.alias != null) {
                    return false;
                }
                if (!fschema.alias.equals(fother.alias)) {
                    return false;
                }
            }
            return relaxInner || !DataType.isSchemaType(fschema.type) || fschema.schema == null && fother.schema == null || Schema.equals(fschema.schema, fother.schema, false, relaxAlias);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.alias != null) {
                sb.append(this.alias);
                sb.append(": ");
            }
            sb.append(DataType.findTypeName(this.type));
            if (this.schema != null) {
                sb.append("(");
                sb.append(this.schema.toString());
                sb.append(")");
            }
            return sb.toString();
        }

        public FieldSchema clone() throws CloneNotSupportedException {
            try {
                FieldSchema fs = new FieldSchema(this.alias, this.schema == null ? null : this.schema.clone(), this.type);
                fs.canonicalName = CanonicalNamer.getNewName();
                return fs;
            }
            catch (FrontendException fe) {
                throw new RuntimeException("Should never fail to clone a FieldSchema", fe);
            }
        }

        public FieldSchema mergePrefixFieldSchema(FieldSchema otherFs) throws SchemaMergeException {
            return this.mergePrefixFieldSchema(otherFs, true, false);
        }

        public FieldSchema mergePrefixFieldSchema(FieldSchema otherFs, boolean otherTakesAliasPrecedence) throws SchemaMergeException {
            return this.mergePrefixFieldSchema(otherFs, otherTakesAliasPrecedence, false);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public FieldSchema mergePrefixFieldSchema(FieldSchema otherFs, boolean otherTakesAliasPrecedence, boolean allowMergeableTypes) throws SchemaMergeException {
            FieldSchema myFs = this;
            FieldSchema mergedFs = null;
            byte mergedType = 1;
            if (null == otherFs) {
                return myFs;
            }
            if (this.isNullOrUnknownType(myFs) && this.isNullOrUnknownType(otherFs)) {
                int errCode = 1021;
                String msg = "Type mismatch. No useful type for merging. Field Schema: " + myFs + ". Other Field Schema: " + otherFs;
                throw new SchemaMergeException(msg, errCode, 2);
            }
            if (myFs.type == otherFs.type) {
                mergedType = myFs.type;
            } else if (!this.isNullOrUnknownType(myFs) && this.isNullOrUnknownType(otherFs)) {
                mergedType = myFs.type;
            } else {
                if (!allowMergeableTypes) {
                    int errCode = 1022;
                    String msg = "Type mismatch merging schema prefix. Field Schema: " + myFs + ". Other Field Schema: " + otherFs;
                    throw new SchemaMergeException(msg, errCode, 2);
                }
                if (this.isNullOrUnknownType(myFs) && !this.isNullOrUnknownType(otherFs)) {
                    mergedType = otherFs.type;
                } else if (otherFs.type == 50) {
                    mergedType = myFs.type;
                } else {
                    if (!FieldSchema.castable(otherFs, myFs)) {
                        int errCode = 1022;
                        String msg = "Type mismatch for merging schema prefix. Field Schema: " + myFs + ". Other Field Schema: " + otherFs;
                        throw new SchemaMergeException(msg, errCode, 2);
                    }
                    mergedType = otherFs.type;
                }
            }
            String mergedAlias = Schema.mergeAlias(myFs.alias, otherFs.alias, otherTakesAliasPrecedence);
            if (!DataType.isSchemaType(mergedType)) {
                return new FieldSchema(mergedAlias, mergedType);
            }
            Schema mergedSubSchema = null;
            if (null != myFs.schema) {
                mergedSubSchema = myFs.schema.mergePrefixSchema(otherFs.schema, otherTakesAliasPrecedence, allowMergeableTypes);
            } else {
                mergedSubSchema = otherFs.schema;
                Schema.setSchemaDefaultType(mergedSubSchema, (byte)50);
            }
            try {
                return new FieldSchema(mergedAlias, mergedSubSchema, mergedType);
            }
            catch (FrontendException fee) {
                int errCode = 1023;
                String msg = "Unable to create field schema.";
                throw new SchemaMergeException(msg, errCode, 4, (Throwable)fee);
            }
        }

        public static void setFieldSchemaDefaultType(FieldSchema fs, byte t) {
            if (null == fs) {
                return;
            }
            if (1 == fs.type) {
                fs.type = t;
            }
            if (DataType.isSchemaType(fs.type)) {
                Schema.setSchemaDefaultType(fs.schema, t);
            }
        }

        private boolean isNullOrUnknownType(FieldSchema fs) {
            return fs.type == 1 || fs.type == 0;
        }

        public FieldSchema findFieldSchema(String canonicalName) {
            if (this.canonicalName.equals(canonicalName)) {
                return this;
            }
            if (this.schema != null) {
                return this.schema.findFieldSchema(canonicalName);
            }
            return null;
        }
    }
}

