/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.operator;

import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.bloom.BloomFilter;
import org.apache.hadoop.util.bloom.Key;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POLocalRearrangeTez;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.ObjectCache;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezInput;
import org.apache.pig.builtin.BuildBloomBase;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.library.api.KeyValueReader;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class POBloomFilterRearrangeTez
extends POLocalRearrangeTez
implements TezInput {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(POBloomFilterRearrangeTez.class);
    private String inputKey;
    private transient KeyValueReader reader;
    private transient String cacheKey;
    private int numBloomFilters;
    private transient BloomFilter[] bloomFilters;

    public POBloomFilterRearrangeTez(POLocalRearrangeTez lr, int numBloomFilters) {
        super(lr);
        this.numBloomFilters = numBloomFilters;
    }

    public void setInputKey(String inputKey) {
        this.inputKey = inputKey;
    }

    @Override
    public String[] getTezInputs() {
        return new String[]{this.inputKey};
    }

    @Override
    public void replaceInput(String oldInputKey, String newInputKey) {
        if (oldInputKey.equals(this.inputKey)) {
            this.inputKey = newInputKey;
        }
    }

    @Override
    public void addInputsToSkip(Set<String> inputsToSkip) {
        this.cacheKey = "bloom-" + this.inputKey;
        Object cacheValue = ObjectCache.getInstance().retrieve(this.cacheKey);
        if (cacheValue != null) {
            inputsToSkip.add(this.inputKey);
        }
    }

    @Override
    public void attachInputs(Map<String, LogicalInput> inputs, Configuration conf) throws ExecException {
        Object cacheValue = ObjectCache.getInstance().retrieve(this.cacheKey);
        if (cacheValue != null) {
            this.bloomFilters = (BloomFilter[])cacheValue;
            return;
        }
        LogicalInput input = inputs.get(this.inputKey);
        if (input == null) {
            throw new ExecException("Input from vertex " + this.inputKey + " is missing");
        }
        try {
            this.reader = (KeyValueReader)input.getReader();
            LOG.info((Object)("Attached input from vertex " + this.inputKey + " : input=" + input + ", reader=" + this.reader));
            while (this.reader.next()) {
                if (this.bloomFilters == null) {
                    this.bloomFilters = new BloomFilter[this.numBloomFilters];
                }
                Tuple val = (Tuple)this.reader.getCurrentValue();
                int index = (Integer)val.get(0);
                this.bloomFilters[index] = BuildBloomBase.bloomIn((DataByteArray)val.get(1));
            }
            ObjectCache.getInstance().cache(this.cacheKey, this.bloomFilters);
        }
        catch (Exception e) {
            throw new ExecException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Result getNextTuple() throws ExecException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isKeyInBloomFilter(Object key) throws ExecException {
        if (key == null) {
            return false;
        }
        if (this.bloomFilters.length == 1) {
            Key k = new Key(DataType.toBytes(key, this.keyType));
            return this.bloomFilters[0].membershipTest(k);
        }
        int partition = (key.hashCode() & Integer.MAX_VALUE) % this.numBloomFilters;
        BloomFilter filter = this.bloomFilters[partition];
        if (filter != null) {
            Key k = new Key(DataType.toBytes(key, this.keyType));
            return filter.membershipTest(k);
        }
        return false;
    }

    @Override
    public POBloomFilterRearrangeTez clone() throws CloneNotSupportedException {
        return (POBloomFilterRearrangeTez)super.clone();
    }

    @Override
    public String name() {
        return this.getAliasString() + "BloomFilter Rearrange" + "[" + DataType.findTypeName(this.resultType) + "]" + "{" + DataType.findTypeName(this.keyType) + "}" + "(" + this.mIsDistinct + ") - " + this.mKey.toString() + "\t<-\t " + this.inputKey + "\t->\t " + this.outputKey;
    }
}

