/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.tez.TezResourceManager;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezCompiler;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainerNode;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainerPrinter;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainerUDFCollector;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POStoreTez;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.JarManager;

public class TezPlanContainer
extends OperatorPlan<TezPlanContainerNode> {
    private static final long serialVersionUID = 1L;
    private PigContext pigContext;
    private String jobName;
    private long dagId = 0L;
    private static long scopeId = 0L;

    public TezPlanContainer(PigContext pigContext) {
        this.pigContext = pigContext;
        this.jobName = pigContext.getProperties().getProperty("jobName", "pig");
    }

    public Map<String, LocalResource> getLocalResources() throws Exception {
        HashSet<URI> jarLists = new HashSet<URI>();
        for (String string : JarManager.getDefaultJars()) {
            jarLists.add(new File(string).toURI());
        }
        for (URL uRL : this.pigContext.extraJars) {
            jarLists.add(uRL.toURI());
        }
        for (String string : this.pigContext.scriptJars) {
            jarLists.add(new File(string).toURI());
        }
        for (Map.Entry entry : this.pigContext.getScriptFiles().entrySet()) {
            if (!((String)entry.getKey()).endsWith(".groovy")) continue;
            jarLists.add(((File)entry.getValue()).toURI());
        }
        TezPlanContainerUDFCollector tezPlanContainerUDFCollector = new TezPlanContainerUDFCollector(this);
        tezPlanContainerUDFCollector.visit();
        Set<String> set = tezPlanContainerUDFCollector.getUdfs();
        for (String func : set) {
            String jarName;
            Class clazz = this.pigContext.getClassForAlias(func);
            if (clazz == null || (jarName = JarManager.findContainingJar(clazz)) == null) continue;
            URI jarUri = new File(jarName).toURI();
            jarLists.add(jarUri);
        }
        File scriptUDFJarFile = JarManager.createPigScriptUDFJar(this.pigContext);
        if (scriptUDFJarFile != null) {
            jarLists.add(scriptUDFJarFile.toURI());
        }
        return TezResourceManager.getInstance().addTezResources(jarLists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TezPlanContainerNode getNextPlan(List<TezOperPlan> processedPlans) {
        TezPlanContainer tezPlanContainer = this;
        synchronized (tezPlanContainer) {
            while (this.getRoots() != null) {
                if (this.getRoots().isEmpty()) return null;
                TezPlanContainerNode currentPlan = null;
                for (TezPlanContainerNode plan : this.getRoots()) {
                    if (processedPlans.contains(plan.getTezOperPlan())) continue;
                    currentPlan = plan;
                    break;
                }
                if (currentPlan != null) {
                    return currentPlan;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return null;
        }
    }

    public void addPlan(TezOperPlan plan) throws PlanException {
        TezPlanContainerNode node = new TezPlanContainerNode(this.generateNodeOperatorKey(), plan);
        this.add(node);
        this.split(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePlan(TezOperPlan plan, boolean succ) {
        TezPlanContainerNode tezPlanContainerNode = new TezPlanContainerNode(this.generateNodeOperatorKey(), plan);
        TezPlanContainer tezPlanContainer = this;
        synchronized (tezPlanContainer) {
            if (succ) {
                this.remove(tezPlanContainerNode);
            } else {
                this.trimBelow(tezPlanContainerNode);
                this.remove(tezPlanContainerNode);
            }
            this.notify();
        }
    }

    public void split(TezPlanContainerNode planNode) throws PlanException {
        TezOperPlan tezOperPlan = planNode.getTezOperPlan();
        if (tezOperPlan.size() == 1) {
            return;
        }
        List<TezOperator> opersToSegment = null;
        try {
            FirstLevelSegmentOperatorsFinder finder = new FirstLevelSegmentOperatorsFinder(tezOperPlan);
            finder.visit();
            opersToSegment = finder.getOperatorsToSegment();
        }
        catch (VisitorException e) {
            throw new PlanException(e);
        }
        if (!opersToSegment.isEmpty()) {
            ArrayList<TezOperator> succs;
            HashSet<TezOperator> commonSplitterPredecessors = new HashSet<TezOperator>();
            for (TezOperator tezOperator : opersToSegment) {
                for (TezOperator succ : tezOperPlan.getSuccessors(tezOperator)) {
                    commonSplitterPredecessors.addAll(this.getCommonSplitterPredecessors(tezOperPlan, tezOperator, succ));
                }
            }
            if (commonSplitterPredecessors.isEmpty()) {
                ArrayList allSuccs = new ArrayList();
                for (TezOperator tezOperator : opersToSegment) {
                    succs = new ArrayList<TezOperator>();
                    succs.addAll(tezOperPlan.getSuccessors(tezOperator));
                    allSuccs.addAll(succs);
                    for (TezOperator tezOperator2 : succs) {
                        tezOperPlan.disconnect(tezOperator, tezOperator2);
                    }
                }
                TezOperPlan tezOperPlan2 = new TezOperPlan();
                for (TezOperator succ : allSuccs) {
                    tezOperPlan.moveTree(succ, tezOperPlan2);
                }
                TezPlanContainerNode tezPlanContainerNode = new TezPlanContainerNode(this.generateNodeOperatorKey(), tezOperPlan2);
                this.add(tezPlanContainerNode);
                this.connect(planNode, tezPlanContainerNode);
                this.split(tezPlanContainerNode);
            } else {
                String scope = opersToSegment.get(0).getOperatorKey().getScope();
                for (TezOperator tezOperator : commonSplitterPredecessors) {
                    try {
                        succs = new ArrayList();
                        succs.addAll(tezOperPlan.getSuccessors(tezOperator));
                        FileSpec fileSpec = TezCompiler.getTempFileSpec(this.pigContext);
                        POStore pOStore = this.getTmpStore(scope, fileSpec);
                        tezOperator.plan.remove((PhysicalOperator)tezOperator.plan.getLeaves().get(0));
                        tezOperator.plan.addAsLeaf(pOStore);
                        tezOperator.segmentBelow = true;
                        tezOperator.setSplitter(false);
                        for (TezOperator tezOperator3 : succs) {
                            POLoad tmpLoad = this.getTmpLoad(scope, fileSpec);
                            tezOperator3.plan.replace((PhysicalOperator)tezOperator3.plan.getRoots().get(0), tmpLoad);
                        }
                    }
                    catch (Exception e) {
                        throw new PlanException(e);
                    }
                }
            }
            this.split(planNode);
        }
    }

    private Set<TezOperator> getCommonSplitterPredecessors(TezOperPlan plan, TezOperator operToSegment, TezOperator successor) {
        HashSet<TezOperator> splitters1 = new HashSet<TezOperator>();
        HashSet<TezOperator> splitters2 = new HashSet<TezOperator>();
        HashSet<TezOperator> processedPredecessors = new HashSet<TezOperator>();
        this.fetchSplitterPredecessors(plan, operToSegment, processedPredecessors, splitters1, false);
        if (!splitters1.isEmpty()) {
            HashSet<TezOperator> allSuccs = new HashSet<TezOperator>();
            this.getAllSuccessors(plan, successor, allSuccs);
            processedPredecessors.clear();
            processedPredecessors.add(successor);
            for (TezOperator succ : allSuccs) {
                this.fetchSplitterPredecessors(plan, succ, processedPredecessors, splitters2, true);
            }
            splitters1.retainAll(splitters2);
        }
        return splitters1;
    }

    private void fetchSplitterPredecessors(TezOperPlan plan, TezOperator tezOp, Set<TezOperator> processedPredecessors, Set<TezOperator> splitters, boolean stopAtSplit) {
        List<TezOperator> predecessors = plan.getPredecessors(tezOp);
        if (predecessors != null) {
            for (TezOperator pred : predecessors) {
                if (processedPredecessors.contains(pred)) continue;
                if (pred.isSplitter()) {
                    splitters.add(pred);
                    if (stopAtSplit) continue;
                    processedPredecessors.add(pred);
                    this.fetchSplitterPredecessors(plan, pred, processedPredecessors, splitters, stopAtSplit);
                    continue;
                }
                if (pred.needSegmentBelow()) continue;
                processedPredecessors.add(pred);
                this.fetchSplitterPredecessors(plan, pred, processedPredecessors, splitters, stopAtSplit);
            }
        }
    }

    private void getAllSuccessors(TezOperPlan plan, TezOperator tezOp, Set<TezOperator> allSuccs) {
        List<TezOperator> successors = plan.getSuccessors(tezOp);
        if (successors != null) {
            for (TezOperator succ : successors) {
                if (allSuccs.contains(succ)) continue;
                allSuccs.add(succ);
                this.getAllSuccessors(plan, succ, allSuccs);
            }
        }
    }

    private synchronized OperatorKey generateNodeOperatorKey() {
        OperatorKey opKey = new OperatorKey(this.jobName + "-" + this.dagId + "_scope", scopeId);
        ++scopeId;
        ++this.dagId;
        return opKey;
    }

    public static void resetScope() {
        scopeId = 0L;
    }

    private POLoad getTmpLoad(String scope, FileSpec fileSpec) {
        POLoad ld = new POLoad(new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)));
        ld.setPc(this.pigContext);
        ld.setIsTmpLoad(true);
        ld.setLFile(fileSpec);
        return ld;
    }

    private POStore getTmpStore(String scope, FileSpec fileSpec) {
        POStore st = new POStore(new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)));
        st.setIsTmpStore(true);
        st.setSFile(fileSpec);
        return new POStoreTez(st);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        TezPlanContainerPrinter printer = new TezPlanContainerPrinter(ps, this);
        printer.setVerbose(true);
        try {
            printer.visit();
        }
        catch (VisitorException e) {
            throw new RuntimeException(e);
        }
        return baos.toString();
    }

    private static class FirstLevelSegmentOperatorsFinder
    extends TezOpPlanVisitor {
        private List<TezOperator> opersToSegment = new ArrayList<TezOperator>();

        public FirstLevelSegmentOperatorsFinder(TezOperPlan plan) {
            super(plan, (PlanWalker<TezOperator, TezOperPlan>)new DependencyOrderWalker<TezOperator, TezOperPlan>(plan));
        }

        public List<TezOperator> getOperatorsToSegment() {
            return this.opersToSegment;
        }

        @Override
        public void visitTezOp(TezOperator tezOp) throws VisitorException {
            if (tezOp.needSegmentBelow() && ((TezOperPlan)this.getPlan()).getSuccessors(tezOp) != null) {
                if (this.opersToSegment.isEmpty()) {
                    this.opersToSegment.add(tezOp);
                } else if (!this.hasPredecessor(tezOp, this.opersToSegment)) {
                    this.opersToSegment.add(tezOp);
                }
            }
        }

        private boolean hasPredecessor(TezOperator tezOp, List<TezOperator> opsToCheck) {
            List<TezOperator> predecessors = ((TezOperPlan)this.getPlan()).getPredecessors(tezOp);
            if (predecessors != null) {
                for (TezOperator pred : predecessors) {
                    if (this.opersToSegment.contains(pred)) {
                        return true;
                    }
                    if (!this.hasPredecessor(pred, opsToCheck)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

