/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.datastorage;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.pig.backend.datastorage.SeekableInputStream;
import org.apache.pig.backend.executionengine.ExecException;

public class HSeekableInputStream
extends SeekableInputStream {
    protected FSDataInputStream input;
    protected long contentLength;

    HSeekableInputStream(FSDataInputStream input, long contentLength) {
        this.input = input;
        this.contentLength = contentLength;
    }

    @Override
    public void seek(long offset, SeekableInputStream.FLAGS whence) throws IOException {
        long targetPos;
        switch (whence) {
            case SEEK_SET: {
                targetPos = offset;
                break;
            }
            case SEEK_CUR: {
                targetPos = this.input.getPos() + offset;
                break;
            }
            case SEEK_END: {
                targetPos = this.contentLength + offset;
                break;
            }
            default: {
                int errCode = 2098;
                String msg = "Invalid seek option: " + (Object)((Object)whence);
                throw new ExecException(msg, errCode, 4);
            }
        }
        this.input.seek(targetPos);
    }

    @Override
    public long tell() throws IOException {
        return this.input.getPos();
    }

    @Override
    public int read() throws IOException {
        return this.input.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.input.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.input.read(b, off, len);
    }

    @Override
    public int available() throws IOException {
        return this.input.available();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.input.skip(n);
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public void mark(int readlimit) {
        this.input.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.input.reset();
    }

    @Override
    public boolean markSupported() {
        return this.input.markSupported();
    }
}

