/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.DefaultEditorKit;
import mondrian.gui.I18n;
import mondrian.gui.SchemaExplorer;
import mondrian.gui.Workbench;
import mondrian.gui.validate.ValidationUtils;
import mondrian.olap.Connection;
import mondrian.olap.DriverManager;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.olap.Util;
import org.apache.log4j.Logger;

public class QueryPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(QueryPanel.class);
    Connection connection;
    JMenuItem queryMenuItem;
    int windowMenuIndex;
    Map<JInternalFrame, JMenuItem> schemaWindowMap;
    final Workbench workbench;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane2;
    private JTextPane resultTextPane;
    private JScrollPane jScrollPane1;
    private JTextPane queryTextPane;
    private JSplitPane jSplitPane1;
    private JButton executeButton;
    private JComboBox schemaList;
    private JLabel schemaLabel;
    private JPanel schemaPanel;
    private JScrollPane schemaScrollPane1;
    private JButton connectButton;
    private JPopupMenu jPopupMenu;

    public QueryPanel(Workbench workbench) {
        this.workbench = workbench;
        this.initComponents();
    }

    public void setConnection(Connection c) {
        this.connection = c;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setMenuItem(JMenuItem mi) {
        this.queryMenuItem = mi;
    }

    public void setSchemaWindowMap(Map<JInternalFrame, JMenuItem> schemaWindowMap) {
        this.schemaWindowMap = schemaWindowMap;
        this.setCatalogs();
    }

    private void setCatalogs() {
        ArrayList<String> v = new ArrayList<String>();
        for (JMenuItem elem : this.schemaWindowMap.values()) {
            v.add(elem.getText());
        }
        DefaultComboBoxModel cCatalogs = new DefaultComboBoxModel(new Vector(v));
        this.schemaList.setModel(cCatalogs);
    }

    public void setWindowMenuIndex(int i) {
        this.windowMenuIndex = i;
    }

    public I18n getResourceConverter() {
        return this.workbench.getResourceConverter();
    }

    public void initConnection(String smenutext) {
        this.schemaList.setSelectedItem(smenutext);
        this.connectButtonActionPerformed(null);
    }

    private void initComponents() {
        this.jScrollPane3 = new JScrollPane();
        this.executeButton = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.queryTextPane = new JTextPane();
        this.jScrollPane2 = new JScrollPane();
        this.resultTextPane = new JTextPane();
        this.connectButton = new JButton();
        this.jPopupMenu = new JPopupMenu();
        this.jPopupMenu.add(new DefaultEditorKit.CutAction());
        this.jPopupMenu.add(new DefaultEditorKit.CopyAction());
        this.jPopupMenu.add(new DefaultEditorKit.PasteAction());
        this.schemaScrollPane1 = new JScrollPane();
        this.schemaLabel = new JLabel();
        this.schemaList = new JComboBox<String>(new String[]{this.getResourceConverter().getString("common.join.title", "Join"), this.getResourceConverter().getString("common.table.title", "Table")});
        this.schemaPanel = new JPanel();
        this.schemaPanel.setLayout(new FlowLayout(0, 10, 0));
        this.setLayout(new BorderLayout());
        this.schemaLabel.setFont(new Font("Dialog", 1, 12));
        this.schemaLabel.setForeground((Color)UIManager.getDefaults().get("CheckBoxMenuItem.acceleratorForeground"));
        this.schemaLabel.setHorizontalAlignment(0);
        this.schemaLabel.setText(this.getResourceConverter().getString("common.schema.title", "Schema"));
        this.schemaList.setBackground(Color.white);
        QueryPanel qpanel = this;
        this.schemaList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
            }
        });
        this.connectButton.setText(this.getResourceConverter().getString("queryPanel.connect.title", "Connect"));
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryPanel.this.connectButtonActionPerformed(evt);
            }
        });
        this.schemaPanel.add(this.schemaLabel);
        this.schemaPanel.add(this.schemaList);
        this.schemaPanel.add(this.connectButton);
        this.add((Component)this.schemaPanel, "North");
        this.executeButton.setText(this.getResourceConverter().getString("queryPanel.execute.title", "Execute"));
        this.executeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryPanel.this.executeButtonActionPerformed(evt);
            }
        });
        this.add((Component)this.executeButton, "South");
        this.jSplitPane1.setDividerLocation(100);
        this.jSplitPane1.setOrientation(0);
        this.queryTextPane.setFont(new Font("Courier New", 0, 12));
        this.queryTextPane.setText("");
        this.queryTextPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.checkPopupTrigger(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.checkPopupTrigger(e);
            }

            public void checkPopupTrigger(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int x = e.getX();
                    int y = e.getY();
                    QueryPanel.this.jPopupMenu.show(QueryPanel.this.queryTextPane, x, y);
                }
            }
        });
        this.jScrollPane1.setViewportView(this.queryTextPane);
        this.jSplitPane1.setTopComponent(this.jScrollPane1);
        this.resultTextPane.setEditable(false);
        this.resultTextPane.setFont(new Font("Courier New", 0, 12));
        this.jScrollPane2.setViewportView(this.resultTextPane);
        this.jSplitPane1.setBottomComponent(this.jScrollPane2);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void executeButtonActionPerformed(ActionEvent evt) {
        try {
            if (this.connection == null) {
                JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("queryPanel.noConnection.alert", "No Mondrian connection. Select a Schema to connect."), this.getResourceConverter().getString("common.alertDialog.title", "Alert"), 2);
                return;
            }
            Query q = this.connection.parseQuery(this.queryTextPane.getText());
            Result r = this.connection.execute(q);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            r.print(pw);
            this.resultTextPane.setText(sw.getBuffer().toString());
        }
        catch (Exception ex) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PrintStream p = new PrintStream(os);
            for (Throwable e = ex; e != null; e = e.getCause()) {
                p.println(e.getLocalizedMessage());
                LOGGER.error((Object)"", e);
                Exception prev = e;
                if (e == prev) break;
                p.println();
            }
            this.resultTextPane.setText(os.toString());
        }
    }

    private void connectButtonActionPerformed(ActionEvent evt) {
        File sfile = null;
        try {
            String jdbcPassword;
            String sfname = (String)this.schemaList.getSelectedItem();
            JInternalFrame sf = this.lookupFrame(sfname);
            if (sf == null) {
                JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("queryPanel.schemaNotOpen.alert", "Schema file is not open"), this.getResourceConverter().getString("common.errorDialog.title", "Error"), 0);
                return;
            }
            SchemaExplorer se = (SchemaExplorer)sf.getContentPane().getComponent(0);
            if (se.isNewFile()) {
                JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("queryPanel.saveSchemaFirst.alert", "You must first save the Schema to open a Mondrian connection"), this.getResourceConverter().getString("common.alertDialog.title", "Alert"), 2);
                sf.setSelected(true);
                return;
            }
            sfile = se.getSchemaFile();
            Util.PropertyList list = new Util.PropertyList();
            list.put("Provider", "mondrian");
            list.put("Jdbc", se.getJdbcConnectionUrl());
            list.put("Catalog", se.getSchemaFile().toURL().toString());
            String jdbcUsername = se.getJdbcUsername();
            if (!ValidationUtils.isEmpty(jdbcUsername)) {
                list.put("JdbcUser", jdbcUsername);
            }
            if (!ValidationUtils.isEmpty(jdbcPassword = se.getJdbcPassword())) {
                list.put("JdbcPassword", jdbcPassword);
            }
            Connection con = DriverManager.getConnection((Util.PropertyList)list, null);
            con.getCacheControl(null).flushSchemaCache();
            if (con != null) {
                this.connection = con;
                this.queryMenuItem.setText(this.getResourceConverter().getFormattedString("queryPanel.successfulConnection.menuItem", "{0} MDX - {1}", Integer.toString(this.windowMenuIndex), se.getSchemaFile().getName()));
                for (Container o = this; o != null; o = o.getParent()) {
                    if (o.getClass() != JInternalFrame.class) continue;
                    ((JInternalFrame)o).setTitle(this.getResourceConverter().getFormattedString("queryPanel.successfulConnection.internalFrame.title", "MDX Query - connected to {0}", se.getSchemaFile().getName()));
                    break;
                }
                JOptionPane.showMessageDialog(this, "Mondrian connection Successful.", this.getResourceConverter().getString("common.informationDialog.title", "Information"), 1);
            } else {
                JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("queryPanel.unsuccessfulConnection.alert", "Mondrian connection could not be done for - {0}", se.getSchemaFile().getName()), this.getResourceConverter().getString("common.errorDialog.title", "Error"), 0);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Exception: " + ex.getMessage()), (Throwable)ex);
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("queryPanel.unsuccessfulConnection.exception", "Mondrian connection could not be done for - {0}", sfile == null ? this.getResourceConverter().getString("queryPanel.selectedSchema.alert", "selected Schema") : sfile.getName()), this.getResourceConverter().getString("common.errorDialog.title", "Error"), 0);
            this.resultTextPane.setText(this.getResourceConverter().getFormattedString("queryPanel.exceptionMessage", "Exception: {0}\n\nSee workbench log for full stacktrace.", ex.getMessage()));
        }
    }

    private JInternalFrame lookupFrame(String sfname) {
        JInternalFrame sf = null;
        for (Map.Entry<JInternalFrame, JMenuItem> entry : this.schemaWindowMap.entrySet()) {
            if (!entry.getValue().getText().equals(sfname)) continue;
            sf = entry.getKey();
            break;
        }
        return sf;
    }
}

