/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.models.annotations;

import org.apache.commons.lang.StringUtils;
import org.pentaho.agilebi.modeler.BaseModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.models.annotations.AnnotationType;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.ModelProperty;
import org.pentaho.agilebi.modeler.models.annotations.util.MondrianSchemaHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.persist.MetaStoreAttribute;
import org.w3c.dom.Document;

public class ShowHideMeasure
extends AnnotationType {
    protected static final Class<?> MSG_CLASS = BaseModelerWorkspaceHelper.class;
    public static final String NAME_ID = "name";
    public static final String NAME_NAME = "Measure Name";
    public static final int NAME_ORDER = 0;
    public static final String CUBE_ID = "cube";
    public static final String CUBE_NAME = "Cube Name";
    public static final int CUBE_ORDER = 1;
    public static final String VISIBLE_ID = "visible";
    public static final String VISIBLE_NAME = "Visible";
    public static final int VISIBLE_ORDER = 2;
    @MetaStoreAttribute
    @ModelProperty(id="name", name="Measure Name", order=0)
    protected String name;
    @MetaStoreAttribute
    @ModelProperty(id="cube", name="Cube Name", order=1)
    protected String cube;
    @MetaStoreAttribute
    @ModelProperty(id="visible", name="Visible", order=2)
    protected boolean visible = false;

    @Override
    public boolean apply(ModelerWorkspace workspace, IMetaStore metaStore) throws ModelerException {
        return false;
    }

    @Override
    public boolean apply(Document schema) throws ModelerException {
        MondrianSchemaHandler mondrianSchemaHandler = new MondrianSchemaHandler(schema);
        return mondrianSchemaHandler.showHideMeasure(this.getCube(), this.getName(), this.isVisible());
    }

    @Override
    public void validate() throws ModelerException {
        if (StringUtils.isBlank((String)this.getCube())) {
            throw new ModelerException(BaseMessages.getString(MSG_CLASS, (String)"ModelAnnotation.ShowHide.validation.CUBE_NAME_REQUIRED", (String[])new String[0]));
        }
        if (StringUtils.isBlank((String)this.getName())) {
            throw new ModelerException(BaseMessages.getString(MSG_CLASS, (String)"ModelAnnotation.ShowHide.validation.MEASURE_NAME_REQUIRED", (String[])new String[0]));
        }
    }

    @Override
    public ModelAnnotation.Type getType() {
        return ModelAnnotation.Type.SHOW_HIDE_MEASURE;
    }

    @Override
    public String getSummary() {
        return BaseMessages.getString(MSG_CLASS, (String)(this.isVisible() ? "Modeler.ShowMeasure.Summary" : "Modeler.HideMeasure.Summary"), (String[])new String[]{this.getName(), this.getCube()});
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getField() {
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCube(String cube) {
        this.cube = cube;
    }

    public String getCube() {
        return this.cube;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

