/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.pentaho.plugin.jfreereport.reportcharts.BaseCollectorFunction;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.Function;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;

public class XYSeriesCollectorFunction
extends BaseCollectorFunction {
    private static final long serialVersionUID = -8138304452870844825L;
    private ArrayList xValueColumns = new ArrayList();
    private ArrayList yValueColumns = new ArrayList();

    public void setxValueColumn(int index, String field) {
        if (this.xValueColumns.size() == index) {
            this.xValueColumns.add(field);
        } else {
            this.xValueColumns.set(index, field);
        }
    }

    public void setyValueColumn(int index, String field) {
        if (this.yValueColumns.size() == index) {
            this.yValueColumns.add(field);
        } else {
            this.yValueColumns.set(index, field);
        }
    }

    public String getxValueColumn(int index) {
        return (String)this.xValueColumns.get(index);
    }

    public int getxValueColumnCount() {
        return this.xValueColumns.size();
    }

    public String[] getxValueColumn() {
        return this.xValueColumns.toArray(new String[this.xValueColumns.size()]);
    }

    public void setxValueColumn(String[] fields) {
        this.xValueColumns.clear();
        this.xValueColumns.addAll(Arrays.asList(fields));
    }

    public String getyValueColumn(int index) {
        return (String)this.yValueColumns.get(index);
    }

    public int getyValueColumnCount() {
        return this.yValueColumns.size();
    }

    public String[] getyValueColumn() {
        return this.yValueColumns.toArray(new String[this.yValueColumns.size()]);
    }

    public void setyValueColumn(String[] fields) {
        this.yValueColumns.clear();
        this.yValueColumns.addAll(Arrays.asList(fields));
    }

    public void itemsAdvanced(ReportEvent reportEvent) {
        if (!FunctionUtilities.isDefinedPrepareRunLevel((Function)this, (ReportEvent)reportEvent)) {
            return;
        }
        if (!this.isSummaryOnly()) {
            this.buildDataset();
        }
    }

    public void groupFinished(ReportEvent reportEvent) {
        if (!FunctionUtilities.isDefinedPrepareRunLevel((Function)this, (ReportEvent)reportEvent)) {
            return;
        }
        if (this.isSummaryOnly() && FunctionUtilities.isDefinedGroup((String)this.getGroup(), (ReportEvent)reportEvent)) {
            this.buildDataset();
        }
    }

    protected void buildDataset() {
        XYSeriesCollection xySeriesDataset = (XYSeriesCollection)this.getDatasourceValue();
        List seriesList = xySeriesDataset.getSeries();
        HashMap<Object, XYSeries> seriesMap = new HashMap<Object, XYSeries>();
        for (int i = 0; i < seriesList.size(); ++i) {
            XYSeries series = (XYSeries)seriesList.get(i);
            seriesMap.put(series.getKey(), series);
        }
        String[] seriesNames = this.getSeriesName();
        int maxIndex = Math.min(seriesNames.length, Math.min(this.xValueColumns.size(), this.yValueColumns.size()));
        for (int i = 0; i < maxIndex; ++i) {
            Object tmp;
            String seriesName = seriesNames[i];
            String xColumn = (String)this.xValueColumns.get(i);
            String yColumn = (String)this.yValueColumns.get(i);
            Object xValueObject = this.getDataRow().get(xColumn);
            Object yValueObject = this.getDataRow().get(yColumn);
            if (this.isSeriesColumn() && (tmp = this.getDataRow().get(seriesName)) != null) {
                seriesName = tmp.toString();
            }
            if (!(xValueObject instanceof Number)) continue;
            Number xValue = (Number)xValueObject;
            Number yValue = yValueObject instanceof Number ? (Number)((Number)yValueObject) : (Number)null;
            XYSeries series = (XYSeries)seriesMap.get(seriesName);
            if (series == null) {
                series = new XYSeries((Comparable)((Object)seriesName));
                xySeriesDataset.addSeries(series);
                seriesMap.put(seriesName, series);
            }
            series.add(xValue, yValue);
        }
    }

    @Override
    public Dataset createNewDataset() {
        return new XYSeriesCollection();
    }

    @Override
    public Expression getInstance() {
        XYSeriesCollectorFunction fn = (XYSeriesCollectorFunction)super.getInstance();
        fn.xValueColumns = (ArrayList)this.xValueColumns.clone();
        fn.yValueColumns = (ArrayList)this.yValueColumns.clone();
        return fn;
    }
}

