/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.pentaho.plugin.jfreereport.reportcharts.CategoricalChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.backport.FormattedCategoryAxis;
import org.pentaho.plugin.jfreereport.reportcharts.backport.FormattedCategoryAxis3D;

public class LineChartExpression
extends CategoricalChartExpression {
    private static final long serialVersionUID = 816438776025760907L;
    private String lineStyle;
    private float lineWidth = 1.0f;
    private boolean markersVisible = false;

    @Override
    protected JFreeChart computeCategoryChart(CategoryDataset dataset) {
        PlotOrientation orientation = this.computePlotOrientation();
        if (this.isThreeD()) {
            JFreeChart chart = ChartFactory.createLineChart3D((String)this.computeTitle(), (String)this.getCategoryAxisLabel(), (String)this.getValueAxisLabel(), (CategoryDataset)dataset, (PlotOrientation)orientation, (boolean)this.isShowLegend(), (boolean)false, (boolean)false);
            chart.getCategoryPlot().setDomainAxis((CategoryAxis)new FormattedCategoryAxis3D(this.getCategoryAxisLabel(), this.getCategoricalAxisMessageFormat(), this.getRuntime().getResourceBundleFactory().getLocale()));
            CategoryPlot plot = (CategoryPlot)chart.getPlot();
            this.configureLogarithmicAxis(plot);
            return chart;
        }
        JFreeChart chart = ChartFactory.createLineChart((String)this.computeTitle(), (String)this.getCategoryAxisLabel(), (String)this.getValueAxisLabel(), (CategoryDataset)dataset, (PlotOrientation)orientation, (boolean)this.isShowLegend(), (boolean)false, (boolean)false);
        chart.getCategoryPlot().setDomainAxis((CategoryAxis)new FormattedCategoryAxis(this.getCategoryAxisLabel(), this.getCategoricalAxisMessageFormat(), this.getRuntime().getResourceBundleFactory().getLocale()));
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        this.configureLogarithmicAxis(plot);
        return chart;
    }

    @Override
    protected void configureChart(JFreeChart chart) {
        super.configureChart(chart);
        CategoryPlot cpl = chart.getCategoryPlot();
        CategoryItemRenderer renderer = cpl.getRenderer();
        renderer.setStroke(LineChartExpression.translateLineStyle(this.lineWidth, this.lineStyle));
        if (renderer instanceof LineAndShapeRenderer) {
            LineAndShapeRenderer shapeRenderer = (LineAndShapeRenderer)renderer;
            shapeRenderer.setShapesVisible(this.isMarkersVisible());
            shapeRenderer.setBaseShapesFilled(this.isMarkersVisible());
        }
    }

    public String getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(String value) {
        this.lineStyle = value;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float value) {
        this.lineWidth = value;
    }

    public boolean isMarkersVisible() {
        return this.markersVisible;
    }

    public void setMarkersVisible(boolean markersVisible) {
        this.markersVisible = markersVisible;
    }
}

