/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYStepAreaRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.pentaho.plugin.jfreereport.reportcharts.XYLineChartExpression;

public class ExtendedXYLineChartExpression
extends XYLineChartExpression {
    public static final String STEP_CHART_STR = "StepChart";
    public static final String STEP_AREA_CHART_STR = "StepAreaChart";
    public static final String DIFFERENCE_CHART_STR = "DifferenceChart";
    private static final long serialVersionUID = -167639029520233427L;
    private String chartType = null;

    @Override
    protected JFreeChart computeXYChart(XYDataset xyDataset) {
        JFreeChart rtn;
        if (xyDataset instanceof TimeSeriesCollection) {
            rtn = ChartFactory.createTimeSeriesChart((String)this.computeTitle(), (String)this.getDomainTitle(), (String)this.getRangeTitle(), (XYDataset)xyDataset, (boolean)this.isShowLegend(), (boolean)false, (boolean)false);
        } else {
            PlotOrientation orientation = this.computePlotOrientation();
            rtn = ChartFactory.createXYLineChart((String)this.computeTitle(), (String)this.getDomainTitle(), (String)this.getRangeTitle(), (XYDataset)xyDataset, (PlotOrientation)orientation, (boolean)this.isShowLegend(), (boolean)false, (boolean)false);
        }
        String chartType = this.getChartType();
        if (STEP_AREA_CHART_STR.equals(chartType)) {
            XYStepAreaRenderer renderer = this.isMarkersVisible() ? new XYStepAreaRenderer(3) : new XYStepAreaRenderer(2);
            rtn.getXYPlot().setRenderer((XYItemRenderer)renderer);
        } else if (STEP_CHART_STR.equals(chartType)) {
            rtn.getXYPlot().setRenderer((XYItemRenderer)new XYStepRenderer(null, null));
        } else if (DIFFERENCE_CHART_STR.equals(chartType)) {
            rtn.getXYPlot().setRenderer((XYItemRenderer)new XYDifferenceRenderer());
        }
        this.configureLogarithmicAxis(rtn.getXYPlot());
        return rtn;
    }

    public String getChartType() {
        return this.chartType;
    }

    public void setChartType(String chartType) {
        this.chartType = chartType;
    }
}

