/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.common.annotations.VisibleForTesting;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hadoop.hbase.util.SimplePositionedMutableByteRange;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class OrderedBytes {
    private static final byte NULL = 5;
    private static final byte NEG_INF = 7;
    private static final byte NEG_LARGE = 8;
    private static final byte NEG_MED_MIN = 9;
    private static final byte NEG_MED_MAX = 19;
    private static final byte NEG_SMALL = 20;
    private static final byte ZERO = 21;
    private static final byte POS_SMALL = 22;
    private static final byte POS_MED_MIN = 23;
    private static final byte POS_MED_MAX = 33;
    private static final byte POS_LARGE = 34;
    private static final byte POS_INF = 35;
    private static final byte NAN = 38;
    private static final byte FIXED_INT8 = 41;
    private static final byte FIXED_INT16 = 42;
    private static final byte FIXED_INT32 = 43;
    private static final byte FIXED_INT64 = 44;
    private static final byte FIXED_FLOAT32 = 48;
    private static final byte FIXED_FLOAT64 = 49;
    private static final byte TEXT = 52;
    private static final byte BLOB_VAR = 55;
    private static final byte BLOB_COPY = 56;
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private static final byte TERM = 0;
    private static final BigDecimal E8 = BigDecimal.valueOf(1.0E8);
    private static final BigDecimal E32 = BigDecimal.valueOf(1.0E32);
    private static final BigDecimal EN2 = BigDecimal.valueOf(0.01);
    private static final BigDecimal EN10 = BigDecimal.valueOf(1.0E-10);
    public static final int MAX_PRECISION = 31;
    public static final MathContext DEFAULT_MATH_CONTEXT = new MathContext(31, RoundingMode.HALF_UP);

    private static IllegalArgumentException unexpectedHeader(byte header) {
        throw new IllegalArgumentException("unexpected value in first byte: 0x" + Long.toHexString(header));
    }

    private static int unsignedCmp(long x1, long x2) {
        int cmp;
        if ((x1 < x2 ? -1 : (cmp = x1 == x2 ? 0 : 1)) == 0) {
            return 0;
        }
        if (x1 < 0L != x2 < 0L) {
            return -cmp;
        }
        return cmp;
    }

    private static int putUint32(PositionedByteRange dst, int val) {
        dst.put((byte)(val >>> 24)).put((byte)(val >>> 16)).put((byte)(val >>> 8)).put((byte)val);
        return 4;
    }

    @VisibleForTesting
    static int putVaruint64(PositionedByteRange dst, long val, boolean comp) {
        Order ord;
        int len = 0;
        int offset = dst.getOffset();
        int start = dst.getPosition();
        byte[] a = dst.getBytes();
        Order order = ord = comp ? Order.DESCENDING : Order.ASCENDING;
        if (-1 == OrderedBytes.unsignedCmp(val, 241L)) {
            dst.put((byte)val);
            len = dst.getPosition() - start;
            ord.apply(a, offset + start, len);
            return len;
        }
        if (-1 == OrderedBytes.unsignedCmp(val, 2288L)) {
            int y = (int)(val - 240L);
            dst.put((byte)(y / 256 + 241)).put((byte)(y % 256));
            len = dst.getPosition() - start;
            ord.apply(a, offset + start, len);
            return len;
        }
        if (-1 == OrderedBytes.unsignedCmp(val, 67824L)) {
            int y = (int)(val - 2288L);
            dst.put((byte)-7).put((byte)(y / 256)).put((byte)(y % 256));
            len = dst.getPosition() - start;
            ord.apply(a, offset + start, len);
            return len;
        }
        int y = (int)val;
        int w = (int)(val >>> 32);
        if (w == 0) {
            if (-1 == OrderedBytes.unsignedCmp(y, 0x1000000L)) {
                dst.put((byte)-6).put((byte)(y >>> 16)).put((byte)(y >>> 8)).put((byte)y);
                len = dst.getPosition() - start;
                ord.apply(a, offset + start, len);
                return len;
            }
            dst.put((byte)-5);
            OrderedBytes.putUint32(dst, y);
            len = dst.getPosition() - start;
            ord.apply(a, offset + start, len);
            return len;
        }
        if (-1 == OrderedBytes.unsignedCmp(w, 256L)) {
            dst.put((byte)-4).put((byte)w);
            OrderedBytes.putUint32(dst, y);
            len = dst.getPosition() - start;
            ord.apply(a, offset + start, len);
            return len;
        }
        if (-1 == OrderedBytes.unsignedCmp(w, 65536L)) {
            dst.put((byte)-3).put((byte)(w >>> 8)).put((byte)w);
            OrderedBytes.putUint32(dst, y);
            len = dst.getPosition() - start;
            ord.apply(a, offset + start, len);
            return len;
        }
        if (-1 == OrderedBytes.unsignedCmp(w, 0x1000000L)) {
            dst.put((byte)-2).put((byte)(w >>> 16)).put((byte)(w >>> 8)).put((byte)w);
            OrderedBytes.putUint32(dst, y);
            len = dst.getPosition() - start;
            ord.apply(a, offset + start, len);
            return len;
        }
        dst.put((byte)-1);
        OrderedBytes.putUint32(dst, w);
        OrderedBytes.putUint32(dst, y);
        len = dst.getPosition() - start;
        ord.apply(a, offset + start, len);
        return len;
    }

    @VisibleForTesting
    static int lengthVaruint64(PositionedByteRange src, boolean comp) {
        int a0 = (comp ? Order.DESCENDING : Order.ASCENDING).apply(src.peek()) & 0xFF;
        if (a0 <= 240) {
            return 1;
        }
        if (a0 >= 241 && a0 <= 248) {
            return 2;
        }
        if (a0 == 249) {
            return 3;
        }
        if (a0 == 250) {
            return 4;
        }
        if (a0 == 251) {
            return 5;
        }
        if (a0 == 252) {
            return 6;
        }
        if (a0 == 253) {
            return 7;
        }
        if (a0 == 254) {
            return 8;
        }
        if (a0 == 255) {
            return 9;
        }
        throw OrderedBytes.unexpectedHeader(src.peek());
    }

    @VisibleForTesting
    static int skipVaruint64(PositionedByteRange src, boolean cmp) {
        int len = OrderedBytes.lengthVaruint64(src, cmp);
        src.setPosition(src.getPosition() + len);
        return len;
    }

    @VisibleForTesting
    static long getVaruint64(PositionedByteRange src, boolean comp) {
        byte x;
        assert (src.getRemaining() >= OrderedBytes.lengthVaruint64(src, comp));
        Order ord = comp ? Order.DESCENDING : Order.ASCENDING;
        int a0 = ord.apply(x = src.get()) & 0xFF;
        if (-1 == OrderedBytes.unsignedCmp(a0, 241L)) {
            return a0;
        }
        x = src.get();
        int a1 = ord.apply(x) & 0xFF;
        if (-1 == OrderedBytes.unsignedCmp(a0, 249L)) {
            return (a0 - 241) * 256 + a1 + 240;
        }
        x = src.get();
        int a2 = ord.apply(x) & 0xFF;
        if (a0 == 249) {
            return 2288 + 256 * a1 + a2;
        }
        x = src.get();
        int a3 = ord.apply(x) & 0xFF;
        if (a0 == 250) {
            return a1 << 16 | a2 << 8 | a3;
        }
        x = src.get();
        int a4 = ord.apply(x) & 0xFF;
        long ret = (long)a1 << 24 | (long)(a2 << 16) | (long)(a3 << 8) | (long)a4;
        if (a0 == 251) {
            return ret;
        }
        x = src.get();
        int a5 = ord.apply(x) & 0xFF;
        if (a0 == 252) {
            return ret << 8 | (long)a5;
        }
        x = src.get();
        int a6 = ord.apply(x) & 0xFF;
        if (a0 == 253) {
            return ret << 16 | (long)(a5 << 8) | (long)a6;
        }
        x = src.get();
        int a7 = ord.apply(x) & 0xFF;
        if (a0 == 254) {
            return ret << 24 | (long)(a5 << 16) | (long)(a6 << 8) | (long)a7;
        }
        x = src.get();
        int a8 = ord.apply(x) & 0xFF;
        return ret << 32 | (long)a5 << 24 | (long)(a6 << 16) | (long)(a7 << 8) | (long)a8;
    }

    @VisibleForTesting
    static BigDecimal normalize(BigDecimal val) {
        return null == val ? null : val.stripTrailingZeros().round(DEFAULT_MATH_CONTEXT);
    }

    private static BigDecimal decodeSignificand(PositionedByteRange src, int e, boolean comp) {
        byte[] a = src.getBytes();
        int start = src.getPosition();
        int offset = src.getOffset();
        int remaining = src.getRemaining();
        Order ord = comp ? Order.DESCENDING : Order.ASCENDING;
        BigDecimal m = BigDecimal.ZERO;
        --e;
        int i = 0;
        while (true) {
            if (i > remaining) {
                src.setPosition(start);
                throw new IllegalArgumentException("Read exceeds range before termination byte found. offset: " + offset + " position: " + (start + i));
            }
            m = m.add(new BigDecimal(BigInteger.ONE, e * -2).multiply(BigDecimal.valueOf((ord.apply(a[offset + start + i]) & 0xFF) / 2)));
            --e;
            if ((ord.apply(a[offset + start + i]) & 1) == 0) break;
            ++i;
        }
        src.setPosition(start + i + 1);
        return OrderedBytes.normalize(m);
    }

    private static int skipSignificand(PositionedByteRange src, boolean comp) {
        byte[] a = src.getBytes();
        int offset = src.getOffset();
        int start = src.getPosition();
        int i = src.getPosition();
        while (((comp ? Order.DESCENDING : Order.ASCENDING).apply(a[offset + i++]) & 1) != 0) {
        }
        src.setPosition(i);
        return i - start;
    }

    private static int encodeNumericSmall(PositionedByteRange dst, BigDecimal val) {
        BigDecimal abs = val.abs();
        assert (BigDecimal.ZERO.compareTo(abs) < 0 && BigDecimal.ONE.compareTo(abs) > 0);
        byte[] a = dst.getBytes();
        boolean isNeg = val.signum() == -1;
        int offset = dst.getOffset();
        int start = dst.getPosition();
        int e = 0;
        if (isNeg) {
            dst.put((byte)20);
        } else {
            dst.put((byte)22);
        }
        while (abs.compareTo(EN10) < 0) {
            abs = abs.movePointRight(8);
            e += 4;
        }
        while (abs.compareTo(EN2) < 0) {
            abs = abs.movePointRight(2);
            ++e;
        }
        OrderedBytes.putVaruint64(dst, e, !isNeg);
        int startM = dst.getPosition();
        for (int i = 0; i < 18 && abs.compareTo(BigDecimal.ZERO) != 0; ++i) {
            abs = abs.movePointRight(2);
            int d = abs.intValue();
            dst.put((byte)(2 * d + 1 & 0xFF));
            abs = abs.subtract(BigDecimal.valueOf(d));
        }
        int n = offset + dst.getPosition() - 1;
        a[n] = (byte)(a[n] & 0xFE);
        if (isNeg) {
            Order.DESCENDING.apply(a, offset + startM, dst.getPosition() - startM);
        }
        return dst.getPosition() - start;
    }

    private static int encodeNumericLarge(PositionedByteRange dst, BigDecimal val) {
        BigDecimal abs = val.abs();
        byte[] a = dst.getBytes();
        boolean isNeg = val.signum() == -1;
        int start = dst.getPosition();
        int offset = dst.getOffset();
        int e = 0;
        if (isNeg) {
            dst.put((byte)8);
        } else {
            dst.put((byte)34);
        }
        while (abs.compareTo(E32) >= 0 && e <= 350) {
            abs = abs.movePointLeft(32);
            e += 16;
        }
        while (abs.compareTo(E8) >= 0 && e <= 350) {
            abs = abs.movePointLeft(8);
            e += 4;
        }
        while (abs.compareTo(BigDecimal.ONE) >= 0 && e <= 350) {
            abs = abs.movePointLeft(2);
            ++e;
        }
        if (e > 10) {
            OrderedBytes.putVaruint64(dst, e, isNeg);
        } else if (isNeg) {
            dst.put(start, (byte)(19 - e));
        } else {
            dst.put(start, (byte)(23 + e));
        }
        int startM = dst.getPosition();
        for (int i = 0; i < 18 && abs.compareTo(BigDecimal.ZERO) != 0; ++i) {
            abs = abs.movePointRight(2);
            int d = abs.intValue();
            dst.put((byte)(2 * d + 1));
            abs = abs.subtract(BigDecimal.valueOf(d));
        }
        int n = offset + dst.getPosition() - 1;
        a[n] = (byte)(a[n] & 0xFE);
        if (isNeg) {
            Order.DESCENDING.apply(a, offset + startM, dst.getPosition() - startM);
        }
        return dst.getPosition() - start;
    }

    public static int encodeNumeric(PositionedByteRange dst, long val, Order ord) {
        return OrderedBytes.encodeNumeric(dst, BigDecimal.valueOf(val), ord);
    }

    public static int encodeNumeric(PositionedByteRange dst, double val, Order ord) {
        if (val == 0.0) {
            dst.put(ord.apply((byte)21));
            return 1;
        }
        if (Double.isNaN(val)) {
            dst.put(ord.apply((byte)38));
            return 1;
        }
        if (val == Double.NEGATIVE_INFINITY) {
            dst.put(ord.apply((byte)7));
            return 1;
        }
        if (val == Double.POSITIVE_INFINITY) {
            dst.put(ord.apply((byte)35));
            return 1;
        }
        return OrderedBytes.encodeNumeric(dst, BigDecimal.valueOf(val), ord);
    }

    public static int encodeNumeric(PositionedByteRange dst, BigDecimal val, Order ord) {
        int offset = dst.getOffset();
        int start = dst.getPosition();
        if (null == val) {
            return OrderedBytes.encodeNull(dst, ord);
        }
        if (BigDecimal.ZERO.compareTo(val) == 0) {
            dst.put(ord.apply((byte)21));
            return 1;
        }
        BigDecimal abs = val.abs();
        int len = BigDecimal.ONE.compareTo(abs) <= 0 ? OrderedBytes.encodeNumericLarge(dst, OrderedBytes.normalize(val)) : OrderedBytes.encodeNumericSmall(dst, OrderedBytes.normalize(val));
        ord.apply(dst.getBytes(), offset + start, len);
        return len;
    }

    private static BigDecimal decodeNumericValue(PositionedByteRange src) {
        byte header = src.get();
        boolean dsc = -1 == Integer.signum(header);
        byte by = header = dsc ? Order.DESCENDING.apply(header) : header;
        if (header == 5) {
            return null;
        }
        if (header == 8) {
            int e = (int)OrderedBytes.getVaruint64(src, !dsc);
            return OrderedBytes.decodeSignificand(src, e, !dsc).negate();
        }
        if (header >= 9 && header <= 19) {
            int e = 19 - header;
            return OrderedBytes.decodeSignificand(src, e, !dsc).negate();
        }
        if (header == 20) {
            int e = (int)(-OrderedBytes.getVaruint64(src, dsc));
            return OrderedBytes.decodeSignificand(src, e, !dsc).negate();
        }
        if (header == 21) {
            return BigDecimal.ZERO;
        }
        if (header == 22) {
            int e = (int)(-OrderedBytes.getVaruint64(src, !dsc));
            return OrderedBytes.decodeSignificand(src, e, dsc);
        }
        if (header >= 23 && header <= 33) {
            int e = header - 23;
            return OrderedBytes.decodeSignificand(src, e, dsc);
        }
        if (header == 34) {
            int e = (int)OrderedBytes.getVaruint64(src, dsc);
            return OrderedBytes.decodeSignificand(src, e, dsc);
        }
        throw OrderedBytes.unexpectedHeader(header);
    }

    public static double decodeNumericAsDouble(PositionedByteRange src) {
        byte header;
        if (OrderedBytes.isNull(src)) {
            throw new NullPointerException("A null value cannot be decoded to a double.");
        }
        if (OrderedBytes.isNumericNaN(src)) {
            src.get();
            return Double.NaN;
        }
        if (OrderedBytes.isNumericZero(src)) {
            src.get();
            return 0.0;
        }
        byte by = header = -1 == Integer.signum(src.peek()) ? Order.DESCENDING.apply(src.peek()) : src.peek();
        if (header == 7) {
            src.get();
            return Double.NEGATIVE_INFINITY;
        }
        if (header == 35) {
            src.get();
            return Double.POSITIVE_INFINITY;
        }
        return OrderedBytes.decodeNumericValue(src).doubleValue();
    }

    public static long decodeNumericAsLong(PositionedByteRange src) {
        if (OrderedBytes.isNull(src)) {
            throw new NullPointerException();
        }
        if (!OrderedBytes.isNumeric(src)) {
            throw OrderedBytes.unexpectedHeader(src.peek());
        }
        if (OrderedBytes.isNumericNaN(src)) {
            throw OrderedBytes.unexpectedHeader(src.peek());
        }
        if (OrderedBytes.isNumericInfinite(src)) {
            throw OrderedBytes.unexpectedHeader(src.peek());
        }
        if (OrderedBytes.isNumericZero(src)) {
            src.get();
            return 0L;
        }
        return OrderedBytes.decodeNumericValue(src).longValue();
    }

    public static BigDecimal decodeNumericAsBigDecimal(PositionedByteRange src) {
        if (OrderedBytes.isNull(src)) {
            src.get();
            return null;
        }
        if (!OrderedBytes.isNumeric(src)) {
            throw OrderedBytes.unexpectedHeader(src.peek());
        }
        if (OrderedBytes.isNumericNaN(src)) {
            throw OrderedBytes.unexpectedHeader(src.peek());
        }
        if (OrderedBytes.isNumericInfinite(src)) {
            throw OrderedBytes.unexpectedHeader(src.peek());
        }
        return OrderedBytes.decodeNumericValue(src);
    }

    public static int encodeString(PositionedByteRange dst, String val, Order ord) {
        if (null == val) {
            return OrderedBytes.encodeNull(dst, ord);
        }
        if (val.contains("\u0000")) {
            throw new IllegalArgumentException("Cannot encode String values containing '\\u0000'");
        }
        int offset = dst.getOffset();
        int start = dst.getPosition();
        dst.put((byte)52);
        dst.put(val.getBytes(UTF8));
        dst.put((byte)0);
        ord.apply(dst.getBytes(), offset + start, dst.getPosition() - start);
        return dst.getPosition() - start;
    }

    public static String decodeString(PositionedByteRange src) {
        int rawStartPos;
        byte header = src.get();
        if (header == 5 || header == Order.DESCENDING.apply((byte)5)) {
            return null;
        }
        assert (header == 52 || header == Order.DESCENDING.apply((byte)52));
        Order ord = header == 52 ? Order.ASCENDING : Order.DESCENDING;
        byte[] a = src.getBytes();
        int offset = src.getOffset();
        int start = src.getPosition();
        byte terminator = ord.apply((byte)0);
        int rawTermPos = rawStartPos = offset + start;
        while (a[rawTermPos] != terminator) {
            ++rawTermPos;
        }
        src.setPosition(rawTermPos - offset + 1);
        if (Order.DESCENDING == ord) {
            byte[] copy = new byte[rawTermPos - rawStartPos];
            System.arraycopy(a, rawStartPos, copy, 0, copy.length);
            ord.apply(copy);
            return new String(copy, UTF8);
        }
        return new String(a, rawStartPos, rawTermPos - rawStartPos, UTF8);
    }

    public static int blobVarEncodedLength(int len) {
        if (0 == len) {
            return 2;
        }
        return (int)Math.ceil((double)(len * 8) / 7.0) + 1;
    }

    @VisibleForTesting
    static int blobVarDecodedLength(int len) {
        return (len - 1) * 7 / 8;
    }

    public static int encodeBlobVar(PositionedByteRange dst, byte[] val, int voff, int vlen, Order ord) {
        if (null == val) {
            return OrderedBytes.encodeNull(dst, ord);
        }
        assert (dst.getRemaining() >= OrderedBytes.blobVarEncodedLength(vlen)) : "buffer overflow expected.";
        int offset = dst.getOffset();
        int start = dst.getPosition();
        dst.put((byte)55);
        if (0 == vlen) {
            dst.put((byte)0);
        } else {
            int s = 1;
            int t = 0;
            for (int i = voff; i < vlen; ++i) {
                dst.put((byte)(0x80 | t | (val[i] & 0xFF) >>> s));
                if (s < 7) {
                    t = (byte)(val[i] << 7 - s);
                    s = (byte)(s + 1);
                    continue;
                }
                dst.put((byte)(0x80 | val[i]));
                s = 1;
                t = 0;
            }
            if (s > 1) {
                dst.put((byte)(0x7F & t));
            } else {
                byte[] byArray = dst.getBytes();
                int n = offset + dst.getPosition() - 1;
                byArray[n] = (byte)(byArray[n] & 0x7F);
            }
        }
        ord.apply(dst.getBytes(), offset + start, dst.getPosition() - start);
        return dst.getPosition() - start;
    }

    public static int encodeBlobVar(PositionedByteRange dst, byte[] val, Order ord) {
        return OrderedBytes.encodeBlobVar(dst, val, 0, null != val ? val.length : 0, ord);
    }

    public static byte[] decodeBlobVar(PositionedByteRange src) {
        Order ord;
        byte header = src.get();
        if (header == 5 || header == Order.DESCENDING.apply((byte)5)) {
            return null;
        }
        assert (header == 55 || header == Order.DESCENDING.apply((byte)55));
        Order order = ord = 55 == header ? Order.ASCENDING : Order.DESCENDING;
        if (src.peek() == ord.apply((byte)0)) {
            src.get();
            return new byte[0];
        }
        int offset = src.getOffset();
        int start = src.getPosition();
        byte[] a = src.getBytes();
        int end = start;
        while ((byte)(ord.apply(a[offset + end]) & 0x80) != 0) {
            ++end;
        }
        SimplePositionedMutableByteRange ret = new SimplePositionedMutableByteRange(OrderedBytes.blobVarDecodedLength(++end - start + 1));
        int s = 6;
        byte t = (byte)(ord.apply(a[offset + start]) << 1 & 0xFF);
        for (int i = start + 1; i < end; ++i) {
            if (s == 7) {
                ret.put((byte)(t | ord.apply(a[offset + i]) & 0x7F));
                ++i;
                t = 0;
            } else {
                ret.put((byte)(t | (ord.apply(a[offset + i]) & 0x7F) >>> s));
            }
            if (i == end) break;
            t = (byte)(ord.apply(a[offset + i]) << 8 - s & 0xFF);
            s = s == 1 ? 7 : s - 1;
        }
        src.setPosition(end);
        assert (t == 0) : "Unexpected bits remaining after decoding blob.";
        assert (ret.getPosition() == ret.getLength()) : "Allocated unnecessarily large return buffer.";
        return ret.getBytes();
    }

    public static int encodeBlobCopy(PositionedByteRange dst, byte[] val, int voff, int vlen, Order ord) {
        if (null == val) {
            OrderedBytes.encodeNull(dst, ord);
            if (Order.ASCENDING == ord) {
                return 1;
            }
            dst.put(ord.apply((byte)0));
            return 2;
        }
        assert (dst.getRemaining() >= vlen + (Order.ASCENDING == ord ? 1 : 2));
        if (Order.DESCENDING == ord) {
            for (int i = 0; i < vlen; ++i) {
                if (0 != val[voff + i]) continue;
                throw new IllegalArgumentException("0x00 bytes not permitted in value.");
            }
        }
        int offset = dst.getOffset();
        int start = dst.getPosition();
        dst.put((byte)56);
        dst.put(val, voff, vlen);
        if (Order.DESCENDING == ord) {
            dst.put((byte)0);
        }
        ord.apply(dst.getBytes(), offset + start, dst.getPosition() - start);
        return dst.getPosition() - start;
    }

    public static int encodeBlobCopy(PositionedByteRange dst, byte[] val, Order ord) {
        return OrderedBytes.encodeBlobCopy(dst, val, 0, null != val ? val.length : 0, ord);
    }

    public static byte[] decodeBlobCopy(PositionedByteRange src) {
        byte header = src.get();
        if (header == 5 || header == Order.DESCENDING.apply((byte)5)) {
            return null;
        }
        assert (header == 56 || header == Order.DESCENDING.apply((byte)56));
        Order ord = header == 56 ? Order.ASCENDING : Order.DESCENDING;
        int length = src.getRemaining() - (Order.ASCENDING == ord ? 0 : 1);
        byte[] ret = new byte[length];
        src.get(ret);
        ord.apply(ret, 0, ret.length);
        if (Order.DESCENDING == ord) {
            src.get();
        }
        return ret;
    }

    public static int encodeNull(PositionedByteRange dst, Order ord) {
        dst.put(ord.apply((byte)5));
        return 1;
    }

    public static int encodeInt8(PositionedByteRange dst, byte val, Order ord) {
        int offset = dst.getOffset();
        int start = dst.getPosition();
        dst.put((byte)41).put((byte)(val ^ 0x80));
        ord.apply(dst.getBytes(), offset + start, 2);
        return 2;
    }

    public static byte decodeInt8(PositionedByteRange src) {
        byte header = src.get();
        assert (header == 41 || header == Order.DESCENDING.apply((byte)41));
        Order ord = header == 41 ? Order.ASCENDING : Order.DESCENDING;
        return (byte)((ord.apply(src.get()) ^ 0x80) & 0xFF);
    }

    public static int encodeInt16(PositionedByteRange dst, short val, Order ord) {
        int offset = dst.getOffset();
        int start = dst.getPosition();
        dst.put((byte)42).put((byte)(val >> 8 ^ 0x80)).put((byte)val);
        ord.apply(dst.getBytes(), offset + start, 3);
        return 3;
    }

    public static short decodeInt16(PositionedByteRange src) {
        byte header = src.get();
        assert (header == 42 || header == Order.DESCENDING.apply((byte)42));
        Order ord = header == 42 ? Order.ASCENDING : Order.DESCENDING;
        short val = (short)((ord.apply(src.get()) ^ 0x80) & 0xFF);
        val = (short)((val << 8) + (ord.apply(src.get()) & 0xFF));
        return val;
    }

    public static int encodeInt32(PositionedByteRange dst, int val, Order ord) {
        int offset = dst.getOffset();
        int start = dst.getPosition();
        dst.put((byte)43).put((byte)(val >> 24 ^ 0x80)).put((byte)(val >> 16)).put((byte)(val >> 8)).put((byte)val);
        ord.apply(dst.getBytes(), offset + start, 5);
        return 5;
    }

    public static int decodeInt32(PositionedByteRange src) {
        byte header = src.get();
        assert (header == 43 || header == Order.DESCENDING.apply((byte)43));
        Order ord = header == 43 ? Order.ASCENDING : Order.DESCENDING;
        int val = (ord.apply(src.get()) ^ 0x80) & 0xFF;
        for (int i = 1; i < 4; ++i) {
            val = (val << 8) + (ord.apply(src.get()) & 0xFF);
        }
        return val;
    }

    public static int encodeInt64(PositionedByteRange dst, long val, Order ord) {
        int offset = dst.getOffset();
        int start = dst.getPosition();
        dst.put((byte)44).put((byte)(val >> 56 ^ 0x80L)).put((byte)(val >> 48)).put((byte)(val >> 40)).put((byte)(val >> 32)).put((byte)(val >> 24)).put((byte)(val >> 16)).put((byte)(val >> 8)).put((byte)val);
        ord.apply(dst.getBytes(), offset + start, 9);
        return 9;
    }

    public static long decodeInt64(PositionedByteRange src) {
        byte header = src.get();
        assert (header == 44 || header == Order.DESCENDING.apply((byte)44));
        Order ord = header == 44 ? Order.ASCENDING : Order.DESCENDING;
        long val = (ord.apply(src.get()) ^ 0x80) & 0xFF;
        for (int i = 1; i < 8; ++i) {
            val = (val << 8) + (long)(ord.apply(src.get()) & 0xFF);
        }
        return val;
    }

    public static int encodeFloat32(PositionedByteRange dst, float val, Order ord) {
        int offset = dst.getOffset();
        int start = dst.getPosition();
        int i = Float.floatToIntBits(val);
        i ^= i >> 31 | Integer.MIN_VALUE;
        dst.put((byte)48).put((byte)(i >> 24)).put((byte)(i >> 16)).put((byte)(i >> 8)).put((byte)i);
        ord.apply(dst.getBytes(), offset + start, 5);
        return 5;
    }

    public static float decodeFloat32(PositionedByteRange src) {
        byte header = src.get();
        assert (header == 48 || header == Order.DESCENDING.apply((byte)48));
        Order ord = header == 48 ? Order.ASCENDING : Order.DESCENDING;
        int val = ord.apply(src.get()) & 0xFF;
        for (int i = 1; i < 4; ++i) {
            val = (val << 8) + (ord.apply(src.get()) & 0xFF);
        }
        val ^= ~val >> 31 | Integer.MIN_VALUE;
        return Float.intBitsToFloat(val);
    }

    public static int encodeFloat64(PositionedByteRange dst, double val, Order ord) {
        int offset = dst.getOffset();
        int start = dst.getPosition();
        long lng = Double.doubleToLongBits(val);
        lng ^= lng >> 63 | Long.MIN_VALUE;
        dst.put((byte)49).put((byte)(lng >> 56)).put((byte)(lng >> 48)).put((byte)(lng >> 40)).put((byte)(lng >> 32)).put((byte)(lng >> 24)).put((byte)(lng >> 16)).put((byte)(lng >> 8)).put((byte)lng);
        ord.apply(dst.getBytes(), offset + start, 9);
        return 9;
    }

    public static double decodeFloat64(PositionedByteRange src) {
        byte header = src.get();
        assert (header == 49 || header == Order.DESCENDING.apply((byte)49));
        Order ord = header == 49 ? Order.ASCENDING : Order.DESCENDING;
        long val = ord.apply(src.get()) & 0xFF;
        for (int i = 1; i < 8; ++i) {
            val = (val << 8) + (long)(ord.apply(src.get()) & 0xFF);
        }
        val ^= (val ^ 0xFFFFFFFFFFFFFFFFL) >> 63 | Long.MIN_VALUE;
        return Double.longBitsToDouble(val);
    }

    public static boolean isEncodedValue(PositionedByteRange src) {
        return OrderedBytes.isNull(src) || OrderedBytes.isNumeric(src) || OrderedBytes.isFixedInt8(src) || OrderedBytes.isFixedInt16(src) || OrderedBytes.isFixedInt32(src) || OrderedBytes.isFixedInt64(src) || OrderedBytes.isFixedFloat32(src) || OrderedBytes.isFixedFloat64(src) || OrderedBytes.isText(src) || OrderedBytes.isBlobCopy(src) || OrderedBytes.isBlobVar(src);
    }

    public static boolean isNull(PositionedByteRange src) {
        return 5 == (-1 == Integer.signum(src.peek()) ? Order.DESCENDING : Order.ASCENDING).apply(src.peek());
    }

    public static boolean isNumeric(PositionedByteRange src) {
        byte x = (-1 == Integer.signum(src.peek()) ? Order.DESCENDING : Order.ASCENDING).apply(src.peek());
        return x >= 7 && x <= 38;
    }

    public static boolean isNumericInfinite(PositionedByteRange src) {
        byte x = (-1 == Integer.signum(src.peek()) ? Order.DESCENDING : Order.ASCENDING).apply(src.peek());
        return 7 == x || 35 == x;
    }

    public static boolean isNumericNaN(PositionedByteRange src) {
        return 38 == (-1 == Integer.signum(src.peek()) ? Order.DESCENDING : Order.ASCENDING).apply(src.peek());
    }

    public static boolean isNumericZero(PositionedByteRange src) {
        return 21 == (-1 == Integer.signum(src.peek()) ? Order.DESCENDING : Order.ASCENDING).apply(src.peek());
    }

    public static boolean isFixedInt8(PositionedByteRange src) {
        return 41 == (-1 == Integer.signum(src.peek()) ? Order.DESCENDING : Order.ASCENDING).apply(src.peek());
    }

    public static boolean isFixedInt16(PositionedByteRange src) {
        return 42 == (-1 == Integer.signum(src.peek()) ? Order.DESCENDING : Order.ASCENDING).apply(src.peek());
    }

    public static boolean isFixedInt32(PositionedByteRange src) {
        return 43 == (-1 == Integer.signum(src.peek()) ? Order.DESCENDING : Order.ASCENDING).apply(src.peek());
    }

    public static boolean isFixedInt64(PositionedByteRange src) {
        return 44 == (-1 == Integer.signum(src.peek()) ? Order.DESCENDING : Order.ASCENDING).apply(src.peek());
    }

    public static boolean isFixedFloat32(PositionedByteRange src) {
        return 48 == (-1 == Integer.signum(src.peek()) ? Order.DESCENDING : Order.ASCENDING).apply(src.peek());
    }

    public static boolean isFixedFloat64(PositionedByteRange src) {
        return 49 == (-1 == Integer.signum(src.peek()) ? Order.DESCENDING : Order.ASCENDING).apply(src.peek());
    }

    public static boolean isText(PositionedByteRange src) {
        return 52 == (-1 == Integer.signum(src.peek()) ? Order.DESCENDING : Order.ASCENDING).apply(src.peek());
    }

    public static boolean isBlobVar(PositionedByteRange src) {
        return 55 == (-1 == Integer.signum(src.peek()) ? Order.DESCENDING : Order.ASCENDING).apply(src.peek());
    }

    public static boolean isBlobCopy(PositionedByteRange src) {
        return 56 == (-1 == Integer.signum(src.peek()) ? Order.DESCENDING : Order.ASCENDING).apply(src.peek());
    }

    public static int skip(PositionedByteRange src) {
        int start = src.getPosition();
        byte header = src.get();
        Order ord = -1 == Integer.signum(header) ? Order.DESCENDING : Order.ASCENDING;
        header = ord.apply(header);
        switch (header) {
            case 5: 
            case 7: {
                return 1;
            }
            case 8: {
                OrderedBytes.skipVaruint64(src, Order.DESCENDING != ord);
                OrderedBytes.skipSignificand(src, Order.DESCENDING != ord);
                return src.getPosition() - start;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                OrderedBytes.skipSignificand(src, Order.DESCENDING != ord);
                return src.getPosition() - start;
            }
            case 20: {
                OrderedBytes.skipVaruint64(src, Order.DESCENDING == ord);
                OrderedBytes.skipSignificand(src, Order.DESCENDING != ord);
                return src.getPosition() - start;
            }
            case 21: {
                return 1;
            }
            case 22: {
                OrderedBytes.skipVaruint64(src, Order.DESCENDING != ord);
                OrderedBytes.skipSignificand(src, Order.DESCENDING == ord);
                return src.getPosition() - start;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                OrderedBytes.skipSignificand(src, Order.DESCENDING == ord);
                return src.getPosition() - start;
            }
            case 34: {
                OrderedBytes.skipVaruint64(src, Order.DESCENDING == ord);
                OrderedBytes.skipSignificand(src, Order.DESCENDING == ord);
                return src.getPosition() - start;
            }
            case 35: {
                return 1;
            }
            case 38: {
                return 1;
            }
            case 41: {
                src.setPosition(src.getPosition() + 1);
                return src.getPosition() - start;
            }
            case 42: {
                src.setPosition(src.getPosition() + 2);
                return src.getPosition() - start;
            }
            case 43: {
                src.setPosition(src.getPosition() + 4);
                return src.getPosition() - start;
            }
            case 44: {
                src.setPosition(src.getPosition() + 8);
                return src.getPosition() - start;
            }
            case 48: {
                src.setPosition(src.getPosition() + 4);
                return src.getPosition() - start;
            }
            case 49: {
                src.setPosition(src.getPosition() + 8);
                return src.getPosition() - start;
            }
            case 52: {
                while ((header = ord.apply(src.get())) != 0) {
                }
                return src.getPosition() - start;
            }
            case 55: {
                while ((byte)((header = ord.apply(src.get())) & 0x80) != 0) {
                }
                return src.getPosition() - start;
            }
            case 56: {
                if (Order.DESCENDING == ord) {
                    while ((header = ord.apply(src.get())) != 0) {
                    }
                    return src.getPosition() - start;
                }
                src.setPosition(src.getLength());
                return src.getPosition() - start;
            }
        }
        throw OrderedBytes.unexpectedHeader(header);
    }

    public static int length(PositionedByteRange buff) {
        SimplePositionedMutableByteRange b = new SimplePositionedMutableByteRange(buff.getBytes(), buff.getOffset(), buff.getLength());
        b.setPosition(buff.getPosition());
        int cnt = 0;
        while (OrderedBytes.isEncodedValue(b)) {
            OrderedBytes.skip(b);
            ++cnt;
        }
        return cnt;
    }
}

