/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.servlet.RestCsrfPreventionFilter;
import org.apache.oozie.util.XLog;

public class OozieCSRFFilter
extends RestCsrfPreventionFilter {
    private static final XLog LOG = XLog.getLog(OozieCSRFFilter.class);
    private String csrfHeader;
    private String csrfIgnoreMethods;
    private String csrfBrowserAgents;
    private boolean isCSRFEnabled;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        this.isCSRFEnabled = ConfigurationService.getBoolean("oozie.service.ConfigurationService.csrf.filter.enabled");
        this.csrfHeader = ConfigurationService.get("oozie.service.ConfigurationService.csrf.filter.header");
        this.csrfIgnoreMethods = ConfigurationService.get("oozie.service.ConfigurationService.csrf.filter.ignore.method");
        this.csrfBrowserAgents = ConfigurationService.get("oozie.service.ConfigurationService.csrf.filter.browser.agents");
        super.setHeaderName(this.csrfHeader);
        super.parseMethodsToIgnore(this.csrfIgnoreMethods);
        super.parseBrowserUserAgents(this.csrfBrowserAgents);
        LOG.info("Initialized Oozie cross-site request forgery (CSRF) protection with, headerName = {0}, methodsToIgnore = {1}, browserUserAgents = {2}, isCSRFEnabled = {3}", this.csrfHeader, this.csrfIgnoreMethods, this.csrfBrowserAgents, this.isCSRFEnabled);
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOG.debug("Oozie cross-site request forgery (CSRF) protection running with, headerName = {0}, methodsToIgnore = {1}, browserUserAgents = {2}, isCSRFEnabled = {3}", this.csrfHeader, this.csrfIgnoreMethods, this.csrfBrowserAgents, this.isCSRFEnabled);
        if (this.isCSRFEnabled) {
            super.doFilter(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }
}

