/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.hadoop.MapReduceMain;
import org.apache.oozie.action.hadoop.ScriptLanguageActionExecutor;
import org.apache.oozie.client.WorkflowAction;
import org.jdom.Element;
import org.jdom.Namespace;

public class Hive2ActionExecutor
extends ScriptLanguageActionExecutor {
    private static final String HIVE2_MAIN_CLASS_NAME = "org.apache.oozie.action.hadoop.Hive2Main";
    static final String HIVE2_JDBC_URL = "oozie.hive2.jdbc.url";
    static final String HIVE2_PASSWORD = "oozie.hive2.password";
    static final String HIVE2_SCRIPT = "oozie.hive2.script";
    static final String HIVE2_QUERY = "oozie.hive2.query";
    static final String HIVE2_PARAMS = "oozie.hive2.params";
    static final String HIVE2_ARGS = "oozie.hive2.args";
    private boolean addScriptToCache = false;
    public static final String TASK_USER_PRECEDENCE = "mapreduce.task.classpath.user.precedence";
    public static final String TASK_USER_CLASSPATH_PRECEDENCE = "mapreduce.user.classpath.first";

    public Hive2ActionExecutor() {
        super("hive2");
    }

    @Override
    public List<Class> getLauncherClasses() {
        ArrayList<Class> classes = new ArrayList<Class>();
        try {
            classes.add(Class.forName(HIVE2_MAIN_CLASS_NAME));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found", e);
        }
        return classes;
    }

    @Override
    protected boolean shouldAddScriptToCache() {
        return this.addScriptToCache;
    }

    @Override
    protected String getLauncherMain(Configuration launcherConf, Element actionXml) {
        return launcherConf.get("oozie.launcher.action.main.class", HIVE2_MAIN_CLASS_NAME);
    }

    @Override
    JobConf createLauncherConf(FileSystem actionFs, ActionExecutor.Context context, WorkflowAction action, Element actionXml, Configuration actionConf) throws ActionExecutorException {
        JobConf launcherJobConf = super.createLauncherConf(actionFs, context, action, actionXml, actionConf);
        if (launcherJobConf.get("oozie.launcher.mapreduce.task.classpath.user.precedence") == null) {
            launcherJobConf.set(TASK_USER_PRECEDENCE, "true");
        }
        if (launcherJobConf.get("oozie.launcher.mapreduce.user.classpath.first") == null) {
            launcherJobConf.set(TASK_USER_CLASSPATH_PRECEDENCE, "true");
        }
        return launcherJobConf;
    }

    @Override
    Configuration setupActionConf(Configuration actionConf, ActionExecutor.Context context, Element actionXml, Path appPath) throws ActionExecutorException {
        Configuration conf = super.setupActionConf(actionConf, context, actionXml, appPath);
        Namespace ns = actionXml.getNamespace();
        String jdbcUrl = actionXml.getChild("jdbc-url", ns).getTextTrim();
        conf.set(HIVE2_JDBC_URL, jdbcUrl);
        String password = null;
        Element passwordElement = actionXml.getChild("password", ns);
        if (passwordElement != null) {
            password = actionXml.getChild("password", ns).getTextTrim();
            conf.set(HIVE2_PASSWORD, password);
        }
        Element queryElement = actionXml.getChild("query", ns);
        Element scriptElement = actionXml.getChild("script", ns);
        if (scriptElement != null) {
            String script = scriptElement.getTextTrim();
            String scriptName = new Path(script).getName();
            this.addScriptToCache = true;
            conf.set(HIVE2_SCRIPT, scriptName);
        } else if (queryElement != null) {
            String query = queryElement.getText();
            conf.set(HIVE2_QUERY, query);
        } else {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "INVALID_ARGUMENTS", "Hive 2 action requires one of <script> or <query> to be set. Neither were found.");
        }
        List params = actionXml.getChildren("param", ns);
        String[] strParams = new String[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            strParams[i] = ((Element)params.get(i)).getTextTrim();
        }
        MapReduceMain.setStrings((Configuration)conf, (String)HIVE2_PARAMS, (String[])strParams);
        String[] strArgs = null;
        List eArgs = actionXml.getChildren("argument", ns);
        if (eArgs != null && eArgs.size() > 0) {
            strArgs = new String[eArgs.size()];
            for (int i = 0; i < eArgs.size(); ++i) {
                strArgs[i] = ((Element)eArgs.get(i)).getTextTrim();
            }
        }
        MapReduceMain.setStrings((Configuration)conf, (String)HIVE2_ARGS, strArgs);
        return conf;
    }

    @Override
    protected String getDefaultShareLibName(Element actionXml) {
        return "hive2";
    }

    @Override
    protected String getScriptName() {
        return HIVE2_SCRIPT;
    }

    @Override
    public String[] getShareLibFilesForActionConf() {
        return new String[]{"hive-site.xml"};
    }
}

