/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.invocationhandler;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import org.pentaho.hadoop.shim.common.DriverProxyInvocationChain;
import org.pentaho.hadoop.shim.common.invocationhandler.ResultSetInvocationHandler;
import org.pentaho.hadoop.shim.common.invocationhandler.ResultSetMetaDataInvocationHandler;

public class CaptureResultSetInvocationHandler<T extends Statement>
implements InvocationHandler {
    T t;

    public CaptureResultSetInvocationHandler(T t) {
        this.t = t;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        try {
            boolean isSetTimestamp = "setTimestamp".equals(methodName);
            if (PreparedStatement.class.isInstance(proxy) && (isSetTimestamp || "setDate".equals(methodName)) && args[1] != DriverProxyInvocationChain.NULL_DATE) {
                PreparedStatement ps = (PreparedStatement)proxy;
                if (args[1] == null) {
                    ps.setNull((Integer)args[0], isSetTimestamp ? 93 : 91);
                } else {
                    String value;
                    if (args.length == 3 && java.util.Date.class.isAssignableFrom(method.getParameterTypes()[1]) && Calendar.class.isAssignableFrom(method.getParameterTypes()[2])) {
                        Calendar calendar = args[2] == null ? Calendar.getInstance() : Calendar.getInstance(((Calendar)args[2]).getTimeZone());
                        calendar.setTime((java.util.Date)args[1]);
                        value = isSetTimestamp ? new Timestamp(calendar.getTimeInMillis()).toString() : new Date(calendar.getTimeInMillis()).toString();
                    } else {
                        value = args[1].toString();
                    }
                    ps.setString((Integer)args[0], value);
                }
                return null;
            }
            return this.getProxiedObject(method.invoke(this.t, args));
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof SQLException && cause.getMessage().equals("Method not supported")) {
                if ("getMetaData".equals(methodName) && (args == null || args.length == 0)) {
                    return this.getProxiedObject(this.getMetaData());
                }
                if (PreparedStatement.class.isInstance(proxy)) {
                    PreparedStatement ps = (PreparedStatement)proxy;
                    if ("setObject".equals(methodName) && args.length == 2 && Integer.class.isInstance(args[0])) {
                        int parameterIndex = (Integer)args[0];
                        Object x = args[1];
                        if (x == null) {
                            ps.setNull(parameterIndex, 0);
                        } else if (x instanceof String) {
                            ps.setString(parameterIndex, (String)x);
                        } else if (x instanceof Short) {
                            ps.setShort(parameterIndex, (Short)x);
                        } else if (x instanceof Integer) {
                            ps.setInt(parameterIndex, (Integer)x);
                        } else if (x instanceof Long) {
                            ps.setLong(parameterIndex, (Long)x);
                        } else if (x instanceof Float) {
                            ps.setFloat(parameterIndex, ((Float)x).floatValue());
                        } else if (x instanceof Double) {
                            ps.setDouble(parameterIndex, (Double)x);
                        } else if (x instanceof Boolean) {
                            ps.setBoolean(parameterIndex, (Boolean)x);
                        } else if (x instanceof Byte) {
                            ps.setByte(parameterIndex, (Byte)x);
                        } else if (x instanceof Character) {
                            ps.setString(parameterIndex, x.toString());
                        } else {
                            throw new SQLException("Type " + x.getClass() + " is not yet supported", cause);
                        }
                        return null;
                    }
                    if ("setNull".equals(methodName) && args.length == 2 && Integer.class.isInstance(args[0])) {
                        int parameterIndex = (Integer)args[0];
                        ps.setDate(parameterIndex, DriverProxyInvocationChain.NULL_DATE);
                        return null;
                    }
                }
            }
            throw cause;
        }
    }

    public ResultSetMetaData getMetaData() {
        ResultSetMetaData rsmd = null;
        if (this.t instanceof Statement) {
            try {
                ResultSet resultSet = this.t.getResultSet();
                rsmd = resultSet == null ? null : resultSet.getMetaData();
            }
            catch (SQLException se) {
                rsmd = null;
            }
        }
        return rsmd;
    }

    private Object getProxiedObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof ResultSet) {
            ResultSet r = (ResultSet)o;
            return (ResultSet)Proxy.newProxyInstance(r.getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new ResultSetInvocationHandler(r, (Statement)this.t));
        }
        if (o instanceof ResultSetMetaData) {
            ResultSetMetaData r = (ResultSetMetaData)o;
            return (ResultSetMetaData)Proxy.newProxyInstance(r.getClass().getClassLoader(), new Class[]{ResultSetMetaData.class}, (InvocationHandler)new ResultSetMetaDataInvocationHandler(r));
        }
        return o;
    }
}

