/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.mapreduce;

import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.hadoop.mapreduce.OutKeyValueOrdinals;
import org.pentaho.hadoop.mapreduce.PentahoMapRunnable;
import org.pentaho.hadoop.mapreduce.converter.TypeConverterFactory;
import org.pentaho.hadoop.mapreduce.converter.spi.ITypeConverter;

public class OutputCollectorRowListener<K, V>
extends RowAdapter {
    private boolean debug;
    private Reporter reporter;
    private Class<K> outClassK;
    private Class<V> outClassV;
    private OutputCollector<K, V> output;
    private Exception exception;
    private OutKeyValueOrdinals outOrdinals;
    private TypeConverterFactory typeConverterFactory;

    public OutputCollectorRowListener(OutputCollector<K, V> output, Class<K> outClassK, Class<V> outClassV, Reporter reporter, boolean debug) {
        this.output = output;
        this.outClassK = outClassK;
        this.outClassV = outClassV;
        this.reporter = reporter;
        this.debug = debug;
        this.typeConverterFactory = new TypeConverterFactory();
        this.outOrdinals = null;
    }

    public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
        try {
            if (row != null && !rowMeta.isEmpty() && rowMeta.size() >= 2) {
                if (this.outOrdinals == null) {
                    this.outOrdinals = new OutKeyValueOrdinals(rowMeta);
                    if (this.outOrdinals.getKeyOrdinal() < 0 || this.outOrdinals.getValueOrdinal() < 0) {
                        throw new KettleException("outKey or outValue is not defined in transformation output stream");
                    }
                }
                if (this.debug) {
                    this.setDebugStatus(this.reporter, "Begin conversion of output key [from:" + (row[this.outOrdinals.getKeyOrdinal()] == null ? null : row[this.outOrdinals.getKeyOrdinal()].getClass()) + "] [to:" + this.outClassK + "]");
                }
                if (this.debug) {
                    this.setDebugStatus(this.reporter, "getConverter: " + (row[this.outOrdinals.getKeyOrdinal()] == null ? null : row[this.outOrdinals.getKeyOrdinal()].getClass()));
                    this.setDebugStatus(this.reporter, "out class: " + this.outClassK);
                }
                ITypeConverter<Object, K> converter = this.typeConverterFactory.getConverter(row[this.outOrdinals.getKeyOrdinal()] == null ? null : row[this.outOrdinals.getKeyOrdinal()].getClass(), this.outClassK);
                if (this.debug) {
                    this.setDebugStatus(this.reporter, "ordinals key: " + this.outOrdinals.getKeyOrdinal());
                    this.setDebugStatus(this.reporter, "rowMeta: " + rowMeta);
                    this.setDebugStatus(this.reporter, "rowMeta: " + rowMeta.getMetaXML());
                    this.setDebugStatus(this.reporter, "meta: " + rowMeta.getValueMeta(this.outOrdinals.getKeyOrdinal()));
                    this.setDebugStatus(this.reporter, "key: " + row[this.outOrdinals.getKeyOrdinal()]);
                }
                K outKey = converter.convert(rowMeta.getValueMeta(this.outOrdinals.getKeyOrdinal()), row[this.outOrdinals.getKeyOrdinal()]);
                if (this.debug) {
                    this.setDebugStatus(this.reporter, "Begin conversion of output value [from:" + (row[this.outOrdinals.getValueOrdinal()] == null ? null : row[this.outOrdinals.getValueOrdinal()].getClass()) + "] [to:" + this.outClassV + "]");
                }
                ITypeConverter<Object, V> valueConverter = this.typeConverterFactory.getConverter(row[this.outOrdinals.getValueOrdinal()] == null ? null : row[this.outOrdinals.getValueOrdinal()].getClass(), this.outClassV);
                if (this.debug) {
                    this.setDebugStatus(this.reporter, "ordinals value: " + this.outOrdinals.getValueOrdinal());
                    this.setDebugStatus(this.reporter, "rowMeta: " + rowMeta);
                    this.setDebugStatus(this.reporter, "rowMeta: " + rowMeta.getMetaXML());
                    this.setDebugStatus(this.reporter, "meta: " + rowMeta.getValueMeta(this.outOrdinals.getValueOrdinal()));
                    this.setDebugStatus(this.reporter, "value: " + row[this.outOrdinals.getValueOrdinal()]);
                }
                V outVal = valueConverter.convert(rowMeta.getValueMeta(this.outOrdinals.getValueOrdinal()), row[this.outOrdinals.getValueOrdinal()]);
                if (outKey != null && outVal != null) {
                    if (this.debug) {
                        this.setDebugStatus(this.reporter, "Collecting output record [" + outKey + "] - [" + outVal + "]");
                    }
                    K k = outKey;
                    V v = outVal;
                    this.output.collect(k, v);
                } else {
                    if (outKey == null) {
                        if (this.debug) {
                            this.setDebugStatus(this.reporter, "Transformation returned a null key");
                        }
                        this.reporter.incrCounter((Enum)PentahoMapRunnable.Counter.OUT_RECORD_WITH_NULL_KEY, 1L);
                    }
                    if (outVal == null) {
                        if (this.debug) {
                            this.setDebugStatus(this.reporter, "Transformation returned a null value");
                        }
                        this.reporter.incrCounter((Enum)PentahoMapRunnable.Counter.OUT_RECORD_WITH_NULL_VALUE, 1L);
                    }
                }
            } else if (row == null || rowMeta.isEmpty()) {
                if (this.debug) {
                    this.setDebugStatus(this.reporter, "Invalid row received from transformation");
                }
            } else if (rowMeta.size() < 2) {
                if (this.debug) {
                    this.setDebugStatus(this.reporter, "Invalid row format. Expected key/value columns, but received " + rowMeta.size() + " columns");
                }
            } else {
                OutKeyValueOrdinals outOrdinals = new OutKeyValueOrdinals(rowMeta);
                if ((outOrdinals.getKeyOrdinal() < 0 || outOrdinals.getValueOrdinal() < 0) && this.debug) {
                    this.setDebugStatus(this.reporter, "outKey or outValue is missing from the transformation output step");
                }
                if (this.debug) {
                    this.setDebugStatus(this.reporter, "Unknown issue with received data from transformation");
                }
            }
        }
        catch (Exception ex) {
            this.setDebugStatus(this.reporter, "Unexpected exception recieved: " + ex.getMessage());
            this.exception = ex;
            throw new RuntimeException(ex);
        }
    }

    public void setDebugStatus(Reporter reporter, String message) {
        if (this.debug) {
            System.out.println(message);
            reporter.setStatus(message);
        }
    }

    public Exception getException() {
        return this.exception;
    }
}

