/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.api.repository2.unified;

import java.io.Serializable;
import java.util.EnumSet;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.RepositoryFileSid;

public class RepositoryFileAce
implements Serializable {
    private static final long serialVersionUID = 6916656647947322578L;
    private final RepositoryFileSid recipient;
    private final EnumSet<RepositoryFilePermission> permissions;

    public RepositoryFileAce(RepositoryFileSid recipient, RepositoryFilePermission first, RepositoryFilePermission ... rest) {
        this(recipient, EnumSet.of(first, rest));
    }

    public RepositoryFileAce(RepositoryFileSid recipient, EnumSet<RepositoryFilePermission> permissions) {
        this.notNull(recipient);
        this.notNull(permissions);
        this.recipient = recipient;
        this.permissions = EnumSet.copyOf(permissions);
    }

    private void notNull(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
    }

    public RepositoryFileSid getSid() {
        return this.recipient;
    }

    public EnumSet<RepositoryFilePermission> getPermissions() {
        return EnumSet.copyOf(this.permissions);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.permissions == null ? 0 : this.permissions.hashCode());
        result = 31 * result + (this.recipient == null ? 0 : this.recipient.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryFileAce other = (RepositoryFileAce)obj;
        if (this.permissions == null ? other.permissions != null : !this.permissions.equals(other.permissions)) {
            return false;
        }
        return !(this.recipient == null ? other.recipient != null : !this.recipient.equals(other.recipient));
    }

    public String toString() {
        return "RepositoryFileAce[recipient=" + this.recipient + ", permissions=" + this.permissions + "]";
    }
}

