/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import org.pentaho.cdf.environment.CdfEngine;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.resources.IResourceLoader;

public class ResourceManager {
    public static ResourceManager instance;
    private static final HashSet<String> CACHEABLE_EXTENSIONS;
    private static final HashMap<String, String> cacheContainer;
    private boolean isCacheEnabled = true;

    public ResourceManager() {
        CACHEABLE_EXTENSIONS.add("html");
        CACHEABLE_EXTENSIONS.add("json");
        CACHEABLE_EXTENSIONS.add("cdfde");
        IResourceLoader resLoader = CdfEngine.getEnvironment().getResourceLoader();
        this.isCacheEnabled = Boolean.parseBoolean(resLoader.getPluginSetting(this.getClass(), "pentaho-cdf-dd/enable-cache"));
    }

    public static ResourceManager getInstance() {
        if (instance == null) {
            instance = new ResourceManager();
        }
        return instance;
    }

    public String getResourceAsString(String path, HashMap<String, String> tokens) throws IOException {
        int c;
        String extension = this.getResourceExtension(path);
        String cacheKey = this.buildCacheKey(path, tokens);
        if (this.isCacheEnabled && CACHEABLE_EXTENSIONS.contains(extension) && cacheContainer.containsKey(cacheKey)) {
            return cacheContainer.get(cacheKey);
        }
        IReadAccess systemAccess = CdfEngine.getPluginSystemReader(null);
        InputStream in = systemAccess.getFileInputStream(path);
        StringBuilder resource = new StringBuilder();
        while ((c = in.read()) != -1) {
            resource.append((char)c);
        }
        in.close();
        if (tokens != null) {
            for (String key : tokens.keySet()) {
                int index = resource.indexOf(key);
                if (index == -1) continue;
                resource.replace(index, index + key.length(), tokens.get(key));
            }
        }
        String output = resource.toString();
        if (this.isCacheEnabled && CACHEABLE_EXTENSIONS.contains(extension)) {
            cacheContainer.put(cacheKey, output);
        }
        return output;
    }

    public String getResourceAsString(String path) throws IOException {
        return this.getResourceAsString(path, null);
    }

    private String buildCacheKey(String path, HashMap<String, String> tokens) {
        StringBuilder keyBuilder = new StringBuilder(path);
        if (tokens != null) {
            for (String key : tokens.keySet()) {
                keyBuilder.append(key.hashCode());
                keyBuilder.append(tokens.get(key).hashCode());
            }
        }
        return keyBuilder.toString();
    }

    private String getResourceExtension(String path) {
        return path.substring(path.lastIndexOf(46) + 1);
    }

    public void cleanCache() {
        cacheContainer.clear();
    }

    static {
        CACHEABLE_EXTENSIONS = new HashSet();
        cacheContainer = new HashMap();
    }
}

