/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.launcher.property;

import java.util.Stack;
import org.pentaho.commons.launcher.property.PropertyGetter;

public class PropertyLookupParser {
    public static final int ESCAPE_MODE_NONE = 0;
    public static final int ESCAPE_MODE_ALL = 2;
    public static final int ESCAPE_MODE_STRICT = 1;
    private static final int EXPECT_DOLLAR = 0;
    private static final int EXPECT_OPEN_BRACE = 1;
    private static final int EXPECT_CLOSE_BRACE = 3;
    private char markerChar = (char)36;
    private char closingBraceChar = (char)125;
    private char openingBraceChar = (char)123;
    private char escapeChar = (char)92;
    private int escapeMode = 1;
    private final PropertyGetter propertyGetter;

    public PropertyLookupParser(PropertyGetter propertyGetter) {
        this.propertyGetter = propertyGetter;
    }

    public char getClosingBraceChar() {
        return this.closingBraceChar;
    }

    public void setClosingBraceChar(char closingBraceChar) {
        this.closingBraceChar = closingBraceChar;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(char escapeChar) {
        this.escapeChar = escapeChar;
    }

    public char getOpeningBraceChar() {
        return this.openingBraceChar;
    }

    public void setOpeningBraceChar(char openingBraceChar) {
        this.openingBraceChar = openingBraceChar;
    }

    public char getMarkerChar() {
        return this.markerChar;
    }

    public void setMarkerChar(char markerChar) {
        this.markerChar = markerChar;
    }

    public String translateAndLookup(String value) {
        if (value == null) {
            return null;
        }
        char[] chars = value.toCharArray();
        StringBuffer result = new StringBuffer(chars.length);
        boolean haveEscape = false;
        int state = 0;
        Stack<StringBuffer> stack = new Stack<StringBuffer>();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (haveEscape) {
                haveEscape = false;
                if (state == 3 || this.escapeMode == 2) {
                    result.append(c);
                    continue;
                }
                if (c == this.openingBraceChar || c == this.closingBraceChar || c == this.escapeChar || c == this.markerChar) {
                    result.append(c);
                    continue;
                }
                result.append(this.escapeChar);
                result.append(c);
                continue;
            }
            if ((state == 0 || state == 3) && c == this.markerChar) {
                state = 1;
                continue;
            }
            if (state == 3 && c == this.closingBraceChar) {
                String columnName = result.toString();
                result = (StringBuffer)stack.pop();
                this.handleVariableLookup(result, columnName);
                if (stack.isEmpty()) {
                    state = 0;
                    continue;
                }
                state = 3;
                continue;
            }
            if (state == 1) {
                if (c == this.openingBraceChar) {
                    state = 3;
                    stack.push(result);
                    result = new StringBuffer(100);
                    continue;
                }
                result.append(this.markerChar);
                state = stack.isEmpty() ? 0 : 3;
            }
            if (c == this.escapeChar && this.escapeMode != 0) {
                haveEscape = true;
                continue;
            }
            result.append(c);
        }
        if (state != 0) {
            while (!stack.isEmpty()) {
                String columnName = result.toString();
                result = (StringBuffer)stack.pop();
                result.append(this.markerChar);
                if (state == 1) continue;
                result.append(this.openingBraceChar);
                result.append(columnName);
                state = 3;
            }
        }
        return result.toString();
    }

    protected void handleVariableLookup(StringBuffer result, String columnName) {
        String s = this.propertyGetter.getProperty(columnName);
        if (s != null) {
            result.append(s);
        }
    }
}

