/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.couchdbinput;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.couchdbinput.CouchDbInputMeta;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class CouchDbInputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = CouchDbInputMeta.class;
    private TextVar wHostname;
    private TextVar wPort;
    private TextVar wDbName;
    private TextVar wDesignDocument;
    private TextVar wViewName;
    private TextVar wAuthUser;
    private TextVar wAuthPass;
    private CouchDbInputMeta input;

    public CouchDbInputDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.input = (CouchDbInputMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CouchDbInputDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"CouchDbInputDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"CouchDbInputDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        Text lastControl = this.wStepname;
        Label wlHostname = new Label((Composite)this.shell, 131072);
        wlHostname.setText(BaseMessages.getString(PKG, (String)"CouchDbInputDialog.Hostname.Label", (String[])new String[0]));
        this.props.setLook((Control)wlHostname);
        FormData fdlHostname = new FormData();
        fdlHostname.left = new FormAttachment(0, 0);
        fdlHostname.right = new FormAttachment(middle, -margin);
        fdlHostname.top = new FormAttachment((Control)lastControl, margin);
        wlHostname.setLayoutData((Object)fdlHostname);
        this.wHostname = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wHostname);
        this.wHostname.addModifyListener(lsMod);
        FormData fdHostname = new FormData();
        fdHostname.left = new FormAttachment(middle, 0);
        fdHostname.top = new FormAttachment((Control)lastControl, margin);
        fdHostname.right = new FormAttachment(100, 0);
        this.wHostname.setLayoutData((Object)fdHostname);
        lastControl = this.wHostname;
        Label wlPort = new Label((Composite)this.shell, 131072);
        wlPort.setText(BaseMessages.getString(PKG, (String)"CouchDbInputDialog.Port.Label", (String[])new String[0]));
        this.props.setLook((Control)wlPort);
        FormData fdlPort = new FormData();
        fdlPort.left = new FormAttachment(0, 0);
        fdlPort.right = new FormAttachment(middle, -margin);
        fdlPort.top = new FormAttachment((Control)lastControl, margin);
        wlPort.setLayoutData((Object)fdlPort);
        this.wPort = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wPort);
        this.wPort.addModifyListener(lsMod);
        FormData fdPort = new FormData();
        fdPort.left = new FormAttachment(middle, 0);
        fdPort.top = new FormAttachment((Control)lastControl, margin);
        fdPort.right = new FormAttachment(100, 0);
        this.wPort.setLayoutData((Object)fdPort);
        lastControl = this.wPort;
        Label wlDbName = new Label((Composite)this.shell, 131072);
        wlDbName.setText(BaseMessages.getString(PKG, (String)"CouchDbInputDialog.DbName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlDbName);
        FormData fdlDbName = new FormData();
        fdlDbName.left = new FormAttachment(0, 0);
        fdlDbName.right = new FormAttachment(middle, -margin);
        fdlDbName.top = new FormAttachment((Control)lastControl, margin);
        wlDbName.setLayoutData((Object)fdlDbName);
        this.wDbName = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wDbName);
        this.wDbName.addModifyListener(lsMod);
        FormData fdDbName = new FormData();
        fdDbName.left = new FormAttachment(middle, 0);
        fdDbName.top = new FormAttachment((Control)lastControl, margin);
        fdDbName.right = new FormAttachment(100, 0);
        this.wDbName.setLayoutData((Object)fdDbName);
        lastControl = this.wDbName;
        Label wlDesignDocument = new Label((Composite)this.shell, 131072);
        wlDesignDocument.setText(BaseMessages.getString(PKG, (String)"CouchDbInputDialog.DesignDocument.Label", (String[])new String[0]));
        this.props.setLook((Control)wlDesignDocument);
        FormData fdlDesignDocument = new FormData();
        fdlDesignDocument.left = new FormAttachment(0, 0);
        fdlDesignDocument.right = new FormAttachment(middle, -margin);
        fdlDesignDocument.top = new FormAttachment((Control)lastControl, margin);
        wlDesignDocument.setLayoutData((Object)fdlDesignDocument);
        this.wDesignDocument = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wDesignDocument);
        this.wDesignDocument.addModifyListener(lsMod);
        FormData fdDesignDocument = new FormData();
        fdDesignDocument.left = new FormAttachment(middle, 0);
        fdDesignDocument.top = new FormAttachment((Control)lastControl, margin);
        fdDesignDocument.right = new FormAttachment(100, 0);
        this.wDesignDocument.setLayoutData((Object)fdDesignDocument);
        lastControl = this.wDesignDocument;
        Label wlViewName = new Label((Composite)this.shell, 131072);
        wlViewName.setText(BaseMessages.getString(PKG, (String)"CouchDbInputDialog.ViewName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlViewName);
        FormData fdlViewName = new FormData();
        fdlViewName.left = new FormAttachment(0, 0);
        fdlViewName.right = new FormAttachment(middle, -margin);
        fdlViewName.top = new FormAttachment((Control)lastControl, margin);
        wlViewName.setLayoutData((Object)fdlViewName);
        this.wViewName = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wViewName);
        this.wViewName.addModifyListener(lsMod);
        FormData fdViewName = new FormData();
        fdViewName.left = new FormAttachment(middle, 0);
        fdViewName.top = new FormAttachment((Control)lastControl, margin);
        fdViewName.right = new FormAttachment(100, 0);
        this.wViewName.setLayoutData((Object)fdViewName);
        lastControl = this.wViewName;
        Label wlAuthUser = new Label((Composite)this.shell, 131072);
        wlAuthUser.setText(BaseMessages.getString(PKG, (String)"CouchDbInputDialog.AuthenticationUser.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAuthUser);
        FormData fdlAuthUser = new FormData();
        fdlAuthUser.left = new FormAttachment(0, -margin);
        fdlAuthUser.top = new FormAttachment((Control)lastControl, margin);
        fdlAuthUser.right = new FormAttachment(middle, -margin);
        wlAuthUser.setLayoutData((Object)fdlAuthUser);
        this.wAuthUser = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 2056);
        this.wAuthUser.setEditable(true);
        this.props.setLook((Control)this.wAuthUser);
        this.wAuthUser.addModifyListener(lsMod);
        FormData fdAuthUser = new FormData();
        fdAuthUser.left = new FormAttachment(middle, 0);
        fdAuthUser.top = new FormAttachment((Control)lastControl, margin);
        fdAuthUser.right = new FormAttachment(100, 0);
        this.wAuthUser.setLayoutData((Object)fdAuthUser);
        lastControl = this.wAuthUser;
        Label wlAuthPass = new Label((Composite)this.shell, 131072);
        wlAuthPass.setText(BaseMessages.getString(PKG, (String)"CouchDbInputDialog.AuthenticationPassword.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAuthPass);
        FormData fdlAuthPass = new FormData();
        fdlAuthPass.left = new FormAttachment(0, -margin);
        fdlAuthPass.top = new FormAttachment((Control)lastControl, margin);
        fdlAuthPass.right = new FormAttachment(middle, -margin);
        wlAuthPass.setLayoutData((Object)fdlAuthPass);
        this.wAuthPass = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 2056);
        this.wAuthPass.setEditable(true);
        this.wAuthPass.setEchoChar('*');
        this.props.setLook((Control)this.wAuthPass);
        this.wAuthPass.addModifyListener(lsMod);
        FormData fdAuthPass = new FormData();
        fdAuthPass.left = new FormAttachment(middle, 0);
        fdAuthPass.top = new FormAttachment((Control)this.wAuthUser, margin);
        fdAuthPass.right = new FormAttachment(100, 0);
        this.wAuthPass.setLayoutData((Object)fdAuthPass);
        lastControl = this.wAuthPass;
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Preview", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wPreview, this.wCancel}, margin, (Control)lastControl);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                CouchDbInputDialog.this.cancel();
            }
        };
        this.lsPreview = new Listener(){

            public void handleEvent(Event e) {
                CouchDbInputDialog.this.preview();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                CouchDbInputDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wPreview.addListener(13, this.lsPreview);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                CouchDbInputDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wHostname.addSelectionListener(this.lsDef);
        this.wDbName.addSelectionListener(this.lsDef);
        this.wViewName.addSelectionListener(this.lsDef);
        this.wAuthUser.addSelectionListener(this.lsDef);
        this.wAuthPass.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                CouchDbInputDialog.this.cancel();
            }
        });
        this.getData();
        this.input.setChanged(this.changed);
        this.setSize();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        this.wHostname.setText(Const.NVL((String)this.input.getHostname(), (String)""));
        this.wPort.setText(Const.NVL((String)this.input.getPort(), (String)""));
        this.wDbName.setText(Const.NVL((String)this.input.getDbName(), (String)""));
        this.wDesignDocument.setText(Const.NVL((String)this.input.getDesignDocument(), (String)""));
        this.wViewName.setText(Const.NVL((String)this.input.getViewName(), (String)""));
        this.wAuthUser.setText(Const.NVL((String)this.input.getAuthenticationUser(), (String)""));
        this.wAuthPass.setText(Const.NVL((String)this.input.getAuthenticationPassword(), (String)""));
        this.wStepname.selectAll();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(CouchDbInputMeta meta) {
        meta.setHostname(this.wHostname.getText());
        meta.setPort(this.wPort.getText());
        meta.setDbName(this.wDbName.getText());
        meta.setDesignDocument(this.wDesignDocument.getText());
        meta.setViewName(this.wViewName.getText());
        meta.setAuthenticationUser(this.wAuthUser.getText());
        meta.setAuthenticationPassword(this.wAuthPass.getText());
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.getInfo(this.input);
        this.dispose();
    }

    private void preview() {
        CouchDbInputMeta oneMeta = new CouchDbInputMeta();
        this.getInfo(oneMeta);
        TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)oneMeta, (String)this.wStepname.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"CouchDbInputDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CouchDbInputDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{previewSize});
            progressDialog.open();
            Trans trans = progressDialog.getTrans();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.wStepname.getText(), progressDialog.getPreviewRowsMeta(this.wStepname.getText()), progressDialog.getPreviewRows(this.wStepname.getText()), loggingText);
            prd.open();
        }
    }
}

