/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pensol.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.AuthCache;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.protocol.HttpContext;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.reporting.engine.classic.core.util.HttpClientManager;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.MemoryByteArrayOutputStream;
import org.pentaho.reporting.libraries.pensol.LibPensolBoot;
import org.pentaho.reporting.libraries.pensol.vfs.FileInfo;
import org.pentaho.reporting.libraries.pensol.vfs.XmlSolutionFileModel;

public class LocalFileModel
extends XmlSolutionFileModel {
    private static final Log logger = LogFactory.getLog(LocalFileModel.class);
    private String url;
    private String username;
    private String password;
    private HttpClient client;
    private HttpClientContext context;

    @Deprecated
    public LocalFileModel(String url, HttpClient client, String username, String password) {
        if (url == null) {
            throw new NullPointerException();
        }
        this.url = url;
        this.username = username;
        this.password = password;
        this.client = client;
        this.client.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        this.client.getParams().setParameter("http.protocol.max-redirects", (Object)10);
        this.client.getParams().setParameter("http.protocol.allow-circular-redirects", (Object)Boolean.TRUE);
        this.client.getParams().setParameter("http.protocol.reject-relative-redirect", (Object)Boolean.FALSE);
        this.context = HttpClientContext.create();
    }

    @Deprecated
    public LocalFileModel(String url, HttpClient client, String username, String password, String hostName, int port) {
        if (url == null) {
            throw new NullPointerException();
        }
        this.url = url;
        this.username = username;
        this.password = password;
        this.client = client;
        this.context = HttpClientContext.create();
        if (!StringUtil.isEmpty((String)hostName)) {
            HttpHost target = new HttpHost(hostName, port, "http");
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(target, (AuthScheme)basicAuth);
            this.context.setAuthCache((AuthCache)authCache);
        }
        this.client.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        this.client.getParams().setParameter("http.protocol.max-redirects", (Object)10);
        this.client.getParams().setParameter("http.protocol.allow-circular-redirects", (Object)Boolean.TRUE);
        this.client.getParams().setParameter("http.protocol.reject-relative-redirect", (Object)Boolean.FALSE);
    }

    public LocalFileModel(String url, HttpClientManager.HttpClientBuilderFacade clientBuilder, String username, String password, String hostName, int port) {
        if (url == null) {
            throw new NullPointerException();
        }
        this.url = url;
        this.username = username;
        this.password = password;
        this.context = HttpClientContext.create();
        if (!StringUtil.isEmpty((String)hostName)) {
            HttpHost target = new HttpHost(hostName, port, "http");
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(target, (AuthScheme)basicAuth);
            this.context.setAuthCache((AuthCache)authCache);
        }
        clientBuilder.setCookieSpec("default");
        clientBuilder.setMaxRedirects(10);
        clientBuilder.allowCircularRedirects();
        clientBuilder.allowRelativeRedirect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws IOException {
        URI uri;
        this.getDescriptionEntries().clear();
        Configuration configuration = LibPensolBoot.getInstance().getGlobalConfig();
        String service = configuration.getConfigProperty("org.pentaho.reporting.libraries.pensol.web.LoadRepositoryDoc");
        String baseUrl = this.url + service;
        try {
            URIBuilder builder = new URIBuilder(baseUrl);
            logger.debug((Object)("Connecting to '" + baseUrl + '\''));
            if (this.username != null) {
                builder.setParameter("userid", this.username);
            }
            if (this.password != null) {
                builder.setParameter("password", this.password);
            }
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new IOException("Provided URL is invalid: " + baseUrl);
        }
        HttpPost filePost = new HttpPost(uri);
        filePost.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        HttpResponse httpResponse = this.client.execute((HttpUriRequest)filePost, (HttpContext)this.context);
        int lastStatus = httpResponse.getStatusLine().getStatusCode();
        if (lastStatus == 401) {
            throw new IOException("401: User authentication failed.");
        }
        if (lastStatus == 404) {
            throw new IOException("404: Repository service not found on server.");
        }
        if (lastStatus != 200) {
            throw new IOException("Server error: HTTP lastStatus code " + lastStatus);
        }
        try (InputStream postResult = httpResponse.getEntity().getContent();){
            this.setRoot(this.performParse(postResult));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] getDataInternally(FileInfo fileInfo) throws FileSystemException {
        byte[] byArray;
        URI uri;
        String baseUrl = fileInfo.getUrl();
        try {
            URIBuilder builder = new URIBuilder(baseUrl);
            logger.debug((Object)("Connecting to '" + baseUrl + '\''));
            if (this.username != null) {
                builder.setParameter("userid", this.username);
            }
            if (this.password != null) {
                builder.setParameter("password", this.password);
            }
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new FileSystemException("Provided URL is invalid: " + baseUrl);
        }
        HttpPost filePost = new HttpPost(uri);
        filePost.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        HttpResponse httpResponse = this.client.execute((HttpUriRequest)filePost, (HttpContext)this.context);
        int lastStatus = httpResponse.getStatusLine().getStatusCode();
        if (lastStatus == 401) {
            throw new FileSystemException("401: User authentication failed.");
        }
        if (lastStatus == 404) {
            throw new FileSystemException("404: Repository service not found on server.");
        }
        if (lastStatus != 200) {
            throw new FileSystemException("Server error: HTTP lastStatus code " + lastStatus);
        }
        InputStream postResult = httpResponse.getEntity().getContent();
        try {
            MemoryByteArrayOutputStream bout = new MemoryByteArrayOutputStream();
            IOUtils.getInstance().copyStreams(postResult, (OutputStream)bout);
            byArray = bout.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                postResult.close();
                throw throwable;
            }
            catch (FileSystemException ioe) {
                throw ioe;
            }
            catch (IOException ioe) {
                throw new FileSystemException("Failed", (Throwable)ioe);
            }
        }
        postResult.close();
        return byArray;
    }

    @Override
    public void createFolder(FileName file) throws FileSystemException {
        String[] fileName = this.computeFileNames(file);
        if (fileName.length < 2) {
            throw new FileSystemException("Cannot create directory in the root.");
        }
        String[] parentPath = new String[fileName.length - 1];
        System.arraycopy(fileName, 0, parentPath, 0, parentPath.length);
        FileInfo fileInfo = this.lookupNode(parentPath);
        if (fileInfo == null) {
            throw new FileSystemException("Cannot locate parent directory.");
        }
        try {
            URI uri;
            String solution = fileName[0];
            String path = this.buildPath(fileName, 1, fileName.length - 1);
            String name = fileName[fileName.length - 1];
            String description = this.getDescriptionEntries().get(file);
            if (description == null) {
                description = "";
            }
            Configuration config = LibPensolBoot.getInstance().getGlobalConfig();
            String urlMessage = config.getConfigProperty("org.pentaho.reporting.libraries.pensol.web.CreateNewFolder");
            MessageFormat fmt = new MessageFormat(urlMessage);
            String fullpath = fmt.format(new Object[]{URLEncoder.encode(solution, "UTF-8"), URLEncoder.encode(path, "UTF-8"), URLEncoder.encode(name, "UTF-8"), URLEncoder.encode(description, "UTF-8")});
            String baseUrl = this.url + fullpath;
            try {
                URIBuilder builder = new URIBuilder(baseUrl);
                logger.debug((Object)("Connecting to '" + baseUrl + '\''));
                if (this.username != null) {
                    builder.setParameter("user", this.username);
                }
                if (this.password != null) {
                    builder.setParameter("password", this.password);
                }
                uri = builder.build();
            }
            catch (URISyntaxException e) {
                throw new FileSystemException("Provided URL is invalid: " + baseUrl);
            }
            HttpPost filePost = new HttpPost(uri);
            filePost.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            HttpResponse httpResponse = this.client.execute((HttpUriRequest)filePost, (HttpContext)this.context);
            int lastStatus = httpResponse.getStatusLine().getStatusCode();
            if (lastStatus != 200) {
                throw new FileSystemException("Server error: HTTP status code " + lastStatus);
            }
            if (name == null) {
                throw new FileSystemException("Error creating folder: Empty name");
            }
            new FileInfo(fileInfo, name, description);
        }
        catch (FileSystemException fse) {
            throw fse;
        }
        catch (IOException ioe) {
            throw new FileSystemException("Failed", (Throwable)ioe);
        }
    }

    private String buildPath(String[] fileName, int index, int endIndex) {
        StringBuilder b = new StringBuilder(100);
        for (int i = index; i < endIndex; ++i) {
            if (i != index) {
                b.append('/');
            }
            b.append(fileName[i]);
        }
        return b.toString();
    }

    @Override
    public long getContentSize(FileName name) throws FileSystemException {
        return 0L;
    }

    @Override
    protected void setDataInternally(FileInfo fileInfo, byte[] data) throws FileSystemException {
        throw new FileSystemException("Not supported");
    }

    @Override
    public boolean delete(FileName name) throws FileSystemException {
        throw new FileSystemException("Not supported");
    }
}

