/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.SparkHashTableSinkOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.exec.spark.SparkTask;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorMapJoinOuterFilteredOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorSMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IdentityExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerBigOnlyLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerBigOnlyMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerBigOnlyStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinLeftSemiLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinLeftSemiMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinLeftSemiStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinOuterLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinOuterMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinOuterStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.reducesink.VectorReduceSinkLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.reducesink.VectorReduceSinkMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.reducesink.VectorReduceSinkStringOperator;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.PreOrderOnceWalker;
import org.apache.hadoop.hive.ql.lib.PreOrderWalker;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.TaskGraphWalker;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalPlanResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.SparkHashTableSinkDesc;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.plan.VectorGroupByDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.ql.plan.VectorPartitionDesc;
import org.apache.hadoop.hive.ql.plan.VectorReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.VectorReduceSinkInfo;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.udf.UDFAcos;
import org.apache.hadoop.hive.ql.udf.UDFAsin;
import org.apache.hadoop.hive.ql.udf.UDFAtan;
import org.apache.hadoop.hive.ql.udf.UDFBin;
import org.apache.hadoop.hive.ql.udf.UDFConv;
import org.apache.hadoop.hive.ql.udf.UDFCos;
import org.apache.hadoop.hive.ql.udf.UDFDayOfMonth;
import org.apache.hadoop.hive.ql.udf.UDFDegrees;
import org.apache.hadoop.hive.ql.udf.UDFExp;
import org.apache.hadoop.hive.ql.udf.UDFFromUnixTime;
import org.apache.hadoop.hive.ql.udf.UDFHex;
import org.apache.hadoop.hive.ql.udf.UDFHour;
import org.apache.hadoop.hive.ql.udf.UDFLength;
import org.apache.hadoop.hive.ql.udf.UDFLike;
import org.apache.hadoop.hive.ql.udf.UDFLn;
import org.apache.hadoop.hive.ql.udf.UDFLog;
import org.apache.hadoop.hive.ql.udf.UDFLog10;
import org.apache.hadoop.hive.ql.udf.UDFLog2;
import org.apache.hadoop.hive.ql.udf.UDFMinute;
import org.apache.hadoop.hive.ql.udf.UDFMonth;
import org.apache.hadoop.hive.ql.udf.UDFRadians;
import org.apache.hadoop.hive.ql.udf.UDFRand;
import org.apache.hadoop.hive.ql.udf.UDFRegExpExtract;
import org.apache.hadoop.hive.ql.udf.UDFRegExpReplace;
import org.apache.hadoop.hive.ql.udf.UDFSecond;
import org.apache.hadoop.hive.ql.udf.UDFSign;
import org.apache.hadoop.hive.ql.udf.UDFSin;
import org.apache.hadoop.hive.ql.udf.UDFSqrt;
import org.apache.hadoop.hive.ql.udf.UDFSubstr;
import org.apache.hadoop.hive.ql.udf.UDFTan;
import org.apache.hadoop.hive.ql.udf.UDFToBoolean;
import org.apache.hadoop.hive.ql.udf.UDFToByte;
import org.apache.hadoop.hive.ql.udf.UDFToDouble;
import org.apache.hadoop.hive.ql.udf.UDFToFloat;
import org.apache.hadoop.hive.ql.udf.UDFToInteger;
import org.apache.hadoop.hive.ql.udf.UDFToLong;
import org.apache.hadoop.hive.ql.udf.UDFToShort;
import org.apache.hadoop.hive.ql.udf.UDFToString;
import org.apache.hadoop.hive.ql.udf.UDFWeekOfYear;
import org.apache.hadoop.hive.ql.udf.UDFYear;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAbs;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBRound;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCeil;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCoalesce;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFConcat;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateAdd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateDiff;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateSub;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFElt;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFloor;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIf;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInitCap;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLower;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFNvl;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPDivide;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMinus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMod;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMultiply;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNegative;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPlus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPositive;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPosMod;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPower;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRegExp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRound;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToChar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDecimal;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToIntervalDayTime;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToIntervalYearMonth;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToVarchar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUpper;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFWhen;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.NullStructSerDe;
import org.apache.hadoop.hive.serde2.binarysortable.BinarySortableSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Vectorizer
implements PhysicalPlanResolver {
    protected static final transient Logger LOG = LoggerFactory.getLogger(Vectorizer.class);
    static Pattern supportedDataTypesPattern;
    List<Task<? extends Serializable>> vectorizableTasks = new ArrayList<Task<? extends Serializable>>();
    Set<Class<?>> supportedGenericUDFs = new HashSet();
    Set<String> supportedAggregationUdfs = new HashSet<String>();
    private HiveConf hiveConf;
    private boolean isSpark;
    boolean useVectorizedInputFileFormat;
    boolean useVectorDeserialize;
    boolean useRowDeserialize;
    boolean isSchemaEvolution;
    VectorizationContext.HiveVectorAdaptorUsageMode hiveVectorAdaptorUsageMode;

    public Vectorizer() {
        this.supportedGenericUDFs.add(GenericUDFOPPlus.class);
        this.supportedGenericUDFs.add(GenericUDFOPMinus.class);
        this.supportedGenericUDFs.add(GenericUDFOPMultiply.class);
        this.supportedGenericUDFs.add(GenericUDFOPDivide.class);
        this.supportedGenericUDFs.add(GenericUDFOPMod.class);
        this.supportedGenericUDFs.add(GenericUDFOPNegative.class);
        this.supportedGenericUDFs.add(GenericUDFOPPositive.class);
        this.supportedGenericUDFs.add(GenericUDFOPEqualOrLessThan.class);
        this.supportedGenericUDFs.add(GenericUDFOPEqualOrGreaterThan.class);
        this.supportedGenericUDFs.add(GenericUDFOPGreaterThan.class);
        this.supportedGenericUDFs.add(GenericUDFOPLessThan.class);
        this.supportedGenericUDFs.add(GenericUDFOPNot.class);
        this.supportedGenericUDFs.add(GenericUDFOPNotEqual.class);
        this.supportedGenericUDFs.add(GenericUDFOPNotNull.class);
        this.supportedGenericUDFs.add(GenericUDFOPNull.class);
        this.supportedGenericUDFs.add(GenericUDFOPOr.class);
        this.supportedGenericUDFs.add(GenericUDFOPAnd.class);
        this.supportedGenericUDFs.add(GenericUDFOPEqual.class);
        this.supportedGenericUDFs.add(UDFLength.class);
        this.supportedGenericUDFs.add(UDFYear.class);
        this.supportedGenericUDFs.add(UDFMonth.class);
        this.supportedGenericUDFs.add(UDFDayOfMonth.class);
        this.supportedGenericUDFs.add(UDFHour.class);
        this.supportedGenericUDFs.add(UDFMinute.class);
        this.supportedGenericUDFs.add(UDFSecond.class);
        this.supportedGenericUDFs.add(UDFWeekOfYear.class);
        this.supportedGenericUDFs.add(GenericUDFToUnixTimeStamp.class);
        this.supportedGenericUDFs.add(UDFFromUnixTime.class);
        this.supportedGenericUDFs.add(GenericUDFDateAdd.class);
        this.supportedGenericUDFs.add(GenericUDFDateSub.class);
        this.supportedGenericUDFs.add(GenericUDFDate.class);
        this.supportedGenericUDFs.add(GenericUDFDateDiff.class);
        this.supportedGenericUDFs.add(UDFLike.class);
        this.supportedGenericUDFs.add(GenericUDFRegExp.class);
        this.supportedGenericUDFs.add(UDFRegExpExtract.class);
        this.supportedGenericUDFs.add(UDFRegExpReplace.class);
        this.supportedGenericUDFs.add(UDFSubstr.class);
        this.supportedGenericUDFs.add(GenericUDFLTrim.class);
        this.supportedGenericUDFs.add(GenericUDFRTrim.class);
        this.supportedGenericUDFs.add(GenericUDFTrim.class);
        this.supportedGenericUDFs.add(UDFSin.class);
        this.supportedGenericUDFs.add(UDFCos.class);
        this.supportedGenericUDFs.add(UDFTan.class);
        this.supportedGenericUDFs.add(UDFAsin.class);
        this.supportedGenericUDFs.add(UDFAcos.class);
        this.supportedGenericUDFs.add(UDFAtan.class);
        this.supportedGenericUDFs.add(UDFDegrees.class);
        this.supportedGenericUDFs.add(UDFRadians.class);
        this.supportedGenericUDFs.add(GenericUDFFloor.class);
        this.supportedGenericUDFs.add(GenericUDFCeil.class);
        this.supportedGenericUDFs.add(UDFExp.class);
        this.supportedGenericUDFs.add(UDFLn.class);
        this.supportedGenericUDFs.add(UDFLog2.class);
        this.supportedGenericUDFs.add(UDFLog10.class);
        this.supportedGenericUDFs.add(UDFLog.class);
        this.supportedGenericUDFs.add(GenericUDFPower.class);
        this.supportedGenericUDFs.add(GenericUDFRound.class);
        this.supportedGenericUDFs.add(GenericUDFBRound.class);
        this.supportedGenericUDFs.add(GenericUDFPosMod.class);
        this.supportedGenericUDFs.add(UDFSqrt.class);
        this.supportedGenericUDFs.add(UDFSign.class);
        this.supportedGenericUDFs.add(UDFRand.class);
        this.supportedGenericUDFs.add(UDFBin.class);
        this.supportedGenericUDFs.add(UDFHex.class);
        this.supportedGenericUDFs.add(UDFConv.class);
        this.supportedGenericUDFs.add(GenericUDFLower.class);
        this.supportedGenericUDFs.add(GenericUDFUpper.class);
        this.supportedGenericUDFs.add(GenericUDFConcat.class);
        this.supportedGenericUDFs.add(GenericUDFAbs.class);
        this.supportedGenericUDFs.add(GenericUDFBetween.class);
        this.supportedGenericUDFs.add(GenericUDFIn.class);
        this.supportedGenericUDFs.add(GenericUDFCase.class);
        this.supportedGenericUDFs.add(GenericUDFWhen.class);
        this.supportedGenericUDFs.add(GenericUDFCoalesce.class);
        this.supportedGenericUDFs.add(GenericUDFNvl.class);
        this.supportedGenericUDFs.add(GenericUDFElt.class);
        this.supportedGenericUDFs.add(GenericUDFInitCap.class);
        this.supportedGenericUDFs.add(UDFToLong.class);
        this.supportedGenericUDFs.add(UDFToInteger.class);
        this.supportedGenericUDFs.add(UDFToShort.class);
        this.supportedGenericUDFs.add(UDFToByte.class);
        this.supportedGenericUDFs.add(UDFToBoolean.class);
        this.supportedGenericUDFs.add(UDFToFloat.class);
        this.supportedGenericUDFs.add(UDFToDouble.class);
        this.supportedGenericUDFs.add(UDFToString.class);
        this.supportedGenericUDFs.add(GenericUDFTimestamp.class);
        this.supportedGenericUDFs.add(GenericUDFToDecimal.class);
        this.supportedGenericUDFs.add(GenericUDFToDate.class);
        this.supportedGenericUDFs.add(GenericUDFToChar.class);
        this.supportedGenericUDFs.add(GenericUDFToVarchar.class);
        this.supportedGenericUDFs.add(GenericUDFToIntervalYearMonth.class);
        this.supportedGenericUDFs.add(GenericUDFToIntervalDayTime.class);
        this.supportedGenericUDFs.add(GenericUDFIf.class);
        this.supportedAggregationUdfs.add("min");
        this.supportedAggregationUdfs.add("max");
        this.supportedAggregationUdfs.add("count");
        this.supportedAggregationUdfs.add("sum");
        this.supportedAggregationUdfs.add("avg");
        this.supportedAggregationUdfs.add("variance");
        this.supportedAggregationUdfs.add("var_pop");
        this.supportedAggregationUdfs.add("var_samp");
        this.supportedAggregationUdfs.add("std");
        this.supportedAggregationUdfs.add("stddev");
        this.supportedAggregationUdfs.add("stddev_pop");
        this.supportedAggregationUdfs.add("stddev_samp");
    }

    @Override
    public PhysicalContext resolve(PhysicalContext physicalContext) throws SemanticException {
        this.hiveConf = physicalContext.getConf();
        boolean vectorPath = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED);
        if (!vectorPath) {
            LOG.info("Vectorization is disabled");
            return physicalContext;
        }
        this.isSpark = HiveConf.getVar(this.hiveConf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("spark");
        this.useVectorizedInputFileFormat = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTORIZED_INPUT_FILE_FORMAT);
        this.useVectorDeserialize = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTOR_DESERIALIZE);
        this.useRowDeserialize = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_USE_ROW_DESERIALIZE);
        this.isSchemaEvolution = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_SCHEMA_EVOLUTION);
        this.hiveVectorAdaptorUsageMode = VectorizationContext.HiveVectorAdaptorUsageMode.getHiveConfValue(this.hiveConf);
        VectorizationDispatcher disp = new VectorizationDispatcher(physicalContext);
        TaskGraphWalker ogw = new TaskGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(physicalContext.getRootTasks());
        ogw.startWalking(topNodes, null);
        return physicalContext;
    }

    boolean validateMapWorkOperator(Operator<? extends OperatorDesc> op, MapWork mWork, boolean isTez) {
        boolean ret = false;
        switch (op.getType()) {
            case MAPJOIN: {
                if (op instanceof MapJoinOperator) {
                    ret = this.validateMapJoinOperator((MapJoinOperator)op);
                    break;
                }
                if (!(op instanceof SMBMapJoinOperator)) break;
                ret = this.validateSMBMapJoinOperator((SMBMapJoinOperator)op);
                break;
            }
            case GROUPBY: {
                ret = this.validateGroupByOperator((GroupByOperator)op, false, isTez);
                break;
            }
            case FILTER: {
                ret = this.validateFilterOperator((FilterOperator)op);
                break;
            }
            case SELECT: {
                ret = this.validateSelectOperator((SelectOperator)op);
                break;
            }
            case REDUCESINK: {
                ret = this.validateReduceSinkOperator((ReduceSinkOperator)op);
                break;
            }
            case TABLESCAN: {
                ret = this.validateTableScanOperator((TableScanOperator)op, mWork);
                break;
            }
            case FILESINK: 
            case LIMIT: 
            case EVENT: 
            case SPARKPRUNINGSINK: {
                ret = true;
                break;
            }
            case HASHTABLESINK: {
                ret = op instanceof SparkHashTableSinkOperator && this.validateSparkHashTableSinkOperator((SparkHashTableSinkOperator)op);
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }

    boolean validateReduceWorkOperator(Operator<? extends OperatorDesc> op) {
        boolean ret = false;
        switch (op.getType()) {
            case MAPJOIN: {
                if (op instanceof MapJoinOperator) {
                    ret = this.validateMapJoinOperator((MapJoinOperator)op);
                    break;
                }
                if (!(op instanceof SMBMapJoinOperator)) break;
                ret = this.validateSMBMapJoinOperator((SMBMapJoinOperator)op);
                break;
            }
            case GROUPBY: {
                if (HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_REDUCE_GROUPBY_ENABLED)) {
                    ret = this.validateGroupByOperator((GroupByOperator)op, true, true);
                    break;
                }
                ret = false;
                break;
            }
            case FILTER: {
                ret = this.validateFilterOperator((FilterOperator)op);
                break;
            }
            case SELECT: {
                ret = this.validateSelectOperator((SelectOperator)op);
                break;
            }
            case REDUCESINK: {
                ret = this.validateReduceSinkOperator((ReduceSinkOperator)op);
                break;
            }
            case FILESINK: {
                ret = this.validateFileSinkOperator((FileSinkOperator)op);
                break;
            }
            case LIMIT: 
            case EVENT: 
            case SPARKPRUNINGSINK: {
                ret = true;
                break;
            }
            case HASHTABLESINK: {
                ret = op instanceof SparkHashTableSinkOperator && this.validateSparkHashTableSinkOperator((SparkHashTableSinkOperator)op);
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }

    private void addOperatorChildrenToSet(Operator<? extends OperatorDesc> op, Set<Operator<? extends OperatorDesc>> nonVectorizedOps) {
        for (Operator<OperatorDesc> childOp : op.getChildOperators()) {
            if (nonVectorizedOps.contains(childOp)) continue;
            nonVectorizedOps.add(childOp);
            this.addOperatorChildrenToSet(childOp, nonVectorizedOps);
        }
    }

    private Boolean isVectorizedGroupByThatOutputsRows(Operator<? extends OperatorDesc> op) throws SemanticException {
        if (op.getType().equals(OperatorType.GROUPBY)) {
            GroupByDesc desc = (GroupByDesc)op.getConf();
            return !desc.getVectorDesc().isVectorOutput();
        }
        return false;
    }

    private boolean validateSMBMapJoinOperator(SMBMapJoinOperator op) {
        SMBJoinDesc desc = (SMBJoinDesc)op.getConf();
        return this.validateMapJoinDesc(desc);
    }

    private boolean validateTableScanOperator(TableScanOperator op, MapWork mWork) {
        TableScanDesc desc = (TableScanDesc)op.getConf();
        return !desc.isGatherStats();
    }

    private boolean validateMapJoinOperator(MapJoinOperator op) {
        MapJoinDesc desc = (MapJoinDesc)op.getConf();
        return this.validateMapJoinDesc(desc);
    }

    private boolean validateMapJoinDesc(MapJoinDesc desc) {
        byte posBigTable = (byte)desc.getPosBigTable();
        List<ExprNodeDesc> filterExprs = desc.getFilters().get(posBigTable);
        if (!this.validateExprNodeDesc(filterExprs, VectorExpressionDescriptor.Mode.FILTER)) {
            LOG.info("Cannot vectorize map work filter expression");
            return false;
        }
        List<ExprNodeDesc> keyExprs = desc.getKeys().get(posBigTable);
        if (!this.validateExprNodeDesc(keyExprs)) {
            LOG.info("Cannot vectorize map work key expression");
            return false;
        }
        List<ExprNodeDesc> valueExprs = desc.getExprs().get(posBigTable);
        if (!this.validateExprNodeDesc(valueExprs)) {
            LOG.info("Cannot vectorize map work value expression");
            return false;
        }
        Byte[] order = desc.getTagOrder();
        Byte posSingleVectorMapJoinSmallTable = order[0] == posBigTable ? order[1] : order[0];
        List<ExprNodeDesc> smallTableExprs = desc.getExprs().get(posSingleVectorMapJoinSmallTable);
        if (!this.validateExprNodeDesc(smallTableExprs)) {
            LOG.info("Cannot vectorize map work small table expression");
            return false;
        }
        return true;
    }

    private boolean validateSparkHashTableSinkOperator(SparkHashTableSinkOperator op) {
        SparkHashTableSinkDesc desc = (SparkHashTableSinkDesc)op.getConf();
        byte tag = desc.getTag();
        List<ExprNodeDesc> filterExprs = desc.getFilters().get(tag);
        List<ExprNodeDesc> keyExprs = desc.getKeys().get(tag);
        List<ExprNodeDesc> valueExprs = desc.getExprs().get(tag);
        return this.validateExprNodeDesc(filterExprs, VectorExpressionDescriptor.Mode.FILTER) && this.validateExprNodeDesc(keyExprs) && this.validateExprNodeDesc(valueExprs);
    }

    private boolean validateReduceSinkOperator(ReduceSinkOperator op) {
        ArrayList<ExprNodeDesc> keyDescs = ((ReduceSinkDesc)op.getConf()).getKeyCols();
        ArrayList<ExprNodeDesc> partitionDescs = ((ReduceSinkDesc)op.getConf()).getPartitionCols();
        ArrayList<ExprNodeDesc> valueDesc = ((ReduceSinkDesc)op.getConf()).getValueCols();
        return this.validateExprNodeDesc(keyDescs) && this.validateExprNodeDesc(partitionDescs) && this.validateExprNodeDesc(valueDesc);
    }

    private boolean validateSelectOperator(SelectOperator op) {
        List<ExprNodeDesc> descList = ((SelectDesc)op.getConf()).getColList();
        for (ExprNodeDesc desc : descList) {
            boolean ret = this.validateExprNodeDesc(desc);
            if (ret) continue;
            LOG.info("Cannot vectorize select expression: " + desc.toString());
            return false;
        }
        return true;
    }

    private boolean validateFilterOperator(FilterOperator op) {
        ExprNodeDesc desc = ((FilterDesc)op.getConf()).getPredicate();
        return this.validateExprNodeDesc(desc, VectorExpressionDescriptor.Mode.FILTER);
    }

    private boolean validateGroupByOperator(GroupByOperator op, boolean isReduce, boolean isTez) {
        GroupByDesc desc = (GroupByDesc)op.getConf();
        VectorGroupByDesc vectorDesc = desc.getVectorDesc();
        if (desc.isGroupingSetsPresent()) {
            LOG.info("Grouping sets not supported in vector mode");
            return false;
        }
        if (desc.pruneGroupingSetId()) {
            LOG.info("Pruning grouping set id not supported in vector mode");
            return false;
        }
        boolean ret = this.validateExprNodeDesc(desc.getKeys());
        if (!ret) {
            LOG.info("Cannot vectorize groupby key expression");
            return false;
        }
        if (!isReduce) {
            ret = this.validateHashAggregationDesc(desc.getAggregators());
            if (!ret) {
                return false;
            }
        } else {
            boolean isComplete;
            boolean bl = isComplete = desc.getMode() == GroupByDesc.Mode.COMPLETE;
            if (desc.getMode() != GroupByDesc.Mode.HASH) {
                if (desc.isDistinct()) {
                    LOG.info("Vectorized Reduce MergePartial GROUP BY does not support DISTINCT");
                    return false;
                }
                boolean hasKeys = desc.getKeys().size() > 0;
                ret = this.validateReduceMergePartialAggregationDesc(desc.getAggregators(), hasKeys);
                if (!ret) {
                    return false;
                }
                if (hasKeys) {
                    if (op.getParentOperators().size() > 0 && !isComplete) {
                        LOG.info("Vectorized Reduce MergePartial GROUP BY keys can only handle a key group when it is fed by reduce-shuffle");
                        return false;
                    }
                    LOG.info("Vectorized Reduce MergePartial GROUP BY will process key groups");
                    vectorDesc.setVectorOutput(true);
                } else {
                    LOG.info("Vectorized Reduce MergePartial GROUP BY will do global aggregation");
                }
                if (!isComplete) {
                    vectorDesc.setIsReduceMergePartial(true);
                } else {
                    vectorDesc.setIsReduceStreaming(true);
                }
            } else {
                ret = this.validateHashAggregationDesc(desc.getAggregators());
                if (!ret) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean validateFileSinkOperator(FileSinkOperator op) {
        return true;
    }

    private boolean validateExprNodeDesc(List<ExprNodeDesc> descs) {
        return this.validateExprNodeDesc(descs, VectorExpressionDescriptor.Mode.PROJECTION);
    }

    private boolean validateExprNodeDesc(List<ExprNodeDesc> descs, VectorExpressionDescriptor.Mode mode) {
        for (ExprNodeDesc d : descs) {
            boolean ret = this.validateExprNodeDesc(d, mode);
            if (ret) continue;
            return false;
        }
        return true;
    }

    private boolean validateHashAggregationDesc(List<AggregationDesc> descs) {
        return this.validateAggregationDesc(descs, false, false);
    }

    private boolean validateReduceMergePartialAggregationDesc(List<AggregationDesc> descs, boolean hasKeys) {
        return this.validateAggregationDesc(descs, true, hasKeys);
    }

    private boolean validateAggregationDesc(List<AggregationDesc> descs, boolean isReduceMergePartial, boolean hasKeys) {
        for (AggregationDesc d : descs) {
            boolean ret = this.validateAggregationDesc(d, isReduceMergePartial, hasKeys);
            if (ret) continue;
            return false;
        }
        return true;
    }

    private boolean validateExprNodeDescRecursive(ExprNodeDesc desc, VectorExpressionDescriptor.Mode mode) {
        ExprNodeColumnDesc c;
        if (desc instanceof ExprNodeColumnDesc && VirtualColumn.VIRTUAL_COLUMN_NAMES.contains((c = (ExprNodeColumnDesc)desc).getColumn())) {
            LOG.info("Cannot vectorize virtual column " + c.getColumn());
            return false;
        }
        String typeName = desc.getTypeInfo().getTypeName();
        boolean ret = Vectorizer.validateDataType(typeName, mode);
        if (!ret) {
            LOG.info("Cannot vectorize " + desc.toString() + " of type " + typeName);
            return false;
        }
        boolean isInExpression = false;
        if (desc instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc d = (ExprNodeGenericFuncDesc)desc;
            boolean r = this.validateGenericUdf(d);
            if (!r) {
                LOG.info("Cannot vectorize UDF " + d);
                return false;
            }
            GenericUDF genericUDF = d.getGenericUDF();
            isInExpression = genericUDF instanceof GenericUDFIn;
        }
        if (desc.getChildren() != null) {
            if (isInExpression && desc.getChildren().get(0).getTypeInfo().getCategory() == ObjectInspector.Category.STRUCT) {
                if (!this.validateStructInExpression(desc, VectorExpressionDescriptor.Mode.FILTER)) {
                    return false;
                }
            } else {
                for (ExprNodeDesc d : desc.getChildren()) {
                    if (this.validateExprNodeDescRecursive(d, VectorExpressionDescriptor.Mode.FILTER)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean validateStructInExpression(ExprNodeDesc desc, VectorExpressionDescriptor.Mode mode) {
        for (ExprNodeDesc d : desc.getChildren()) {
            TypeInfo typeInfo = d.getTypeInfo();
            if (typeInfo.getCategory() != ObjectInspector.Category.STRUCT) {
                return false;
            }
            StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
            ArrayList<TypeInfo> fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
            ArrayList<String> fieldNames = structTypeInfo.getAllStructFieldNames();
            int fieldCount = fieldTypeInfos.size();
            for (int f = 0; f < fieldCount; ++f) {
                TypeInfo fieldTypeInfo = fieldTypeInfos.get(f);
                ObjectInspector.Category category = fieldTypeInfo.getCategory();
                if (category != ObjectInspector.Category.PRIMITIVE) {
                    LOG.info("Cannot vectorize struct field " + fieldNames.get(f) + " of type " + fieldTypeInfo.getTypeName());
                    return false;
                }
                PrimitiveTypeInfo fieldPrimitiveTypeInfo = (PrimitiveTypeInfo)fieldTypeInfo;
                VectorizationContext.InConstantType inConstantType = VectorizationContext.getInConstantTypeFromPrimitiveCategory(fieldPrimitiveTypeInfo.getPrimitiveCategory());
                if (inConstantType == VectorizationContext.InConstantType.INT_FAMILY || inConstantType == VectorizationContext.InConstantType.FLOAT_FAMILY || inConstantType == VectorizationContext.InConstantType.STRING_FAMILY) continue;
                LOG.info("Cannot vectorize struct field " + fieldNames.get(f) + " of type " + fieldTypeInfo.getTypeName());
                return false;
            }
        }
        return true;
    }

    private boolean validateExprNodeDesc(ExprNodeDesc desc) {
        return this.validateExprNodeDesc(desc, VectorExpressionDescriptor.Mode.PROJECTION);
    }

    boolean validateExprNodeDesc(ExprNodeDesc desc, VectorExpressionDescriptor.Mode mode) {
        if (!this.validateExprNodeDescRecursive(desc, mode)) {
            return false;
        }
        try {
            ValidatorVectorizationContext vc = new ValidatorVectorizationContext(this.hiveConf);
            if (vc.getVectorExpression(desc, mode) == null) {
                LOG.info("getVectorExpression returned null");
                return false;
            }
        }
        catch (Exception e) {
            if (e instanceof HiveException) {
                LOG.info(e.getMessage());
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to vectorize", (Throwable)e);
            } else {
                LOG.info("Failed to vectorize", (Object)e.getMessage());
            }
            return false;
        }
        return true;
    }

    private boolean validateGenericUdf(ExprNodeGenericFuncDesc genericUDFExpr) {
        if (VectorizationContext.isCustomUDF(genericUDFExpr)) {
            return true;
        }
        if (this.hiveVectorAdaptorUsageMode == VectorizationContext.HiveVectorAdaptorUsageMode.NONE || this.hiveVectorAdaptorUsageMode == VectorizationContext.HiveVectorAdaptorUsageMode.CHOSEN) {
            GenericUDF genericUDF = genericUDFExpr.getGenericUDF();
            if (genericUDF instanceof GenericUDFBridge) {
                Class<? extends UDF> udf = ((GenericUDFBridge)genericUDF).getUdfClass();
                return this.supportedGenericUDFs.contains(udf);
            }
            return this.supportedGenericUDFs.contains(genericUDF.getClass());
        }
        return true;
    }

    private boolean validateAggregationIsPrimitive(VectorAggregateExpression vectorAggrExpr) {
        ObjectInspector outputObjInspector = vectorAggrExpr.getOutputObjectInspector();
        return outputObjInspector.getCategory() == ObjectInspector.Category.PRIMITIVE;
    }

    private boolean validateAggregationDesc(AggregationDesc aggDesc, boolean isReduceMergePartial, boolean hasKeys) {
        VectorAggregateExpression vectorAggrExpr;
        String udfName = aggDesc.getGenericUDAFName().toLowerCase();
        if (!this.supportedAggregationUdfs.contains(udfName)) {
            LOG.info("Cannot vectorize groupby aggregate expression: UDF " + udfName + " not supported");
            return false;
        }
        if (aggDesc.getParameters() != null && !this.validateExprNodeDesc(aggDesc.getParameters())) {
            LOG.info("Cannot vectorize groupby aggregate expression: UDF parameters not supported");
            return false;
        }
        ValidatorVectorizationContext vc = new ValidatorVectorizationContext(this.hiveConf);
        try {
            vectorAggrExpr = vc.getAggregatorExpression(aggDesc, isReduceMergePartial);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Vectorization of aggreation should have succeeded ", (Throwable)e);
            }
            return false;
        }
        if (isReduceMergePartial && hasKeys && !this.validateAggregationIsPrimitive(vectorAggrExpr)) {
            LOG.info("Vectorized Reduce MergePartial GROUP BY keys can only handle aggregate outputs that are primitive types");
            return false;
        }
        return true;
    }

    public static boolean validateDataType(String type, VectorExpressionDescriptor.Mode mode) {
        boolean result = supportedDataTypesPattern.matcher(type = type.toLowerCase()).matches();
        if (result && mode == VectorExpressionDescriptor.Mode.PROJECTION && type.equals("void")) {
            return false;
        }
        return result;
    }

    private VectorizationContext getVectorizationContext(String contextName, VectorTaskColumnInfo vectorTaskColumnInfo) {
        VectorizationContext vContext = new VectorizationContext(contextName, vectorTaskColumnInfo.columnNames, this.hiveConf);
        return vContext;
    }

    private void fixupParentChildOperators(Operator<? extends OperatorDesc> op, Operator<? extends OperatorDesc> vectorOp) {
        if (op.getParentOperators() != null) {
            vectorOp.setParentOperators(op.getParentOperators());
            for (Operator<OperatorDesc> p : op.getParentOperators()) {
                p.replaceChild(op, vectorOp);
            }
        }
        if (op.getChildOperators() != null) {
            vectorOp.setChildOperators(op.getChildOperators());
            for (Operator<OperatorDesc> c : op.getChildOperators()) {
                c.replaceParent(op, vectorOp);
            }
        }
    }

    private boolean isBigTableOnlyResults(MapJoinDesc desc) {
        int smallTableIndicesSize;
        int[] smallTableIndices;
        Byte posSingleVectorMapJoinSmallTable;
        Byte[] order = desc.getTagOrder();
        byte posBigTable = (byte)desc.getPosBigTable();
        Byte by = posSingleVectorMapJoinSmallTable = order[0] == posBigTable ? order[1] : order[0];
        if (desc.getValueIndices() != null && desc.getValueIndices().get(posSingleVectorMapJoinSmallTable) != null) {
            smallTableIndices = desc.getValueIndices().get(posSingleVectorMapJoinSmallTable);
            LOG.info("Vectorizer isBigTableOnlyResults smallTableIndices " + Arrays.toString(smallTableIndices));
            smallTableIndicesSize = smallTableIndices.length;
        } else {
            smallTableIndices = null;
            LOG.info("Vectorizer isBigTableOnlyResults smallTableIndices EMPTY");
            smallTableIndicesSize = 0;
        }
        List<Integer> smallTableRetainList = desc.getRetainList().get(posSingleVectorMapJoinSmallTable);
        LOG.info("Vectorizer isBigTableOnlyResults smallTableRetainList " + smallTableRetainList);
        int smallTableRetainSize = smallTableRetainList.size();
        if (smallTableIndicesSize > 0) {
            for (int i = 0; i < smallTableIndicesSize; ++i) {
                if (smallTableIndices[i] >= 0) continue;
                LOG.info("Vectorizer isBigTableOnlyResults smallTableIndices[i] < 0 returning false");
                return false;
            }
        } else if (smallTableRetainSize > 0) {
            LOG.info("Vectorizer isBigTableOnlyResults smallTableRetainSize > 0 returning false");
            return false;
        }
        LOG.info("Vectorizer isBigTableOnlyResults returning true");
        return true;
    }

    Operator<? extends OperatorDesc> specializeMapJoinOperator(Operator<? extends OperatorDesc> op, VectorizationContext vContext, MapJoinDesc desc) throws HiveException {
        Operator<OperatorDesc> vectorOp = null;
        Class opClass = null;
        VectorMapJoinDesc.HashTableImplementationType hashTableImplementationType = VectorMapJoinDesc.HashTableImplementationType.NONE;
        VectorMapJoinDesc.HashTableKind hashTableKind = VectorMapJoinDesc.HashTableKind.NONE;
        VectorMapJoinDesc.HashTableKeyType hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.NONE;
        hashTableImplementationType = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_FAST_HASHTABLE_ENABLED) ? VectorMapJoinDesc.HashTableImplementationType.FAST : VectorMapJoinDesc.HashTableImplementationType.OPTIMIZED;
        int joinType = desc.getConds()[0].getType();
        boolean isInnerBigOnly = false;
        if (joinType == 0 && this.isBigTableOnlyResults(desc)) {
            isInnerBigOnly = true;
        }
        hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.MULTI_KEY;
        if (!HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_MULTIKEY_ONLY_ENABLED)) {
            byte posBigTable = (byte)desc.getPosBigTable();
            Map<Byte, List<ExprNodeDesc>> keyExprs = desc.getKeys();
            List<ExprNodeDesc> bigTableKeyExprs = keyExprs.get(posBigTable);
            if (bigTableKeyExprs.size() == 1) {
                String typeName = bigTableKeyExprs.get(0).getTypeString();
                LOG.info("Vectorizer vectorizeOperator map join typeName " + typeName);
                if (typeName.equals("boolean")) {
                    hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.BOOLEAN;
                } else if (typeName.equals("tinyint")) {
                    hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.BYTE;
                } else if (typeName.equals("smallint")) {
                    hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.SHORT;
                } else if (typeName.equals("int")) {
                    hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.INT;
                } else if (typeName.equals("bigint") || typeName.equals("long")) {
                    hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.LONG;
                } else if (VectorizationContext.isStringFamily(typeName)) {
                    hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.STRING;
                }
            }
        }
        switch (joinType) {
            case 0: {
                if (!isInnerBigOnly) {
                    hashTableKind = VectorMapJoinDesc.HashTableKind.HASH_MAP;
                    break;
                }
                hashTableKind = VectorMapJoinDesc.HashTableKind.HASH_MULTISET;
                break;
            }
            case 1: 
            case 2: {
                hashTableKind = VectorMapJoinDesc.HashTableKind.HASH_MAP;
                break;
            }
            case 5: {
                hashTableKind = VectorMapJoinDesc.HashTableKind.HASH_SET;
                break;
            }
            default: {
                throw new HiveException("Unknown join type " + joinType);
            }
        }
        LOG.info("Vectorizer vectorizeOperator map join hashTableKind " + hashTableKind.name() + " hashTableKeyType " + hashTableKeyType.name());
        block5 : switch (hashTableKeyType) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                switch (joinType) {
                    case 0: {
                        if (!isInnerBigOnly) {
                            opClass = VectorMapJoinInnerLongOperator.class;
                            break block5;
                        }
                        opClass = VectorMapJoinInnerBigOnlyLongOperator.class;
                        break block5;
                    }
                    case 1: 
                    case 2: {
                        opClass = VectorMapJoinOuterLongOperator.class;
                        break block5;
                    }
                    case 5: {
                        opClass = VectorMapJoinLeftSemiLongOperator.class;
                        break block5;
                    }
                }
                throw new HiveException("Unknown join type " + joinType);
            }
            case STRING: {
                switch (joinType) {
                    case 0: {
                        if (!isInnerBigOnly) {
                            opClass = VectorMapJoinInnerStringOperator.class;
                            break block5;
                        }
                        opClass = VectorMapJoinInnerBigOnlyStringOperator.class;
                        break block5;
                    }
                    case 1: 
                    case 2: {
                        opClass = VectorMapJoinOuterStringOperator.class;
                        break block5;
                    }
                    case 5: {
                        opClass = VectorMapJoinLeftSemiStringOperator.class;
                        break block5;
                    }
                }
                throw new HiveException("Unknown join type " + joinType);
            }
            case MULTI_KEY: {
                switch (joinType) {
                    case 0: {
                        if (!isInnerBigOnly) {
                            opClass = VectorMapJoinInnerMultiKeyOperator.class;
                            break block5;
                        }
                        opClass = VectorMapJoinInnerBigOnlyMultiKeyOperator.class;
                        break block5;
                    }
                    case 1: 
                    case 2: {
                        opClass = VectorMapJoinOuterMultiKeyOperator.class;
                        break block5;
                    }
                    case 5: {
                        opClass = VectorMapJoinLeftSemiMultiKeyOperator.class;
                        break block5;
                    }
                }
                throw new HiveException("Unknown join type " + joinType);
            }
        }
        vectorOp = OperatorFactory.getVectorOperator(opClass, op.getCompilationOpContext(), op.getConf(), vContext);
        LOG.info("Vectorizer vectorizeOperator map join class " + vectorOp.getClass().getSimpleName());
        boolean minMaxEnabled = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_MINMAX_ENABLED);
        VectorMapJoinDesc vectorDesc = desc.getVectorDesc();
        vectorDesc.setHashTableImplementationType(hashTableImplementationType);
        vectorDesc.setHashTableKind(hashTableKind);
        vectorDesc.setHashTableKeyType(hashTableKeyType);
        vectorDesc.setMinMaxEnabled(minMaxEnabled);
        return vectorOp;
    }

    private boolean onExpressionHasNullSafes(MapJoinDesc desc) {
        boolean[] nullSafes = desc.getNullSafes();
        if (nullSafes == null) {
            return false;
        }
        for (boolean nullSafe : nullSafes) {
            if (!nullSafe) continue;
            return true;
        }
        return false;
    }

    private boolean canSpecializeMapJoin(Operator<? extends OperatorDesc> op, MapJoinDesc desc, boolean isTez) {
        boolean specialize = false;
        if (op instanceof MapJoinOperator && HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_ENABLED) && isTez && desc.getConds().length == 1 && !this.onExpressionHasNullSafes(desc)) {
            specialize = true;
            if (!HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_FAST_HASHTABLE_ENABLED)) {
                if (!HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVEMAPJOINUSEOPTIMIZEDTABLE)) {
                    specialize = false;
                } else {
                    byte posBigTable = (byte)desc.getPosBigTable();
                    Map<Byte, List<ExprNodeDesc>> keyExprs = desc.getKeys();
                    List<ExprNodeDesc> bigTableKeyExprs = keyExprs.get(posBigTable);
                    for (ExprNodeDesc exprNodeDesc : bigTableKeyExprs) {
                        String typeName = exprNodeDesc.getTypeString();
                        if (MapJoinKey.isSupportedField(typeName)) continue;
                        specialize = false;
                        break;
                    }
                }
            } else if (desc.isHybridHashJoin()) {
                specialize = false;
            }
        }
        return specialize;
    }

    private Operator<? extends OperatorDesc> specializeReduceSinkOperator(Operator<? extends OperatorDesc> op, VectorizationContext vContext, ReduceSinkDesc desc, VectorReduceSinkInfo vectorReduceSinkInfo) throws HiveException {
        Operator<OperatorDesc> vectorOp = null;
        Class opClass = null;
        ColumnVector.Type[] reduceSinkKeyColumnVectorTypes = vectorReduceSinkInfo.getReduceSinkKeyColumnVectorTypes();
        VectorReduceSinkDesc.ReduceSinkKeyType reduceSinkKeyType = VectorReduceSinkDesc.ReduceSinkKeyType.MULTI_KEY;
        if (reduceSinkKeyColumnVectorTypes.length == 1) {
            LOG.info("Vectorizer vectorizeOperator groupby typeName " + vectorReduceSinkInfo.getReduceSinkKeyTypeInfos()[0]);
            ColumnVector.Type columnVectorType = reduceSinkKeyColumnVectorTypes[0];
            block0 : switch (columnVectorType) {
                case LONG: {
                    PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveTypeInfo)vectorReduceSinkInfo.getReduceSinkKeyTypeInfos()[0]).getPrimitiveCategory();
                    switch (primitiveCategory) {
                        case BOOLEAN: 
                        case BYTE: 
                        case SHORT: 
                        case INT: 
                        case LONG: {
                            reduceSinkKeyType = VectorReduceSinkDesc.ReduceSinkKeyType.LONG;
                            break block0;
                        }
                    }
                    break;
                }
                case BYTES: {
                    reduceSinkKeyType = VectorReduceSinkDesc.ReduceSinkKeyType.STRING;
                }
            }
        }
        switch (reduceSinkKeyType) {
            case LONG: {
                opClass = VectorReduceSinkLongOperator.class;
                break;
            }
            case STRING: {
                opClass = VectorReduceSinkStringOperator.class;
                break;
            }
            case MULTI_KEY: {
                opClass = VectorReduceSinkMultiKeyOperator.class;
                break;
            }
            default: {
                throw new HiveException("Unknown reduce sink key type " + (Object)((Object)reduceSinkKeyType));
            }
        }
        VectorReduceSinkDesc vectorDesc = new VectorReduceSinkDesc();
        desc.setVectorDesc(vectorDesc);
        vectorDesc.setReduceSinkKeyType(reduceSinkKeyType);
        vectorDesc.setVectorReduceSinkInfo(vectorReduceSinkInfo);
        vectorOp = OperatorFactory.getVectorOperator(opClass, op.getCompilationOpContext(), op.getConf(), vContext);
        LOG.info("Vectorizer vectorizeOperator reduce sink class " + vectorOp.getClass().getSimpleName());
        return vectorOp;
    }

    private boolean canSpecializeReduceSink(ReduceSinkDesc desc, boolean isTez, VectorizationContext vContext, VectorReduceSinkInfo vectorReduceSinkInfo) throws HiveException {
        if (!HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_REDUCESINK_NEW_ENABLED)) {
            return false;
        }
        if (!isTez) {
            return false;
        }
        if (desc.getWriteType() == AcidUtils.Operation.UPDATE || desc.getWriteType() == AcidUtils.Operation.DELETE) {
            return false;
        }
        if (desc.getBucketCols() != null && !desc.getBucketCols().isEmpty()) {
            return false;
        }
        boolean useUniformHash = desc.getReducerTraits().contains((Object)ReduceSinkDesc.ReducerTraits.UNIFORM);
        if (!useUniformHash) {
            return false;
        }
        if (desc.getTopN() >= 0) {
            return false;
        }
        if (desc.getDistinctColumnIndices().size() > 0) {
            return false;
        }
        TableDesc keyTableDesc = desc.getKeySerializeInfo();
        Class<? extends Deserializer> keySerializerClass = keyTableDesc.getDeserializerClass();
        if (keySerializerClass != BinarySortableSerDe.class) {
            return false;
        }
        TableDesc valueTableDesc = desc.getValueSerializeInfo();
        Class<? extends Deserializer> valueDeserializerClass = valueTableDesc.getDeserializerClass();
        if (valueDeserializerClass != LazyBinarySerDe.class) {
            return false;
        }
        ArrayList<ExprNodeDesc> keysDescs = desc.getKeyCols();
        VectorExpression[] allKeyExpressions = vContext.getVectorExpressions(keysDescs);
        int[] reduceSinkKeyColumnMap = new int[allKeyExpressions.length];
        TypeInfo[] reduceSinkKeyTypeInfos = new TypeInfo[allKeyExpressions.length];
        ColumnVector.Type[] reduceSinkKeyColumnVectorTypes = new ColumnVector.Type[allKeyExpressions.length];
        ArrayList<VectorExpression> groupByKeyExpressionsList = new ArrayList<VectorExpression>();
        for (int i = 0; i < reduceSinkKeyColumnMap.length; ++i) {
            VectorExpression ve = allKeyExpressions[i];
            reduceSinkKeyColumnMap[i] = ve.getOutputColumn();
            reduceSinkKeyTypeInfos[i] = ((ExprNodeDesc)keysDescs.get(i)).getTypeInfo();
            reduceSinkKeyColumnVectorTypes[i] = VectorizationContext.getColumnVectorTypeFromTypeInfo(reduceSinkKeyTypeInfos[i]);
            if (IdentityExpression.isColumnOnly(ve)) continue;
            groupByKeyExpressionsList.add(ve);
        }
        VectorExpression[] reduceSinkKeyExpressions = groupByKeyExpressionsList.size() == 0 ? null : groupByKeyExpressionsList.toArray(new VectorExpression[0]);
        ArrayList<ExprNodeDesc> valueDescs = desc.getValueCols();
        VectorExpression[] allValueExpressions = vContext.getVectorExpressions(valueDescs);
        int[] reduceSinkValueColumnMap = new int[valueDescs.size()];
        TypeInfo[] reduceSinkValueTypeInfos = new TypeInfo[valueDescs.size()];
        ColumnVector.Type[] reduceSinkValueColumnVectorTypes = new ColumnVector.Type[valueDescs.size()];
        ArrayList<VectorExpression> reduceSinkValueExpressionsList = new ArrayList<VectorExpression>();
        for (int i = 0; i < valueDescs.size(); ++i) {
            VectorExpression ve = allValueExpressions[i];
            reduceSinkValueColumnMap[i] = ve.getOutputColumn();
            reduceSinkValueTypeInfos[i] = valueDescs.get(i).getTypeInfo();
            reduceSinkValueColumnVectorTypes[i] = VectorizationContext.getColumnVectorTypeFromTypeInfo(reduceSinkValueTypeInfos[i]);
            if (IdentityExpression.isColumnOnly(ve)) continue;
            reduceSinkValueExpressionsList.add(ve);
        }
        VectorExpression[] reduceSinkValueExpressions = reduceSinkValueExpressionsList.size() == 0 ? null : reduceSinkValueExpressionsList.toArray(new VectorExpression[0]);
        vectorReduceSinkInfo.setReduceSinkKeyColumnMap(reduceSinkKeyColumnMap);
        vectorReduceSinkInfo.setReduceSinkKeyTypeInfos(reduceSinkKeyTypeInfos);
        vectorReduceSinkInfo.setReduceSinkKeyColumnVectorTypes(reduceSinkKeyColumnVectorTypes);
        vectorReduceSinkInfo.setReduceSinkKeyExpressions(reduceSinkKeyExpressions);
        vectorReduceSinkInfo.setReduceSinkValueColumnMap(reduceSinkValueColumnMap);
        vectorReduceSinkInfo.setReduceSinkValueTypeInfos(reduceSinkValueTypeInfos);
        vectorReduceSinkInfo.setReduceSinkValueColumnVectorTypes(reduceSinkValueColumnVectorTypes);
        vectorReduceSinkInfo.setReduceSinkValueExpressions(reduceSinkValueExpressions);
        return true;
    }

    Operator<? extends OperatorDesc> vectorizeOperator(Operator<? extends OperatorDesc> op, VectorizationContext vContext, boolean isTez) throws HiveException {
        Operator<? extends OperatorDesc> vectorOp = null;
        switch (op.getType()) {
            case MAPJOIN: {
                MapJoinDesc desc = (MapJoinDesc)op.getConf();
                boolean specialize = this.canSpecializeMapJoin(op, desc, isTez || this.isSpark);
                if (!specialize) {
                    Class opClass = null;
                    if (op instanceof MapJoinOperator) {
                        boolean isOuterAndFiltered;
                        List<ExprNodeDesc> bigTableFilters = desc.getFilters().get((byte)desc.getPosBigTable());
                        boolean bl = isOuterAndFiltered = !desc.isNoOuterJoin() && bigTableFilters.size() > 0;
                        opClass = !isOuterAndFiltered ? VectorMapJoinOperator.class : VectorMapJoinOuterFilteredOperator.class;
                    } else if (op instanceof SMBMapJoinOperator) {
                        opClass = VectorSMBMapJoinOperator.class;
                    }
                    vectorOp = OperatorFactory.getVectorOperator(opClass, op.getCompilationOpContext(), op.getConf(), vContext);
                    break;
                }
                vectorOp = this.specializeMapJoinOperator(op, vContext, desc);
                break;
            }
            case REDUCESINK: {
                VectorReduceSinkInfo vectorReduceSinkInfo = new VectorReduceSinkInfo();
                ReduceSinkDesc desc = (ReduceSinkDesc)op.getConf();
                boolean specialize = this.canSpecializeReduceSink(desc, isTez, vContext, vectorReduceSinkInfo);
                if (!specialize) {
                    vectorOp = OperatorFactory.getVectorOperator(op.getCompilationOpContext(), op.getConf(), vContext);
                    break;
                }
                vectorOp = this.specializeReduceSinkOperator(op, vContext, desc, vectorReduceSinkInfo);
                break;
            }
            case GROUPBY: 
            case FILTER: 
            case SELECT: 
            case FILESINK: 
            case LIMIT: 
            case EVENT: 
            case HASHTABLESINK: 
            case EXTRACT: {
                vectorOp = OperatorFactory.getVectorOperator(op.getCompilationOpContext(), op.getConf(), vContext);
                break;
            }
            default: {
                vectorOp = op;
            }
        }
        LOG.debug("vectorizeOperator " + (vectorOp == null ? "NULL" : vectorOp.getClass().getName()));
        LOG.debug("vectorizeOperator " + (vectorOp == null || vectorOp.getConf() == null ? "NULL" : vectorOp.getConf().getClass().getName()));
        if (vectorOp != op) {
            this.fixupParentChildOperators(op, vectorOp);
            ((AbstractOperatorDesc)vectorOp.getConf()).setVectorMode(true);
        }
        return vectorOp;
    }

    private boolean isVirtualColumn(ColumnInfo column) {
        return VirtualColumn.VIRTUAL_COLUMN_NAMES.contains(column.getInternalName());
    }

    public void debugDisplayAllMaps(BaseWork work) {
        VectorizedRowBatchCtx vectorizedRowBatchCtx = work.getVectorizedRowBatchCtx();
        Object[] columnNames = vectorizedRowBatchCtx.getRowColumnNames();
        TypeInfo[] columnTypeInfos = vectorizedRowBatchCtx.getRowColumnTypeInfos();
        int partitionColumnCount = vectorizedRowBatchCtx.getPartitionColumnCount();
        Object[] scratchColumnTypeNames = vectorizedRowBatchCtx.getScratchColumnTypeNames();
        LOG.debug("debugDisplayAllMaps columnNames " + Arrays.toString(columnNames));
        LOG.debug("debugDisplayAllMaps columnTypeInfos " + Arrays.deepToString(columnTypeInfos));
        LOG.debug("debugDisplayAllMaps partitionColumnCount " + partitionColumnCount);
        LOG.debug("debugDisplayAllMaps scratchColumnTypeNames " + Arrays.toString(scratchColumnTypeNames));
    }

    static {
        StringBuilder patternBuilder = new StringBuilder();
        patternBuilder.append("int");
        patternBuilder.append("|smallint");
        patternBuilder.append("|tinyint");
        patternBuilder.append("|bigint");
        patternBuilder.append("|integer");
        patternBuilder.append("|long");
        patternBuilder.append("|short");
        patternBuilder.append("|timestamp");
        patternBuilder.append("|interval_year_month");
        patternBuilder.append("|interval_day_time");
        patternBuilder.append("|boolean");
        patternBuilder.append("|binary");
        patternBuilder.append("|string");
        patternBuilder.append("|byte");
        patternBuilder.append("|float");
        patternBuilder.append("|double");
        patternBuilder.append("|date");
        patternBuilder.append("|void");
        patternBuilder.append("|decimal.*");
        patternBuilder.append("|char.*");
        patternBuilder.append("|varchar.*");
        supportedDataTypesPattern = Pattern.compile(patternBuilder.toString());
    }

    private static class ValidatorVectorizationContext
    extends VectorizationContext {
        private ValidatorVectorizationContext(HiveConf hiveConf) {
            super("No Name", hiveConf);
        }

        @Override
        protected int getInputColumnIndex(String name) {
            return 0;
        }

        @Override
        protected int getInputColumnIndex(ExprNodeColumnDesc colExpr) {
            return 0;
        }
    }

    class ReduceWorkVectorizationNodeProcessor
    extends VectorizationNodeProcessor {
        private final VectorTaskColumnInfo vectorTaskColumnInfo;
        private final boolean isTez;
        private Operator<? extends OperatorDesc> rootVectorOp;

        public Operator<? extends OperatorDesc> getRootVectorOp() {
            return this.rootVectorOp;
        }

        public ReduceWorkVectorizationNodeProcessor(VectorTaskColumnInfo vectorTaskColumnInfo, boolean isTez) {
            super(vectorTaskColumnInfo.getNonVectorizedOps());
            this.vectorTaskColumnInfo = vectorTaskColumnInfo;
            this.rootVectorOp = null;
            this.isTez = isTez;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Operator op = (Operator)nd;
            if (this.nonVectorizedOps.contains(op)) {
                return null;
            }
            VectorizationContext vContext = null;
            boolean saveRootVectorOp = false;
            if (op.getParentOperators().size() == 0) {
                LOG.info("ReduceWorkVectorizationNodeProcessor process reduceColumnNames " + this.vectorTaskColumnInfo.columnNames.toString());
                this.taskVectorizationContext = vContext = new VectorizationContext("__Reduce_Shuffle__", this.vectorTaskColumnInfo.columnNames, Vectorizer.this.hiveConf);
                saveRootVectorOp = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Vectorized ReduceWork reduce shuffle vectorization context " + vContext.toString());
                }
            } else {
                LOG.info("ReduceWorkVectorizationNodeProcessor process going to walk the operator stack to get vectorization context for " + op.getName());
                vContext = this.walkStackToFindVectorizationContext(stack, op);
                if (vContext == null) {
                    vContext = this.taskVectorizationContext;
                }
            }
            assert (vContext != null);
            LOG.info("ReduceWorkVectorizationNodeProcessor process operator " + op.getName() + " using vectorization context" + vContext.toString());
            Operator<? extends OperatorDesc> vectorOp = this.doVectorize(op, vContext, this.isTez);
            if (LOG.isDebugEnabled() && vectorOp instanceof VectorizationContextRegion) {
                VectorizationContextRegion vcRegion = (VectorizationContextRegion)((Object)vectorOp);
                VectorizationContext vNewContext = vcRegion.getOuputVectorizationContext();
                LOG.debug("Vectorized ReduceWork operator " + vectorOp.getName() + " added vectorization context " + vNewContext.toString());
            }
            if (saveRootVectorOp && op != vectorOp) {
                this.rootVectorOp = vectorOp;
            }
            return null;
        }
    }

    class MapWorkVectorizationNodeProcessor
    extends VectorizationNodeProcessor {
        private final MapWork mWork;
        private final VectorTaskColumnInfo vectorTaskColumnInfo;
        private final boolean isTez;

        public MapWorkVectorizationNodeProcessor(MapWork mWork, boolean isTez, VectorTaskColumnInfo vectorTaskColumnInfo) {
            super(vectorTaskColumnInfo.getNonVectorizedOps());
            this.mWork = mWork;
            this.vectorTaskColumnInfo = vectorTaskColumnInfo;
            this.isTez = isTez;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Operator op = (Operator)nd;
            if (this.nonVectorizedOps.contains(op)) {
                return null;
            }
            VectorizationContext vContext = null;
            if (op instanceof TableScanOperator) {
                if (this.taskVectorizationContext == null) {
                    this.taskVectorizationContext = Vectorizer.this.getVectorizationContext(op.getName(), this.vectorTaskColumnInfo);
                }
                vContext = this.taskVectorizationContext;
            } else {
                LOG.debug("MapWorkVectorizationNodeProcessor process going to walk the operator stack to get vectorization context for " + op.getName());
                vContext = this.walkStackToFindVectorizationContext(stack, op);
                if (vContext == null) {
                    vContext = this.taskVectorizationContext;
                }
            }
            assert (vContext != null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("MapWorkVectorizationNodeProcessor process operator " + op.getName() + " using vectorization context" + vContext.toString());
            }
            Operator<? extends OperatorDesc> vectorOp = this.doVectorize(op, vContext, this.isTez);
            if (LOG.isDebugEnabled() && vectorOp instanceof VectorizationContextRegion) {
                VectorizationContextRegion vcRegion = (VectorizationContextRegion)((Object)vectorOp);
                VectorizationContext vNewContext = vcRegion.getOuputVectorizationContext();
                LOG.debug("Vectorized MapWork operator " + vectorOp.getName() + " added vectorization context " + vNewContext.toString());
            }
            return null;
        }
    }

    class VectorizationNodeProcessor
    implements NodeProcessor {
        protected VectorizationContext taskVectorizationContext;
        protected final Set<Operator<? extends OperatorDesc>> nonVectorizedOps;
        protected final Set<Operator<? extends OperatorDesc>> opsDone = new HashSet<Operator<? extends OperatorDesc>>();
        protected final Map<Operator<? extends OperatorDesc>, Operator<? extends OperatorDesc>> opToVectorOpMap = new HashMap<Operator<? extends OperatorDesc>, Operator<? extends OperatorDesc>>();

        VectorizationNodeProcessor(Set<Operator<? extends OperatorDesc>> nonVectorizedOps) {
            this.nonVectorizedOps = nonVectorizedOps;
        }

        public String[] getVectorScratchColumnTypeNames() {
            return this.taskVectorizationContext.getScratchColumnTypeNames();
        }

        public VectorizationContext walkStackToFindVectorizationContext(Stack<Node> stack, Operator<? extends OperatorDesc> op) throws SemanticException {
            VectorizationContext vContext = null;
            if (stack.size() <= 1) {
                throw new SemanticException(String.format("Expected operator stack for operator %s to have at least 2 operators", op.getName()));
            }
            int i = stack.size() - 2;
            while (vContext == null) {
                if (i < 0) {
                    return null;
                }
                Operator opParent = (Operator)stack.get(i);
                Operator<? extends OperatorDesc> vectorOpParent = this.opToVectorOpMap.get(opParent);
                if (vectorOpParent != null) {
                    if (vectorOpParent instanceof VectorizationContextRegion) {
                        VectorizationContextRegion vcRegion = (VectorizationContextRegion)((Object)vectorOpParent);
                        vContext = vcRegion.getOuputVectorizationContext();
                        LOG.info("walkStackToFindVectorizationContext " + vectorOpParent.getName() + " has new vectorization context " + vContext.toString());
                    } else {
                        LOG.info("walkStackToFindVectorizationContext " + vectorOpParent.getName() + " does not have new vectorization context");
                    }
                } else {
                    LOG.info("walkStackToFindVectorizationContext " + opParent.getName() + " is not vectorized");
                }
                --i;
            }
            return vContext;
        }

        public Operator<? extends OperatorDesc> doVectorize(Operator<? extends OperatorDesc> op, VectorizationContext vContext, boolean isTez) throws SemanticException {
            Operator<? extends OperatorDesc> vectorOp = op;
            try {
                if (!this.opsDone.contains(op)) {
                    vectorOp = Vectorizer.this.vectorizeOperator(op, vContext, isTez);
                    this.opsDone.add(op);
                    if (vectorOp != op) {
                        this.opToVectorOpMap.put(op, vectorOp);
                        this.opsDone.add(vectorOp);
                    }
                }
            }
            catch (HiveException e) {
                throw new SemanticException(e);
            }
            return vectorOp;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            throw new SemanticException("Must be overridden");
        }
    }

    class ReduceWorkValidationNodeProcessor
    implements NodeProcessor {
        protected final Set<Operator<? extends OperatorDesc>> nonVectorizedOps = new HashSet<Operator<? extends OperatorDesc>>();

        ReduceWorkValidationNodeProcessor() {
        }

        public Set<Operator<? extends OperatorDesc>> getNonVectorizeOps() {
            return this.nonVectorizedOps;
        }

        public Set<Operator<? extends OperatorDesc>> getNonVectorizedOps() {
            return this.nonVectorizedOps;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            for (Node n : stack) {
                Operator op = (Operator)n;
                if (this.nonVectorizedOps.contains(op)) {
                    return new Boolean(true);
                }
                boolean ret = Vectorizer.this.validateReduceWorkOperator(op);
                if (!ret) {
                    LOG.info("ReduceWork Operator: " + op.getName() + " could not be vectorized.");
                    return new Boolean(false);
                }
                if (!Vectorizer.this.isVectorizedGroupByThatOutputsRows(op).booleanValue()) continue;
                Vectorizer.this.addOperatorChildrenToSet(op, this.nonVectorizedOps);
                return new Boolean(true);
            }
            return new Boolean(true);
        }
    }

    class MapWorkValidationNodeProcessor
    implements NodeProcessor {
        private final MapWork mapWork;
        private final boolean isTez;
        protected final Set<Operator<? extends OperatorDesc>> nonVectorizedOps = new HashSet<Operator<? extends OperatorDesc>>();

        public Set<Operator<? extends OperatorDesc>> getNonVectorizedOps() {
            return this.nonVectorizedOps;
        }

        public MapWorkValidationNodeProcessor(MapWork mapWork, boolean isTez) {
            this.mapWork = mapWork;
            this.isTez = isTez;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            for (Node n : stack) {
                boolean ret;
                Operator op = (Operator)n;
                if (this.nonVectorizedOps.contains(op)) {
                    return new Boolean(true);
                }
                try {
                    ret = Vectorizer.this.validateMapWorkOperator(op, this.mapWork, this.isTez);
                }
                catch (Exception e) {
                    throw new SemanticException(e);
                }
                if (!ret) {
                    LOG.info("MapWork Operator: " + op.getName() + " could not be vectorized.");
                    return new Boolean(false);
                }
                if (!Vectorizer.this.isVectorizedGroupByThatOutputsRows(op).booleanValue()) continue;
                Vectorizer.this.addOperatorChildrenToSet(op, this.nonVectorizedOps);
                return new Boolean(true);
            }
            return new Boolean(true);
        }
    }

    class VectorizationDispatcher
    implements Dispatcher {
        private final PhysicalContext physicalContext;

        public VectorizationDispatcher(PhysicalContext physicalContext) {
            this.physicalContext = physicalContext;
        }

        @Override
        public Object dispatch(Node nd, Stack<Node> stack, Object ... nodeOutputs) throws SemanticException {
            block5: {
                Task currTask;
                block6: {
                    block4: {
                        currTask = (Task)nd;
                        if (!(currTask instanceof MapRedTask)) break block4;
                        this.convertMapWork(((MapredWork)((MapRedTask)currTask).getWork()).getMapWork(), false);
                        break block5;
                    }
                    if (!(currTask instanceof TezTask)) break block6;
                    TezWork work = (TezWork)((TezTask)currTask).getWork();
                    for (BaseWork w : work.getAllWork()) {
                        if (w instanceof MapWork) {
                            this.convertMapWork((MapWork)w, true);
                            continue;
                        }
                        if (!(w instanceof ReduceWork) || !HiveConf.getBoolVar(Vectorizer.this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_REDUCE_ENABLED)) continue;
                        this.convertReduceWork((ReduceWork)w, true);
                    }
                    break block5;
                }
                if (!(currTask instanceof SparkTask)) break block5;
                SparkWork sparkWork = (SparkWork)currTask.getWork();
                for (BaseWork baseWork : sparkWork.getAllWork()) {
                    if (baseWork instanceof MapWork) {
                        this.convertMapWork((MapWork)baseWork, false);
                        continue;
                    }
                    if (!(baseWork instanceof ReduceWork) || !HiveConf.getBoolVar(Vectorizer.this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_REDUCE_ENABLED)) continue;
                    this.convertReduceWork((ReduceWork)baseWork, false);
                }
            }
            return null;
        }

        private void convertMapWork(MapWork mapWork, boolean isTez) throws SemanticException {
            VectorTaskColumnInfo vectorTaskColumnInfo = new VectorTaskColumnInfo();
            boolean ret = this.validateMapWork(mapWork, vectorTaskColumnInfo, isTez);
            if (ret) {
                this.vectorizeMapWork(mapWork, vectorTaskColumnInfo, isTez);
            }
        }

        private void addMapWorkRules(Map<Rule, NodeProcessor> opRules, NodeProcessor np) {
            opRules.put(new RuleRegExp("R1", TableScanOperator.getOperatorName() + ".*" + FileSinkOperator.getOperatorName()), np);
            opRules.put(new RuleRegExp("R2", TableScanOperator.getOperatorName() + ".*" + ReduceSinkOperator.getOperatorName()), np);
        }

        private ImmutablePair<String, TableScanOperator> verifyOnlyOneTableScanOperator(MapWork mapWork) {
            LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork = mapWork.getAliasToWork();
            if (aliasToWork == null || aliasToWork.size() == 0) {
                return null;
            }
            int tableScanCount = 0;
            String alias = "";
            TableScanOperator tableScanOperator = null;
            for (Map.Entry<String, Operator<? extends OperatorDesc>> entry : aliasToWork.entrySet()) {
                Operator<? extends OperatorDesc> op = entry.getValue();
                if (op == null) {
                    LOG.warn("Map work has invalid aliases to work with. Fail validation!");
                    return null;
                }
                if (!(op instanceof TableScanOperator)) continue;
                ++tableScanCount;
                alias = entry.getKey();
                tableScanOperator = (TableScanOperator)op;
            }
            if (tableScanCount > 1) {
                LOG.warn("Map work has more than 1 TableScanOperator. Fail validation!");
                return null;
            }
            return new ImmutablePair<String, Object>(alias, tableScanOperator);
        }

        private void getTableScanOperatorSchemaInfo(TableScanOperator tableScanOperator, List<String> logicalColumnNameList, List<TypeInfo> logicalTypeInfoList) {
            RowSchema rowSchema = tableScanOperator.getSchema();
            for (ColumnInfo c : rowSchema.getSignature()) {
                if (Vectorizer.this.isVirtualColumn(c)) continue;
                String columnName = c.getInternalName();
                String typeName = c.getTypeName();
                TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString(typeName);
                logicalColumnNameList.add(columnName);
                logicalTypeInfoList.add(typeInfo);
            }
        }

        private String getHiveOptionsString() {
            StringBuilder sb = new StringBuilder();
            sb.append(HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTORIZED_INPUT_FILE_FORMAT.varname);
            sb.append("=");
            sb.append(Vectorizer.this.useVectorizedInputFileFormat);
            sb.append(", ");
            sb.append(HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTOR_DESERIALIZE.varname);
            sb.append("=");
            sb.append(Vectorizer.this.useVectorDeserialize);
            sb.append(", and ");
            sb.append(HiveConf.ConfVars.HIVE_VECTORIZATION_USE_ROW_DESERIALIZE.varname);
            sb.append("=");
            sb.append(Vectorizer.this.useRowDeserialize);
            return sb.toString();
        }

        private boolean verifyAndSetVectorPartDesc(PartitionDesc pd, boolean isAcidTable) {
            String inputFileFormatClassName = pd.getInputFileFormatClassName();
            if (isAcidTable || Vectorizer.this.useVectorizedInputFileFormat) {
                if (Utilities.isInputFileFormatVectorized(pd)) {
                    if (!Vectorizer.this.useVectorizedInputFileFormat) {
                        LOG.info("ACID tables con only be vectorized for the input file format -- i.e. when Hive Configuration option " + HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTORIZED_INPUT_FILE_FORMAT.varname + "=true");
                        return false;
                    }
                    pd.setVectorPartitionDesc(VectorPartitionDesc.createVectorizedInputFileFormat(inputFileFormatClassName, Utilities.isInputFileFormatSelfDescribing(pd)));
                    return true;
                }
                Preconditions.checkState(!isAcidTable);
            }
            if (!Vectorizer.this.isSchemaEvolution && !isAcidTable && (Vectorizer.this.useVectorDeserialize || Vectorizer.this.useRowDeserialize)) {
                LOG.info("Input format: " + inputFileFormatClassName + " cannot be vectorized when both " + HiveConf.ConfVars.HIVE_SCHEMA_EVOLUTION.varname + "=false and  ACID table is " + isAcidTable + " and  given the Hive Configuration options " + this.getHiveOptionsString());
                return false;
            }
            String deserializerClassName = pd.getDeserializerClassName();
            if (Vectorizer.this.useVectorDeserialize) {
                if (inputFileFormatClassName.equals(TextInputFormat.class.getName()) && deserializerClassName.equals(LazySimpleSerDe.class.getName())) {
                    pd.setVectorPartitionDesc(VectorPartitionDesc.createVectorDeserialize(inputFileFormatClassName, VectorPartitionDesc.VectorDeserializeType.LAZY_SIMPLE));
                    return true;
                }
                if (inputFileFormatClassName.equals(SequenceFileInputFormat.class.getName()) && deserializerClassName.equals(LazyBinarySerDe.class.getName())) {
                    pd.setVectorPartitionDesc(VectorPartitionDesc.createVectorDeserialize(inputFileFormatClassName, VectorPartitionDesc.VectorDeserializeType.LAZY_BINARY));
                    return true;
                }
            }
            if (Vectorizer.this.useRowDeserialize) {
                pd.setVectorPartitionDesc(VectorPartitionDesc.createRowDeserialize(inputFileFormatClassName, Utilities.isInputFileFormatSelfDescribing(pd), deserializerClassName));
                return true;
            }
            LOG.info("Input format: " + inputFileFormatClassName + " cannot be vectorized given the Hive Configuration options " + this.getHiveOptionsString());
            return false;
        }

        private boolean validateInputFormatAndSchemaEvolution(MapWork mapWork, String alias, TableScanOperator tableScanOperator, VectorTaskColumnInfo vectorTaskColumnInfo) throws SemanticException {
            boolean isAcidTable = ((TableScanDesc)tableScanOperator.getConf()).isAcidTable();
            ArrayList<String> allColumnNameList = new ArrayList<String>();
            ArrayList<TypeInfo> allTypeInfoList = new ArrayList<TypeInfo>();
            this.getTableScanOperatorSchemaInfo(tableScanOperator, allColumnNameList, allTypeInfoList);
            int allColumnCount = allColumnNameList.size();
            boolean isFirst = true;
            int dataColumnCount = 0;
            int partitionColumnCount = 0;
            List tableDataColumnList = null;
            List<TypeInfo> tableDataTypeInfoList = null;
            LinkedHashMap<String, ArrayList<String>> pathToAliases = mapWork.getPathToAliases();
            LinkedHashMap<String, PartitionDesc> pathToPartitionInfo = mapWork.getPathToPartitionInfo();
            for (Map.Entry<String, ArrayList<String>> entry : pathToAliases.entrySet()) {
                List<TypeInfo> nextDataTypeInfoList;
                StructObjectInspector partObjectInspector;
                Deserializer deserializer;
                boolean isPresent;
                String path = entry.getKey();
                List aliases = entry.getValue();
                boolean bl = isPresent = aliases != null && aliases.indexOf(alias) != -1;
                if (!isPresent) {
                    LOG.info("Alias " + alias + " not present in aliases " + aliases);
                    return false;
                }
                PartitionDesc partDesc = pathToPartitionInfo.get(path);
                if (partDesc.getVectorPartitionDesc() != null) continue;
                if (!this.verifyAndSetVectorPartDesc(partDesc, isAcidTable)) {
                    return false;
                }
                VectorPartitionDesc vectorPartDesc = partDesc.getVectorPartitionDesc();
                if (LOG.isInfoEnabled()) {
                    LOG.info("Vectorizer path: " + path + ", " + vectorPartDesc.toString() + ", aliases " + aliases);
                }
                if (isFirst) {
                    LinkedHashMap<String, String> partSpec = partDesc.getPartSpec();
                    if (partSpec != null && partSpec.size() > 0) {
                        partitionColumnCount = partSpec.size();
                        dataColumnCount = allColumnCount - partitionColumnCount;
                    } else {
                        partitionColumnCount = 0;
                        dataColumnCount = allColumnCount;
                    }
                    tableDataColumnList = allColumnNameList.subList(0, dataColumnCount);
                    tableDataTypeInfoList = allTypeInfoList.subList(0, dataColumnCount);
                    isFirst = false;
                }
                try {
                    deserializer = partDesc.getDeserializer(Vectorizer.this.hiveConf);
                    partObjectInspector = (StructObjectInspector)deserializer.getObjectInspector();
                }
                catch (Exception e) {
                    throw new SemanticException(e);
                }
                String nextDataColumnsString = ObjectInspectorUtils.getFieldNames(partObjectInspector);
                String[] nextDataColumns = nextDataColumnsString.split(",");
                List<String> nextDataColumnList = Arrays.asList(nextDataColumns);
                if (nextDataColumnList.size() > tableDataColumnList.size()) {
                    LOG.info(String.format("Could not vectorize partition %s (deserializer " + deserializer.getClass().getName() + ")The partition column names %d is greater than the number of table columns %d", path, nextDataColumnList.size(), tableDataColumnList.size()));
                    return false;
                }
                if (!(deserializer instanceof NullStructSerDe)) {
                    for (int i = 0; i < nextDataColumnList.size(); ++i) {
                        String tableColumnName;
                        String nextColumnName = nextDataColumnList.get(i);
                        if (nextColumnName.equals(tableColumnName = (String)tableDataColumnList.get(i))) continue;
                        LOG.info(String.format("Could not vectorize partition %s (deserializer " + deserializer.getClass().getName() + ")The partition column name %s is does not match table column name %s", path, nextColumnName, tableColumnName));
                        return false;
                    }
                }
                if (vectorPartDesc.getIsInputFileFormatSelfDescribing()) {
                    nextDataTypeInfoList = tableDataTypeInfoList;
                } else {
                    String nextDataTypesString = ObjectInspectorUtils.getFieldTypes(partObjectInspector);
                    nextDataTypeInfoList = TypeInfoUtils.getTypeInfosFromTypeString(nextDataTypesString);
                }
                vectorPartDesc.setDataTypeInfos(nextDataTypeInfoList);
            }
            vectorTaskColumnInfo.setColumnNames(allColumnNameList);
            vectorTaskColumnInfo.setTypeInfos(allTypeInfoList);
            vectorTaskColumnInfo.setPartitionColumnCount(partitionColumnCount);
            vectorTaskColumnInfo.setUseVectorizedInputFileFormat(Vectorizer.this.useVectorizedInputFileFormat);
            return true;
        }

        private boolean validateMapWork(MapWork mapWork, VectorTaskColumnInfo vectorTaskColumnInfo, boolean isTez) throws SemanticException {
            LOG.info("Validating MapWork...");
            ImmutablePair<String, TableScanOperator> pair = this.verifyOnlyOneTableScanOperator(mapWork);
            if (pair == null) {
                return false;
            }
            String alias = (String)pair.left;
            TableScanOperator tableScanOperator = (TableScanOperator)pair.right;
            if (!this.validateInputFormatAndSchemaEvolution(mapWork, alias, tableScanOperator, vectorTaskColumnInfo)) {
                return false;
            }
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            MapWorkValidationNodeProcessor vnp = new MapWorkValidationNodeProcessor(mapWork, isTez);
            this.addMapWorkRules(opRules, vnp);
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(vnp, opRules, null);
            DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.addAll(mapWork.getAliasToWork().values());
            HashMap<Node, Object> nodeOutput = new HashMap<Node, Object>();
            ogw.startWalking(topNodes, nodeOutput);
            for (Node n : nodeOutput.keySet()) {
                if (nodeOutput.get(n) == null || ((Boolean)nodeOutput.get(n)).booleanValue()) continue;
                return false;
            }
            vectorTaskColumnInfo.setNonVectorizedOps(vnp.getNonVectorizedOps());
            return true;
        }

        private void vectorizeMapWork(MapWork mapWork, VectorTaskColumnInfo vectorTaskColumnInfo, boolean isTez) throws SemanticException {
            LOG.info("Vectorizing MapWork...");
            mapWork.setVectorMode(true);
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            MapWorkVectorizationNodeProcessor vnp = new MapWorkVectorizationNodeProcessor(mapWork, isTez, vectorTaskColumnInfo);
            this.addMapWorkRules(opRules, vnp);
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(vnp, opRules, null);
            PreOrderOnceWalker ogw = new PreOrderOnceWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.addAll(mapWork.getAliasToWork().values());
            HashMap<Node, Object> nodeOutput = new HashMap<Node, Object>();
            ogw.startWalking(topNodes, nodeOutput);
            vectorTaskColumnInfo.setScratchTypeNameArray(vnp.getVectorScratchColumnTypeNames());
            vectorTaskColumnInfo.transferToBaseWork(mapWork);
            if (LOG.isDebugEnabled()) {
                Vectorizer.this.debugDisplayAllMaps(mapWork);
            }
        }

        private void convertReduceWork(ReduceWork reduceWork, boolean isTez) throws SemanticException {
            VectorTaskColumnInfo vectorTaskColumnInfo = new VectorTaskColumnInfo();
            boolean ret = this.validateReduceWork(reduceWork, vectorTaskColumnInfo, isTez);
            if (ret) {
                this.vectorizeReduceWork(reduceWork, vectorTaskColumnInfo, isTez);
            }
        }

        private boolean getOnlyStructObjectInspectors(ReduceWork reduceWork, VectorTaskColumnInfo vectorTaskColumnInfo) throws SemanticException {
            ArrayList<String> reduceColumnNames = new ArrayList<String>();
            ArrayList<TypeInfo> reduceTypeInfos = new ArrayList<TypeInfo>();
            try {
                ObjectInspector keyObjectInspector = reduceWork.getKeyObjectInspector();
                if (keyObjectInspector == null || !(keyObjectInspector instanceof StructObjectInspector)) {
                    return false;
                }
                StructObjectInspector keyStructObjectInspector = (StructObjectInspector)keyObjectInspector;
                List<? extends StructField> keyFields = keyStructObjectInspector.getAllStructFieldRefs();
                if (reduceWork.getNeedsTagging()) {
                    return false;
                }
                ObjectInspector valueObjectInspector = reduceWork.getValueObjectInspector();
                if (valueObjectInspector == null || !(valueObjectInspector instanceof StructObjectInspector)) {
                    return false;
                }
                StructObjectInspector valueStructObjectInspector = (StructObjectInspector)valueObjectInspector;
                List<? extends StructField> valueFields = valueStructObjectInspector.getAllStructFieldRefs();
                for (StructField structField : keyFields) {
                    reduceColumnNames.add(Utilities.ReduceField.KEY.toString() + "." + structField.getFieldName());
                    reduceTypeInfos.add(TypeInfoUtils.getTypeInfoFromTypeString(structField.getFieldObjectInspector().getTypeName()));
                }
                for (StructField structField : valueFields) {
                    reduceColumnNames.add(Utilities.ReduceField.VALUE.toString() + "." + structField.getFieldName());
                    reduceTypeInfos.add(TypeInfoUtils.getTypeInfoFromTypeString(structField.getFieldObjectInspector().getTypeName()));
                }
            }
            catch (Exception e) {
                throw new SemanticException(e);
            }
            vectorTaskColumnInfo.setColumnNames(reduceColumnNames);
            vectorTaskColumnInfo.setTypeInfos(reduceTypeInfos);
            return true;
        }

        private void addReduceWorkRules(Map<Rule, NodeProcessor> opRules, NodeProcessor np) {
            opRules.put(new RuleRegExp("R1", GroupByOperator.getOperatorName() + ".*"), np);
            opRules.put(new RuleRegExp("R2", SelectOperator.getOperatorName() + ".*"), np);
        }

        private boolean validateReduceWork(ReduceWork reduceWork, VectorTaskColumnInfo vectorTaskColumnInfo, boolean isTez) throws SemanticException {
            LOG.info("Validating ReduceWork...");
            if (!this.getOnlyStructObjectInspectors(reduceWork, vectorTaskColumnInfo)) {
                return false;
            }
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            ReduceWorkValidationNodeProcessor vnp = new ReduceWorkValidationNodeProcessor();
            this.addReduceWorkRules(opRules, vnp);
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(vnp, opRules, null);
            DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.add(reduceWork.getReducer());
            HashMap<Node, Object> nodeOutput = new HashMap<Node, Object>();
            ogw.startWalking(topNodes, nodeOutput);
            for (Node n : nodeOutput.keySet()) {
                if (nodeOutput.get(n) == null || ((Boolean)nodeOutput.get(n)).booleanValue()) continue;
                return false;
            }
            vectorTaskColumnInfo.setNonVectorizedOps(vnp.getNonVectorizedOps());
            return true;
        }

        private void vectorizeReduceWork(ReduceWork reduceWork, VectorTaskColumnInfo vectorTaskColumnInfo, boolean isTez) throws SemanticException {
            LOG.info("Vectorizing ReduceWork...");
            reduceWork.setVectorMode(true);
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            ReduceWorkVectorizationNodeProcessor vnp = new ReduceWorkVectorizationNodeProcessor(vectorTaskColumnInfo, isTez);
            this.addReduceWorkRules(opRules, vnp);
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(vnp, opRules, null);
            PreOrderWalker ogw = new PreOrderWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.add(reduceWork.getReducer());
            LOG.info("vectorizeReduceWork reducer Operator: " + reduceWork.getReducer().getName() + "...");
            HashMap<Node, Object> nodeOutput = new HashMap<Node, Object>();
            ogw.startWalking(topNodes, nodeOutput);
            reduceWork.setReducer(vnp.getRootVectorOp());
            vectorTaskColumnInfo.setScratchTypeNameArray(vnp.getVectorScratchColumnTypeNames());
            vectorTaskColumnInfo.transferToBaseWork(reduceWork);
            if (LOG.isDebugEnabled()) {
                Vectorizer.this.debugDisplayAllMaps(reduceWork);
            }
        }
    }

    private class VectorTaskColumnInfo {
        List<String> columnNames;
        List<TypeInfo> typeInfos;
        int partitionColumnCount = 0;
        boolean useVectorizedInputFileFormat;
        String[] scratchTypeNameArray;
        Set<Operator<? extends OperatorDesc>> nonVectorizedOps;

        VectorTaskColumnInfo() {
        }

        public void setColumnNames(List<String> columnNames) {
            this.columnNames = columnNames;
        }

        public void setTypeInfos(List<TypeInfo> typeInfos) {
            this.typeInfos = typeInfos;
        }

        public void setPartitionColumnCount(int partitionColumnCount) {
            this.partitionColumnCount = partitionColumnCount;
        }

        public void setScratchTypeNameArray(String[] scratchTypeNameArray) {
            this.scratchTypeNameArray = scratchTypeNameArray;
        }

        public void setUseVectorizedInputFileFormat(boolean useVectorizedInputFileFormat) {
            this.useVectorizedInputFileFormat = useVectorizedInputFileFormat;
        }

        public void setNonVectorizedOps(Set<Operator<? extends OperatorDesc>> nonVectorizedOps) {
            this.nonVectorizedOps = nonVectorizedOps;
        }

        public Set<Operator<? extends OperatorDesc>> getNonVectorizedOps() {
            return this.nonVectorizedOps;
        }

        public void transferToBaseWork(BaseWork baseWork) {
            String[] columnNameArray = this.columnNames.toArray(new String[0]);
            TypeInfo[] typeInfoArray = this.typeInfos.toArray(new TypeInfo[0]);
            VectorizedRowBatchCtx vectorizedRowBatchCtx = new VectorizedRowBatchCtx(columnNameArray, typeInfoArray, this.partitionColumnCount, this.scratchTypeNameArray);
            baseWork.setVectorizedRowBatchCtx(vectorizedRowBatchCtx);
            baseWork.setUseVectorizedInputFileFormat(this.useVectorizedInputFileFormat);
        }
    }
}

