/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.security.SecureRandom;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.jetty.SessionIdManager;
import org.mortbay.jetty.servlet.AbstractSessionManager;
import org.mortbay.log.Log;
import org.mortbay.util.MultiMap;

public class HashSessionIdManager
extends AbstractLifeCycle
implements SessionIdManager {
    private static final String __NEW_SESSION_ID = "org.mortbay.jetty.newSessionId";
    MultiMap _sessions;
    protected Random _random;
    private boolean _weakRandom;
    private String _workerName;

    public HashSessionIdManager() {
    }

    public HashSessionIdManager(Random random) {
        this._random = random;
    }

    public String getWorkerName() {
        return this._workerName;
    }

    public void setWorkerName(String workerName) {
        this._workerName = workerName;
    }

    public String getNodeId(String clusterId, HttpServletRequest request) {
        String worker;
        String string = worker = request == null ? null : (String)request.getAttribute("org.mortbay.http.ajp.JVMRoute");
        if (worker != null) {
            return clusterId + '.' + worker;
        }
        if (this._workerName != null) {
            return clusterId + '.' + this._workerName;
        }
        return clusterId;
    }

    public String getClusterId(String nodeId) {
        int dot = nodeId.lastIndexOf(46);
        return dot > 0 ? nodeId.substring(0, dot) : nodeId;
    }

    protected void doStart() {
        if (this._random == null) {
            try {
                Log.debug((String)"Init SecureRandom.");
                this._random = new SecureRandom();
            }
            catch (Exception e) {
                Log.warn((String)"Could not generate SecureRandom for session-id randomness", (Throwable)e);
                this._random = new Random();
                this._weakRandom = true;
            }
        }
        this._sessions = new MultiMap();
    }

    protected void doStop() {
        if (this._sessions != null) {
            this._sessions.clear();
        }
        this._sessions = null;
    }

    public boolean idInUse(String id) {
        return this._sessions.containsKey((Object)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(HttpSession session) {
        HashSessionIdManager hashSessionIdManager = this;
        synchronized (hashSessionIdManager) {
            this._sessions.add((Object)this.getClusterId(session.getId()), (Object)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(HttpSession session) {
        HashSessionIdManager hashSessionIdManager = this;
        synchronized (hashSessionIdManager) {
            this._sessions.removeValue((Object)this.getClusterId(session.getId()), (Object)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAll(String id) {
        while (true) {
            AbstractSessionManager.Session session = null;
            HashSessionIdManager hashSessionIdManager = this;
            synchronized (hashSessionIdManager) {
                if (!this._sessions.containsKey((Object)id)) {
                    return;
                }
                session = (AbstractSessionManager.Session)this._sessions.getValue((Object)id, 0);
                this._sessions.removeValue((Object)id, (Object)session);
            }
            if (!session.isValid()) continue;
            session.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String newSessionId(HttpServletRequest request, long created) {
        HashSessionIdManager hashSessionIdManager = this;
        synchronized (hashSessionIdManager) {
            String cluster_id;
            String requested_id = request.getRequestedSessionId();
            if (requested_id != null && this.idInUse(cluster_id = this.getClusterId(requested_id))) {
                return cluster_id;
            }
            String new_id = (String)request.getAttribute(__NEW_SESSION_ID);
            if (new_id != null && this.idInUse(new_id)) {
                return new_id;
            }
            String id = null;
            while (id == null || id.length() == 0 || this.idInUse(id)) {
                long r0 = this._weakRandom ? (long)this.hashCode() ^ Runtime.getRuntime().freeMemory() ^ (long)this._random.nextInt() ^ (long)request.hashCode() << 32 : this._random.nextLong();
                long r1 = this._random.nextLong();
                if (r0 < 0L) {
                    r0 = -r0;
                }
                if (r1 < 0L) {
                    r1 = -r1;
                }
                id = Long.toString(r0, 36) + Long.toString(r1, 36);
            }
            if (this._workerName != null) {
                id = this._workerName + id;
            }
            request.setAttribute(__NEW_SESSION_ID, (Object)id);
            return id;
        }
    }

    public Random getRandom() {
        return this._random;
    }

    public void setRandom(Random random) {
        this._random = random;
        this._weakRandom = false;
    }
}

