/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.xmla;

import com.tonbeller.jpivot.olap.mdxparse.Exp;
import com.tonbeller.jpivot.olap.mdxparse.FunCall;
import com.tonbeller.jpivot.olap.mdxparse.Literal;
import com.tonbeller.jpivot.olap.mdxparse.ParsedQuery;
import com.tonbeller.jpivot.olap.mdxparse.QueryAxis;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.olap.navi.SortRank;
import com.tonbeller.jpivot.olap.query.SortRankBase;
import com.tonbeller.jpivot.xmla.XMLA_Member;
import com.tonbeller.jpivot.xmla.XMLA_Model;
import com.tonbeller.jpivot.xmla.XMLA_QueryAdapter;

public class XMLA_SortRank
extends SortRankBase
implements SortRank {
    @Override
    public boolean isSortable(Position position) {
        Member[] members = position.getMembers();
        for (int i = 0; i < members.length; ++i) {
            if (!members[i].getLevel().getHierarchy().getDimension().isMeasure()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addSortToQuery() {
        if (this.sorting && this.sortPosMembers != null) {
            XMLA_Model model = (XMLA_Model)this.getModel();
            ParsedQuery pq = ((XMLA_QueryAdapter)model.getQueryAdapter()).getParsedQuery();
            switch (this.sortMode) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.orderAxis(pq);
                    break;
                }
                case 5: {
                    this.topBottomAxis(pq, "TopCount");
                    break;
                }
                case 6: {
                    this.topBottomAxis(pq, "BottomCount");
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    private void orderAxis(ParsedQuery pq) {
        QueryAxis[] queryAxes = pq.getAxes();
        QueryAxis qa = queryAxes[this.quaxToSort.getOrdinal()];
        Exp setForAx = qa.getExp();
        Exp[] args = new Exp[3];
        args[0] = setForAx;
        Exp sortExp = this.sortPosMembers.length > 1 ? new FunCall("()", (XMLA_Member[])this.sortPosMembers, 6) : (XMLA_Member)this.sortPosMembers[0];
        args[1] = sortExp;
        args[2] = Literal.createString(XMLA_SortRank.sortMode2String(this.sortMode));
        FunCall order = new FunCall("Order", args, 0);
        qa.setExp(order);
    }

    private void topBottomAxis(ParsedQuery pq, String function) {
        QueryAxis[] queryAxes = pq.getAxes();
        QueryAxis qa = queryAxes[this.quaxToSort.getOrdinal()];
        Exp setForAx = qa.getExp();
        Exp sortExp = this.sortPosMembers.length > 1 ? new FunCall("()", (XMLA_Member[])this.sortPosMembers, 6) : (XMLA_Member)this.sortPosMembers[0];
        Exp[] args = new Exp[]{setForAx, Literal.create(new Integer(this.topBottomCount)), sortExp};
        FunCall topbottom = new FunCall(function, args, 0);
        qa.setExp(topbottom);
    }

    private static String sortMode2String(int sortMode) {
        switch (sortMode) {
            case 1: {
                return "ASC";
            }
            case 2: {
                return "DESC";
            }
            case 3: {
                return "BASC";
            }
            case 4: {
                return "BDESC";
            }
        }
        return "";
    }
}

