/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.xmla;

import com.tonbeller.jpivot.MemberVisibilityAwareComparator;
import com.tonbeller.jpivot.core.ExtensionSupport;
import com.tonbeller.jpivot.olap.mdxparse.Formula;
import com.tonbeller.jpivot.olap.mdxparse.ParsedQuery;
import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.olap.navi.MemberTree;
import com.tonbeller.jpivot.olap.query.Quax;
import com.tonbeller.jpivot.util.StringUtil;
import com.tonbeller.jpivot.xmla.XMLA_Hierarchy;
import com.tonbeller.jpivot.xmla.XMLA_Level;
import com.tonbeller.jpivot.xmla.XMLA_Member;
import com.tonbeller.jpivot.xmla.XMLA_Model;
import com.tonbeller.jpivot.xmla.XMLA_QueryAdapter;
import com.tonbeller.jpivot.xmla.XMLA_Result;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class XMLA_MemberTree
extends ExtensionSupport
implements MemberTree {
    static Logger logger = Logger.getLogger(XMLA_MemberTree.class);

    public XMLA_MemberTree() {
        super.setId("memberTree");
    }

    @Override
    public Member[] getRootMembers(Hierarchy hier) {
        XMLA_QueryAdapter adapter;
        Quax quax;
        XMLA_Model model = (XMLA_Model)this.getModel();
        Level[] levels = hier.getLevels();
        XMLA_Level rootLevel = null;
        for (int i = 0; i < levels.length; ++i) {
            XMLA_Level xLev = (XMLA_Level)levels[i];
            if (xLev.getDepth() != 0) continue;
            rootLevel = xLev;
            break;
        }
        if (rootLevel == null) {
            return null;
        }
        ArrayList<XMLA_Member> visibleRootMembers = new ArrayList<XMLA_Member>();
        ArrayList<XMLA_Member> invisibleRootMembers = new ArrayList<XMLA_Member>();
        Member[] rootMembers = new Member[]{};
        try {
            rootMembers = rootLevel.getMembers();
        }
        catch (OlapException e) {
            logger.error(null, (Throwable)e);
        }
        ArrayList<XMLA_Member> aCalcMem = new ArrayList<XMLA_Member>();
        ParsedQuery pq = ((XMLA_QueryAdapter)model.getQueryAdapter()).getParsedQuery();
        Formula[] formulas = pq.getFormulas();
        for (int i = 0; i < formulas.length; ++i) {
            Formula f = formulas[i];
            if (!f.isMember()) continue;
            String dimUMember = StringUtil.bracketsAround(f.getFirstName());
            String dimUHier = ((XMLA_Hierarchy)hier).getUniqueName();
            if (!dimUHier.equals(dimUMember)) continue;
            String memberName = f.getUniqeName();
            XMLA_Member calcMem = (XMLA_Member)model.lookupMemberByUName(memberName);
            if (calcMem == null) {
                String[] nameParts = StringUtil.splitUniqueName(memberName);
                calcMem = new XMLA_Member(model, memberName, nameParts[1], null, true);
            }
            aCalcMem.add(calcMem);
        }
        XMLA_Result res = model.currentResult();
        if (res != null && (quax = (adapter = (XMLA_QueryAdapter)model.getQueryAdapter()).findQuax(hier.getDimension())) != null) {
            int iDim = quax.dimIdx(hier.getDimension());
            int iAx = quax.getOrdinal();
            if (adapter.isSwapAxes()) {
                iAx = (iAx + 1) % 2;
            }
            Axis axis = res.getAxes()[iAx];
            List positions = axis.getPositions();
            for (Position pos : positions) {
                Member[] posMembers = pos.getMembers();
                XMLA_Member mem = (XMLA_Member)posMembers[iDim];
                if (this.getParent(mem) != null) continue;
                if (!visibleRootMembers.contains(mem)) {
                    visibleRootMembers.add(mem);
                }
                boolean containsMember = false;
                for (int i = 0; i < rootMembers.length; ++i) {
                    if (!rootMembers[i].equals(mem)) continue;
                    containsMember = true;
                    break;
                }
                if (containsMember || aCalcMem.contains(mem) || invisibleRootMembers.contains(mem)) continue;
                invisibleRootMembers.add(mem);
            }
        }
        Member[] members = new Member[rootMembers.length + aCalcMem.size() + invisibleRootMembers.size()];
        for (Member members[i] : rootMembers) {
        }
        for (XMLA_Member calcMem : aCalcMem) {
            members[k++] = calcMem;
        }
        for (XMLA_Member invisibleMem : invisibleRootMembers) {
            members[k++] = invisibleMem;
        }
        if (!visibleRootMembers.isEmpty()) {
            Arrays.sort(members, new MemberVisibilityAwareComparator(visibleRootMembers));
        }
        return members;
    }

    @Override
    public boolean hasChildren(Member member) {
        XMLA_Member m = (XMLA_Member)member;
        if (m.isCalculated()) {
            return false;
        }
        long ccard = m.getChildrenCardinality();
        if (ccard >= 0L) {
            return ccard > 0L;
        }
        XMLA_Level xLev = (XMLA_Level)member.getLevel();
        return xLev != null && xLev.getChildLevel() != null;
    }

    @Override
    public Member[] getChildren(Member member) {
        XMLA_Level xLev = (XMLA_Level)member.getLevel();
        if (xLev == null || xLev.getChildLevel() == null) {
            return null;
        }
        Member[] children = new Member[]{};
        try {
            children = ((XMLA_Member)member).getChildren();
        }
        catch (OlapException e) {
            logger.error((Object)"?", (Throwable)e);
            return null;
        }
        return children;
    }

    @Override
    public Member getParent(Member member) {
        XMLA_Level xLev = (XMLA_Level)member.getLevel();
        if (xLev == null || xLev.getDepth() == 0) {
            return null;
        }
        XMLA_Member parent = null;
        try {
            parent = (XMLA_Member)((XMLA_Member)member).getParent();
        }
        catch (OlapException e) {
            logger.error((Object)"?", (Throwable)e);
            return null;
        }
        return parent;
    }
}

