/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.test.olap;

import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.test.olap.TestAxis;
import com.tonbeller.jpivot.test.olap.TestDimension;
import com.tonbeller.jpivot.test.olap.TestHierarchy;
import com.tonbeller.jpivot.test.olap.TestMember;
import com.tonbeller.jpivot.test.olap.TestOlapModel;
import com.tonbeller.jpivot.test.olap.TestPosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class TestOlapModelUtils {
    private TestOlapModelUtils() {
    }

    public static List getVisible(TestDimension dim) {
        TestHierarchy th = (TestHierarchy)dim.getHierarchies()[0];
        List<TestMember> roots = Arrays.asList(th.getRootMembers());
        ArrayList list = new ArrayList();
        TestOlapModelUtils.getVisible(roots, list);
        return list;
    }

    static void getVisible(List members, ArrayList list) {
        for (TestMember m : members) {
            if (m.isVisible()) {
                list.add(m);
            }
            TestOlapModelUtils.getVisible(m.getChildMember(), list);
        }
    }

    public static TestAxis createAxis(Member[] members) {
        List<Member> list = Arrays.asList(members);
        return TestOlapModelUtils.createAxis(list);
    }

    public static TestAxis createAxis(List members) {
        TestAxis a = new TestAxis();
        for (Member m : members) {
            TestPosition p = new TestPosition(a);
            p.setMembers(new Member[]{m});
            a.addPosition(p);
        }
        return a;
    }

    public static TestAxis crossJoin(Axis a1, Axis a2) {
        TestAxis a = new TestAxis();
        Iterator i1 = a1.getPositions().iterator();
        while (i1.hasNext()) {
            Member[] m1 = ((Position)i1.next()).getMembers();
            Iterator i2 = a2.getPositions().iterator();
            while (i2.hasNext()) {
                int i;
                Member[] m2 = ((Position)i2.next()).getMembers();
                Member[] m = new Member[m1.length + m2.length];
                for (i = 0; i < m1.length; ++i) {
                    m[i] = m1[i];
                }
                i = 0;
                int j = m1.length;
                while (i < m2.length) {
                    m[j] = m2[i];
                    ++i;
                    ++j;
                }
                TestPosition p = new TestPosition(a);
                p.setMembers(m);
                a.addPosition(p);
            }
        }
        return a;
    }

    public static TestAxis createAxis(TestDimension dim) {
        return TestOlapModelUtils.createAxis(TestOlapModelUtils.getVisible(dim));
    }

    public static TestAxis createAxis(TestDimension[] dims) {
        TestAxis a = TestOlapModelUtils.createAxis(TestOlapModelUtils.getVisible(dims[0]));
        for (int i = 1; i < dims.length; ++i) {
            TestAxis b = TestOlapModelUtils.createAxis(TestOlapModelUtils.getVisible(dims[i]));
            a = TestOlapModelUtils.crossJoin(a, b);
        }
        return a;
    }

    public static List findPositions(TestAxis axis, Member member) {
        ArrayList<TestPosition> list = new ArrayList<TestPosition>();
        for (Object o : axis.getPositions()) {
            TestPosition p = (TestPosition)o;
            if (!p.contains(member)) continue;
            list.add(p);
        }
        return list;
    }

    public static TestAxis findAxis(TestOlapModel model, Member member) {
        TestHierarchy hier = (TestHierarchy)member.getLevel().getHierarchy();
        return TestOlapModelUtils.findAxis(model, hier);
    }

    public static TestAxis findAxis(TestOlapModel model, Hierarchy hier) {
        TestAxis[] axes = model.getAxes();
        for (int i = 0; i < axes.length; ++i) {
            Hierarchy[] th = axes[i].getHierarchies();
            for (int j = 0; j < th.length; ++j) {
                if (!hier.equals(th[j])) continue;
                return axes[i];
            }
        }
        return null;
    }

    public static void rebuildAxis(TestOlapModel tom, TestMember m) {
        TestAxis axis = TestOlapModelUtils.findAxis(tom, m);
        TestOlapModelUtils.rebuildAxis(tom, axis);
    }

    public static void rebuildAxis(TestOlapModel tom, TestAxis axis) {
        Hierarchy[] dims = axis.getHierarchies();
        TestAxis newAxis = TestOlapModelUtils.createAxis((TestDimension)dims[0].getDimension());
        for (int i = 1; i < dims.length; ++i) {
            TestAxis ax = TestOlapModelUtils.createAxis((TestDimension)dims[i].getDimension());
            newAxis = TestOlapModelUtils.crossJoin(newAxis, ax);
        }
        TestAxis[] axes = tom.getAxes();
        for (int i = 0; i < axes.length; ++i) {
            if (axes[i] != axis) continue;
            axes[i] = newAxis;
        }
    }

    public static void hideAll(Hierarchy hier) {
        TestMember[] members = ((TestHierarchy)hier).getRootMembers();
        for (int i = 0; i < members.length; ++i) {
            TestOlapModelUtils.recurseHideAll(members[i]);
        }
    }

    private static void recurseHideAll(TestMember member) {
        member.setVisible(false);
        if (member.hasChildren()) {
            for (TestMember child : member.getChildMember()) {
                TestOlapModelUtils.recurseHideAll(child);
            }
        }
    }

    public static void setVisible(List members) {
        if (members.size() > 0) {
            Member m0 = (Member)members.get(0);
            TestOlapModelUtils.hideAll(m0.getLevel().getHierarchy());
            Iterator it = members.iterator();
            while (it.hasNext()) {
                ((TestMember)it.next()).setVisible(true);
            }
        }
    }

    public static void setVisible(Member[] members) {
        TestOlapModelUtils.hideAll(members[0].getLevel().getHierarchy());
        for (int i = 0; i < members.length; ++i) {
            ((TestMember)members[i]).setVisible(true);
        }
    }

    public static int indexOf(Object[] array, Object obj) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != obj) continue;
            return i;
        }
        return -1;
    }
}

