/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.test.olap;

import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.olap.model.impl.PositionSpan;
import com.tonbeller.jpivot.olap.navi.DrillExpandPosition;
import com.tonbeller.jpivot.test.olap.TestAxis;
import com.tonbeller.jpivot.test.olap.TestExtensionSupport;
import com.tonbeller.jpivot.test.olap.TestMember;
import com.tonbeller.jpivot.test.olap.TestPosition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class TestDrillExpandPosition
extends TestExtensionSupport
implements DrillExpandPosition {
    @Override
    public boolean canExpand(Position position, Member member) {
        return this.canExpand((TestPosition)position, (TestMember)member);
    }

    @Override
    public boolean canCollapse(Position position, Member member) {
        return this.canCollapse((TestPosition)position, (TestMember)member);
    }

    @Override
    public void expand(Position position, Member member) {
        this.expand((TestPosition)position, (TestMember)member);
        this.fireModelChanged();
    }

    @Override
    public void collapse(Position position, Member member) {
        this.collapse((TestPosition)position, (TestMember)member);
        this.fireModelChanged();
    }

    void expand(TestPosition position, TestMember member) {
        ArrayList<TestPosition> childPositions = new ArrayList<TestPosition>();
        TestAxis axis = position.getAxis();
        int memberIndex = position.indexOf(member);
        PositionSpan ps = new PositionSpan(axis, position, member);
        List span = axis.getPositions().subList(ps.getStartIndex(), ps.getEndIndex());
        for (TestMember child : member.getChildMember()) {
            Iterator pi = span.iterator();
            while (pi.hasNext()) {
                Member[] members = ((Position)pi.next()).getMembers();
                members = (Member[])members.clone();
                TestPosition p = new TestPosition(axis);
                members[memberIndex] = child;
                p.setMembers(members);
                childPositions.add(p);
            }
        }
        axis.getPositions().addAll(ps.getEndIndex(), childPositions);
    }

    void collapse(TestPosition position, TestMember member) {
        List list = this.getDescendantPositions(position, member);
        int memberIndex = position.indexOf(member);
        for (TestPosition p : list) {
            ((TestMember)p.getMembers()[memberIndex]).setVisible(false);
        }
        position.getAxis().getPositions().removeAll(list);
    }

    boolean canExpand(TestPosition position, TestMember member) {
        if (!member.hasChildren()) {
            return false;
        }
        return this.getDescendantPositions(position, member).size() == 0;
    }

    boolean canCollapse(TestPosition position, TestMember member) {
        if (!member.hasChildren()) {
            return false;
        }
        return this.getDescendantPositions(position, member).size() > 0;
    }

    List getDescendantPositions(TestPosition position, TestMember member) {
        Position p;
        TestMember candidate;
        TestAxis axis = position.getAxis();
        PositionSpan ps = new PositionSpan(axis, position, member);
        ListIterator iter = axis.getPositions().listIterator(ps.getEndIndex());
        int memberIndex = position.indexOf(member);
        ArrayList<Position> descendantPositions = new ArrayList<Position>();
        while (iter.hasNext() && (candidate = (TestMember)(p = (Position)iter.next()).getMembers()[memberIndex]).getRootDistance() > member.getRootDistance()) {
            descendantPositions.add(p);
        }
        return descendantPositions;
    }
}

