/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table.navi;

import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.model.Property;
import com.tonbeller.jpivot.param.ParameterProvider;
import com.tonbeller.jpivot.table.navi.ClickableMemberSupport;
import com.tonbeller.wcf.controller.Controller;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.param.SessionParam;
import com.tonbeller.wcf.param.SessionParamPool;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpSession;

public class DynamicClickableMember
extends ClickableMemberSupport {
    private String page;
    private ParameterProvider paramProvider;
    private String menuLabel;

    public DynamicClickableMember(String uniqueName, String menuLabel, ParameterProvider paramProvider, String page) {
        super(uniqueName);
        this.menuLabel = menuLabel;
        this.paramProvider = paramProvider;
        this.page = page;
    }

    @Override
    protected RequestListener createRequestListener(OlapModel model, Member m) {
        return new AddMemberToParameterPool(model, m);
    }

    @Override
    public String getMenuLabel() {
        return this.menuLabel;
    }

    private class AddMemberToParameterPool
    implements RequestListener {
        private Member member;
        private OlapModel model;
        private static final String PAGE_PROPERTY = "$page";

        AddMemberToParameterPool(OlapModel model, Member m) {
            this.model = model;
            this.member = m;
        }

        public void request(RequestContext context) throws Exception {
            Property prop;
            SessionParamPool pool = SessionParamPool.instance((HttpSession)context.getSession());
            List c = DynamicClickableMember.this.paramProvider.createSessionParams(this.model, this.member);
            Iterator it = c.iterator();
            while (it.hasNext()) {
                pool.setParam((SessionParam)it.next());
            }
            if (DynamicClickableMember.this.page == null && (prop = this.member.getProperty(PAGE_PROPERTY)) != null) {
                DynamicClickableMember.this.page = prop.getValue();
            }
            if (DynamicClickableMember.this.page != null) {
                Controller.instance((HttpSession)context.getSession()).setNextView(DynamicClickableMember.this.page);
            }
        }
    }
}

