/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table.navi;

import com.tonbeller.jpivot.core.ModelChangeEvent;
import com.tonbeller.jpivot.core.ModelChangeListener;
import com.tonbeller.jpivot.olap.model.Cell;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.navi.DrillThrough;
import com.tonbeller.jpivot.table.CellBuilder;
import com.tonbeller.jpivot.table.CellBuilderDecorator;
import com.tonbeller.jpivot.table.TableComponent;
import com.tonbeller.jpivot.table.TableComponentExtensionSupport;
import com.tonbeller.wcf.component.RendererParameters;
import com.tonbeller.wcf.controller.Dispatcher;
import com.tonbeller.wcf.controller.DispatcherSupport;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.table.EditableTableComponent;
import com.tonbeller.wcf.table.EmptyTableModel;
import com.tonbeller.wcf.table.ITableComponent;
import com.tonbeller.wcf.table.TableColumn;
import com.tonbeller.wcf.table.TableModel;
import com.tonbeller.wcf.table.TableModelDecorator;
import com.tonbeller.wcf.utils.DomUtils;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Element;

public class DrillThroughUI
extends TableComponentExtensionSupport
implements ModelChangeListener {
    boolean available;
    boolean renderActions;
    Dispatcher dispatcher = new DispatcherSupport();
    DrillThrough extension;
    TableModelDecorator tableModel = new TableModelDecorator(EmptyTableModel.instance());
    public static final String ID = "drillThrough";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void initialize(RequestContext context, TableComponent table) throws Exception {
        super.initialize(context, table);
        table.getOlapModel().addModelChangeListener(this);
        if (!this.initializeExtension()) {
            this.available = false;
            return;
        }
        this.available = true;
        table.getDispatcher().addRequestListener(null, null, (RequestListener)this.dispatcher);
        CellBuilder cb = table.getCellBuilder();
        DomDecorator cr = new DomDecorator(table.getCellBuilder());
        table.setCellBuilder(cr);
    }

    @Override
    public void startBuild(RequestContext context) {
        super.startBuild(context);
        this.renderActions = RendererParameters.isRenderActions((RequestContext)context);
        if (this.renderActions) {
            this.dispatcher.clear();
        }
    }

    protected boolean initializeExtension() {
        OlapModel om = this.table.getOlapModel();
        this.extension = (DrillThrough)om.getExtension(ID);
        return this.extension != null;
    }

    protected boolean canDrillThrough(Cell cell) {
        return this.extension.canDrillThrough((Cell)cell.getRootDecoree());
    }

    protected TableModel drillThrough(Cell cell) {
        return this.extension.drillThrough((Cell)cell.getRootDecoree());
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public void modelChanged(ModelChangeEvent e) {
    }

    @Override
    public void structureChanged(ModelChangeEvent e) {
        this.initializeExtension();
        this.dispatcher.clear();
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    class DrillThroughHandler
    implements RequestListener {
        Cell cell;

        DrillThroughHandler(Cell cell) {
            this.cell = cell;
        }

        public void request(RequestContext context) throws Exception {
            if (DrillThroughUI.this.canDrillThrough(this.cell)) {
                HttpSession session = context.getSession();
                String drillTableRef = DrillThroughUI.this.table.getOlapModel().getID() + ".drillthroughtable";
                ITableComponent tc = (ITableComponent)session.getAttribute(drillTableRef);
                TableModel tm = DrillThroughUI.this.drillThrough(this.cell);
                tc.setModel(tm);
                tc.setVisible(true);
                TableColumn[] tableColumns = null;
                if (tc instanceof EditableTableComponent) {
                    tableColumns = ((EditableTableComponent)tc).getTableComp().getTableColumns();
                } else if (tc instanceof com.tonbeller.wcf.table.TableComponent) {
                    tableColumns = ((com.tonbeller.wcf.table.TableComponent)tc).getTableColumns();
                }
                if (tableColumns != null) {
                    for (int i = 0; i < tableColumns.length; ++i) {
                        TableColumn tableColumn = tableColumns[i];
                        tableColumn.setHidden(false);
                    }
                }
            }
        }
    }

    class DomDecorator
    extends CellBuilderDecorator {
        DomDecorator(CellBuilder delegate) {
            super(delegate);
        }

        @Override
        public Element build(Cell cell, boolean even) {
            Element parent = super.build(cell, even);
            if (!DrillThroughUI.this.enabled || !DrillThroughUI.this.renderActions || DrillThroughUI.this.extension == null) {
                return parent;
            }
            String id = DomUtils.randomId();
            if (DrillThroughUI.this.canDrillThrough(cell) && !cell.isNull()) {
                Element elem = this.table.insert("drill-through", parent);
                elem.setAttribute("id", id);
                elem.setAttribute("title", "Show source data");
                DrillThroughUI.this.dispatcher.addRequestListener(id, null, (RequestListener)new DrillThroughHandler(cell));
            }
            return parent;
        }
    }
}

