/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table.navi;

import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.olap.navi.DrillExpandPosition;
import com.tonbeller.jpivot.table.navi.DrillExpandUI;
import com.tonbeller.jpivot.table.span.Span;

public class DrillExpandPositionUI
extends DrillExpandUI {
    public static final String ID = "drillPosition";
    DrillExpandPosition expandPosition;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    protected boolean initializeExtension() {
        OlapModel om = this.table.getOlapModel();
        this.expandPosition = (DrillExpandPosition)om.getExtension("drillExpandPosition");
        return this.expandPosition != null;
    }

    @Override
    protected boolean canExpand(Span span) {
        if (!DrillExpandPositionUI.positionContainsMember(span)) {
            return false;
        }
        return this.expandPosition.canExpand((Position)span.getPosition().getRootDecoree(), (Member)span.getMember().getRootDecoree());
    }

    @Override
    protected boolean canCollapse(Span span) {
        if (!DrillExpandPositionUI.positionContainsMember(span)) {
            return false;
        }
        return this.expandPosition.canCollapse((Position)span.getPosition().getRootDecoree(), (Member)span.getMember().getRootDecoree());
    }

    @Override
    protected void expand(Span span) {
        this.expandPosition.expand((Position)span.getPosition().getRootDecoree(), (Member)span.getMember().getRootDecoree());
    }

    @Override
    protected void collapse(Span span) {
        this.expandPosition.collapse((Position)span.getPosition().getRootDecoree(), (Member)span.getMember().getRootDecoree());
    }

    @Override
    protected String getCollapseImage() {
        return "drill-position-collapse";
    }

    @Override
    protected String getExpandImage() {
        return "drill-position-expand";
    }

    @Override
    protected String getOtherImage() {
        return "drill-position-other";
    }
}

