/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.olap.mdxparse;

import com.tonbeller.jpivot.olap.mdxparse.CompoundId;
import com.tonbeller.jpivot.olap.mdxparse.Exp;
import com.tonbeller.jpivot.olap.mdxparse.ExpVisitor;
import java.util.List;

public class QueryAxis
implements Exp {
    private String name;
    private boolean nonEmpty;
    private Exp exp;
    private List dimProps;

    public QueryAxis(boolean nonEmpty, Exp exp, String name) {
        this.nonEmpty = nonEmpty;
        this.exp = exp;
        this.name = name;
    }

    public Exp getExp() {
        return this.exp;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNonEmpty() {
        return this.nonEmpty;
    }

    public void setExp(Exp exp) {
        this.exp = exp;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNonEmpty(boolean nonEmpty) {
        this.nonEmpty = nonEmpty;
    }

    @Override
    public String toMdx() {
        StringBuffer sb = new StringBuffer();
        if (this.nonEmpty) {
            sb.append("NON EMPTY ");
        }
        sb.append(this.exp.toMdx());
        if (this.dimProps != null && this.dimProps.size() > 0) {
            sb.append(" DIMENSION PROPERTIES ");
            for (int i = 0; i < this.dimProps.size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(((CompoundId)this.dimProps.get(i)).toMdx());
            }
        }
        sb.append(" ON ");
        sb.append(this.name);
        return sb.toString();
    }

    @Override
    public Object clone() {
        QueryAxis qa = new QueryAxis(this.nonEmpty, (Exp)this.exp.clone(), this.name);
        qa.setDimProps(this.dimProps);
        return qa;
    }

    public List getDimProps() {
        return this.dimProps;
    }

    public void setDimProps(List dimProps) {
        this.dimProps = dimProps;
    }

    @Override
    public void accept(ExpVisitor visitor) {
        visitor.visitQueryAxis(this);
    }
}

