/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.olap.mdxparse;

import com.tonbeller.jpivot.olap.mdxparse.Exp;
import com.tonbeller.jpivot.olap.mdxparse.ExpVisitor;
import com.tonbeller.jpivot.olap.mdxparse.MemberProperty;
import com.tonbeller.jpivot.util.StringUtil;

public class Formula
implements Exp {
    boolean isMember;
    String[] names;
    Exp exp;
    MemberProperty[] memberProperties;

    Formula(String[] names, Exp exp) {
        this(false, names, exp, new MemberProperty[0]);
    }

    Formula(String[] names, Exp exp, MemberProperty[] memberProperties) {
        this(true, names, exp, memberProperties);
    }

    private Formula(boolean isMember, String[] names, Exp exp, MemberProperty[] memberProperties) {
        this.isMember = isMember;
        this.names = names;
        this.exp = exp;
        this.memberProperties = memberProperties;
    }

    public boolean isMember() {
        return this.isMember;
    }

    public String getUniqeName() {
        String str = "";
        for (int i = 0; i < this.names.length; ++i) {
            if (i > 0) {
                str = str + ".";
            }
            str = str + StringUtil.bracketsAround(this.names[i]);
        }
        return str;
    }

    public String getFirstName() {
        return this.names[0];
    }

    public String getLastName() {
        int n = this.names.length - 1;
        return this.names[n];
    }

    @Override
    public String toMdx() {
        int i;
        StringBuffer sb = new StringBuffer();
        if (this.isMember) {
            sb.append("MEMBER ");
        } else {
            sb.append("SET ");
        }
        for (i = 0; i < this.names.length; ++i) {
            if (i > 0) {
                sb.append('.');
            }
            sb.append(StringUtil.bracketsAround(this.names[i]));
        }
        sb.append(" AS '");
        sb.append(this.exp.toMdx());
        sb.append('\'');
        for (i = 0; i < this.memberProperties.length; ++i) {
            sb.append(',');
            sb.append(this.memberProperties[i].toMdx());
        }
        return sb.toString();
    }

    @Override
    public Object clone() {
        MemberProperty[] cloneMemberProperties = new MemberProperty[this.memberProperties.length];
        for (int i = 0; i < cloneMemberProperties.length; ++i) {
            cloneMemberProperties[i] = (MemberProperty)this.memberProperties[i].clone();
        }
        return new Formula(this.isMember, this.names, (Exp)this.exp.clone(), cloneMemberProperties);
    }

    @Override
    public void accept(ExpVisitor visitor) {
        visitor.visitFormula(this);
    }

    public Exp getExp() {
        return this.exp;
    }
}

