/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.mondrian.MondrianHierarchy;
import com.tonbeller.jpivot.mondrian.MondrianMember;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Visitor;
import com.tonbeller.jpivot.olap.query.MDXElement;
import com.tonbeller.jpivot.olap.query.MDXLevel;
import com.tonbeller.tbutils.res.Resources;
import java.util.ArrayList;
import java.util.Locale;

public class MondrianLevel
implements Level,
MDXElement,
MDXLevel {
    private mondrian.olap.Level monLevel;
    private MondrianHierarchy hierarchy;
    private ArrayList aMembers;
    private MondrianModel model;
    private Resources resources;

    protected MondrianLevel(mondrian.olap.Level monLevel, MondrianHierarchy hierarchy, MondrianModel model) {
        this.monLevel = monLevel;
        this.hierarchy = hierarchy;
        this.model = model;
        this.resources = Resources.instance((Locale)model.getLocale(), MondrianLevel.class);
        this.aMembers = new ArrayList();
        hierarchy.addLevel(this);
    }

    protected void addMember(MondrianMember member) {
        this.aMembers.add(member);
    }

    @Override
    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    @Override
    public String getLabel() {
        String label = this.monLevel.getCaption();
        return this.resources.getOptionalString(label, label);
    }

    @Override
    public int getDepth() {
        return this.monLevel.getDepth();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitLevel(this);
    }

    @Override
    public Object getRootDecoree() {
        return this;
    }

    public mondrian.olap.Level getMonLevel() {
        return this.monLevel;
    }

    @Override
    public String getUniqueName() {
        return this.monLevel.getUniqueName();
    }

    @Override
    public boolean isAll() {
        return this.monLevel.isAll();
    }

    @Override
    public boolean hasChildLevel() {
        return this.monLevel.getChildLevel() != null;
    }
}

