/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.mondrian.MondrianDimension;
import com.tonbeller.jpivot.mondrian.MondrianLevel;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.olap.model.Dimension;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Visitor;
import com.tonbeller.jpivot.olap.query.MDXElement;
import com.tonbeller.tbutils.res.Resources;
import java.util.ArrayList;
import java.util.Locale;

public class MondrianHierarchy
implements Hierarchy,
MDXElement {
    private mondrian.olap.Hierarchy monHierarchy;
    private MondrianDimension dimension;
    private ArrayList aLevels;
    private MondrianModel model;
    private Resources resources;

    protected MondrianHierarchy(mondrian.olap.Hierarchy monHierarchy, MondrianDimension dimension, MondrianModel model) {
        this.monHierarchy = monHierarchy;
        this.dimension = dimension;
        this.model = model;
        this.resources = Resources.instance((Locale)model.getLocale(), MondrianHierarchy.class);
        this.aLevels = new ArrayList();
        dimension.addHierarchy(this);
    }

    protected void addLevel(MondrianLevel level) {
        this.aLevels.add(level);
    }

    @Override
    public Dimension getDimension() {
        return this.dimension;
    }

    @Override
    public Level[] getLevels() {
        return this.aLevels.toArray(new MondrianLevel[0]);
    }

    @Override
    public String getLabel() {
        String label = this.monHierarchy.getCaption();
        return this.resources.getOptionalString(label, label);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitHierarchy(this);
    }

    public mondrian.olap.Hierarchy getMonHierarchy() {
        return this.monHierarchy;
    }

    @Override
    public Object getRootDecoree() {
        return this;
    }

    @Override
    public String getUniqueName() {
        return this.monHierarchy.getUniqueName();
    }

    @Override
    public boolean hasAll() {
        return this.monHierarchy.hasAll();
    }
}

