/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.wcf.table.AbstractTableModel;
import com.tonbeller.wcf.table.DefaultTableRow;
import com.tonbeller.wcf.table.TableRow;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import mondrian.olap.MemoryLimitExceededException;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.util.MemoryMonitor;
import mondrian.util.MemoryMonitorFactory;
import org.apache.log4j.Logger;

public class MondrianDrillThroughTableModel
extends AbstractTableModel {
    private static Logger logger = Logger.getLogger(MondrianDrillThroughTableModel.class);
    private String title = "Drill Through Table";
    private String caption = "";
    private String sql = "";
    private String jdbcUser;
    private String jdbcUrl;
    private String jdbcPassword;
    private String jdbcDriver;
    private String dataSourceName;
    private DataSource dataSource;
    private static Context jndiContext;
    private boolean ready = false;
    private TableRow[] rows = new TableRow[0];
    private String[] columnTitles = new String[0];

    public int getRowCount() {
        if (!this.ready) {
            this.executeQuery();
        }
        return this.rows.length;
    }

    public TableRow getRow(int rowIndex) {
        if (!this.ready) {
            this.executeQuery();
        }
        return this.rows[rowIndex];
    }

    public String getTitle() {
        return this.title;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
        this.ready = false;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getColumnCount() {
        if (!this.ready) {
            this.executeQuery();
        }
        return this.columnTitles.length;
    }

    public String getColumnTitle(int columnIndex) {
        if (!this.ready) {
            this.executeQuery();
        }
        return this.columnTitles[columnIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQuery() {
        Connection con = null;
        class Listener
        implements MemoryMonitor.Listener {
            String oomMsg;

            Listener() {
            }

            public void memoryUsageNotification(long used, long max) {
                StringBuffer buf = new StringBuffer(200);
                buf.append("OutOfMemory used=");
                buf.append(used);
                buf.append(", max=");
                buf.append(max);
                if (MondrianDrillThroughTableModel.this.dataSourceName != null) {
                    buf.append(" for data source: ");
                    buf.append(MondrianDrillThroughTableModel.this.dataSourceName);
                } else if (MondrianDrillThroughTableModel.this.jdbcUrl != null) {
                    buf.append(" for jcbc URL: ");
                    buf.append(MondrianDrillThroughTableModel.this.jdbcUrl);
                }
                this.oomMsg = buf.toString();
            }

            void check() throws MemoryLimitExceededException {
                if (this.oomMsg != null) {
                    throw new MemoryLimitExceededException(this.oomMsg);
                }
            }
        }
        Listener listener = new Listener();
        MemoryMonitor mm = MemoryMonitorFactory.getMemoryMonitor();
        try {
            mm.addListener((MemoryMonitor.Listener)listener);
            con = this.getConnection();
            Statement s = con.createStatement();
            ResultSet rs = s.executeQuery(this.sql);
            ResultSetMetaData md = rs.getMetaData();
            int numCols = md.getColumnCount();
            this.columnTitles = new String[numCols];
            listener.check();
            for (int i = 0; i < numCols; ++i) {
                this.columnTitles[i] = md.getColumnName(i + 1);
            }
            this.title = this.title.concat(" for " + this.columnTitles[this.columnTitles.length - 1]);
            ArrayList<DefaultTableRow> tempRows = new ArrayList<DefaultTableRow>();
            while (rs.next()) {
                Object[] row = new Object[numCols];
                for (int i = 0; i < numCols; ++i) {
                    row[i] = rs.getObject(i + 1);
                }
                tempRows.add(new DefaultTableRow(row));
                listener.check();
            }
            rs.close();
            this.rows = tempRows.toArray(new TableRow[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"?", (Throwable)e);
            this.rows = new TableRow[1];
            this.columnTitles = new String[1];
            this.columnTitles[0] = "An error occured";
            Object[] row = new Object[]{e.toString()};
            this.rows[0] = new DefaultTableRow(row);
            this.ready = false;
            return;
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e1) {}
            mm.removeListener((MemoryMonitor.Listener)listener);
        }
        this.ready = true;
    }

    private Connection getConnection() throws SQLException {
        if (this.dataSource == null && this.dataSourceName == null) {
            if (this.jdbcUrl == null) {
                throw new RuntimeException("Mondrian Connect string '' must contain either '" + RolapConnectionProperties.Jdbc + "' or '" + RolapConnectionProperties.DataSource + "'");
            }
            return DriverManager.getConnection(this.jdbcUrl, this.jdbcUser, this.jdbcPassword);
        }
        return this.getDataSource().getConnection();
    }

    private DataSource getDataSource() {
        if (this.dataSource == null) {
            try {
                this.dataSource = (DataSource)this.getJndiContext().lookup(this.dataSourceName);
            }
            catch (NamingException e) {
                throw new RuntimeException("Error while looking up data source (" + this.dataSourceName + ")", e);
            }
        }
        return this.dataSource;
    }

    private Context getJndiContext() throws NamingException {
        if (jndiContext == null) {
            jndiContext = new InitialContext();
        }
        return jndiContext;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getJdbcUser() {
        return this.jdbcUser;
    }

    public void setJdbcUser(String jdbcUser) {
        this.jdbcUser = jdbcUser;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public void setExternalDataSource(DataSource externalDataSource) {
        this.dataSource = externalDataSource;
    }
}

