/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.settings.LocaleSettings;
import org.pentaho.reporting.ui.datasources.table.EditableHeader;
import org.pentaho.reporting.ui.datasources.table.Messages;
import org.pentaho.reporting.ui.datasources.table.TableDataSourceEditor;
import org.pentaho.reporting.ui.datasources.table.TableEditor;

public class TableEditorPanel
extends JPanel {
    private TableEditor table = new TableEditor();
    private AddRowAction addRowAction;
    private AddColumnAction addColumnAction;
    private RemoveRowAction removeRowAction;
    private RemoveColumnAction removeColumnAction;
    private boolean selectingHeaderColumn;

    private void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        ChangeListener[] listeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ChangeListener listener = listeners[i];
            listener.stateChanged(changeEvent);
        }
    }

    public TableEditorPanel() {
        this.table.setAutoResizeMode(2);
        this.table.addKeyListener(new TableAddEmptyRowAtEndHandler());
        this.table.getSelectionModel().addListSelectionListener(new TableSelectionHandler());
        this.table.getTableHeader().addMouseListener(new TableHeaderDataSourceMouseListener());
        this.table.getModel().addTableModelListener(new TableUpdateHandler());
        this.table.setColumnSelectionAllowed(true);
        this.addRowAction = new AddRowAction();
        this.addColumnAction = new AddColumnAction();
        this.removeRowAction = new RemoveRowAction();
        this.removeColumnAction = new RemoveColumnAction();
        JPanel toolbar = new JPanel(new FlowLayout(2));
        toolbar.add((Component)new BorderlessButton((Action)this.addRowAction));
        toolbar.add((Component)new BorderlessButton((Action)this.addColumnAction));
        toolbar.add((Component)new BorderlessButton((Action)this.removeRowAction));
        toolbar.add((Component)new BorderlessButton((Action)this.removeColumnAction));
        this.setLayout(new BorderLayout());
        this.add((Component)toolbar, "North");
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.add((Component)new JScrollPane(this.table), "Center");
    }

    public TableModel getTableEditorModel() {
        return this.table.getTableEditorModel();
    }

    public void applyLocaleSettings(LocaleSettings localeSettings) {
        this.table.applyLocaleSettings(localeSettings);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.addRowAction.setEnabled(enabled);
        this.addColumnAction.setEnabled(enabled);
        this.removeRowAction.setEnabled(enabled && this.table.getSelectedRow() != -1);
        this.removeColumnAction.setEnabled(enabled && this.table.getSelectedColumn() != -1);
    }

    private void updateComponents() {
        boolean enabled = this.isEnabled();
        this.removeRowAction.setEnabled(enabled && this.table.getSelectedRow() != -1);
        this.removeColumnAction.setEnabled(enabled && this.table.getSelectedColumn() != -1);
    }

    public void stopEditing() {
        this.table.stopEditing();
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    public void setTableEditorModel(TableModel tableModel) {
        this.stopEditing();
        this.table.setTableEditorModel(tableModel);
    }

    private class TableUpdateHandler
    implements TableModelListener {
        private TableUpdateHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            TableEditorPanel.this.fireChangeEvent();
        }
    }

    private class TableAddEmptyRowAtEndHandler
    extends KeyAdapter {
        private TableAddEmptyRowAtEndHandler() {
        }

        @Override
        public void keyTyped(KeyEvent aEvt) {
            int key = aEvt.getKeyCode();
            if (key == 9 && TableEditorPanel.this.table.getSelectedColumn() == TableEditorPanel.this.table.getColumnCount() - 1 && TableEditorPanel.this.table.getSelectedRow() == TableEditorPanel.this.table.getRowCount() - 1) {
                TableEditorPanel.this.table.addRow();
            }
        }
    }

    private class TableHeaderDataSourceMouseListener
    extends MouseAdapter {
        private TableHeaderDataSourceMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            Object eventSource = event.getSource();
            if (!(eventSource instanceof JTableHeader)) {
                return;
            }
            JTableHeader tableHeader = (JTableHeader)eventSource;
            TableEditorPanel.this.removeColumnAction.setEnabled(TableEditorPanel.this.table.getColumnCount() > 1);
            TableEditorPanel.this.removeRowAction.setEnabled(false);
            TableCellEditor theTableCellEditor = TableEditorPanel.this.table.getCellEditor();
            if (theTableCellEditor != null) {
                TableEditorPanel.this.table.getCellEditor().stopCellEditing();
            }
            this.selectColumn(tableHeader, event.getPoint());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void selectColumn(JTableHeader aTableHeader, Point aPoint) {
            try {
                TableEditorPanel.this.selectingHeaderColumn = true;
                TableColumnModel columnModel = TableEditorPanel.this.table.getColumnModel();
                int columnIndex = aTableHeader.columnAtPoint(aPoint);
                if (columnIndex <= 0) {
                    return;
                }
                TableColumn tableColumn = columnModel.getColumn(columnIndex);
                TableEditorPanel.this.table.clearSelection();
                TableEditorPanel.this.table.setColumnSelectionInterval(columnIndex, columnIndex);
                TableEditorPanel.this.table.setSelectedColumn(tableColumn);
                if (TableEditorPanel.this.table.getRowCount() > 0) {
                    TableEditorPanel.this.table.addRowSelectionInterval(0, TableEditorPanel.this.table.getRowCount() - 1);
                }
            }
            finally {
                TableEditorPanel.this.selectingHeaderColumn = false;
            }
        }
    }

    private class TableSelectionHandler
    implements ListSelectionListener {
        private TableSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TableEditorPanel.this.selectingHeaderColumn) {
                return;
            }
            EditableHeader editableHeader = (EditableHeader)TableEditorPanel.this.table.getTableHeader();
            TableEditorPanel.this.removeColumnAction.setEnabled(false);
            TableEditorPanel.this.removeRowAction.setEnabled(TableEditorPanel.this.table.getSelectedRowCount() > 0 && TableEditorPanel.this.table.getRowCount() > 1);
            editableHeader.editingStopped(null);
            editableHeader.removeEditor();
        }
    }

    private class RemoveRowAction
    extends AbstractAction {
        private RemoveRowAction() {
            this.setEnabled(false);
            URL location = TableDataSourceEditor.class.getResource("/org/pentaho/reporting/ui/datasources/table/resources/RemoveRow.png");
            if (location != null) {
                this.putValue("SmallIcon", new ImageIcon(location));
            } else {
                this.putValue("Name", Messages.getString("TableDataSourceEditor.RemoveRow.Name"));
            }
            this.putValue("ShortDescription", Messages.getString("TableDataSourceEditor.RemoveRow.Description"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableEditorPanel.this.table.removeRow();
            this.setEnabled(false);
        }
    }

    private class RemoveColumnAction
    extends AbstractAction {
        private RemoveColumnAction() {
            this.setEnabled(false);
            URL location = TableDataSourceEditor.class.getResource("/org/pentaho/reporting/ui/datasources/table/resources/RemoveColumn.png");
            if (location != null) {
                this.putValue("SmallIcon", new ImageIcon(location));
            } else {
                this.putValue("Name", Messages.getString("TableDataSourceEditor.RemoveColumn.Name"));
            }
            this.putValue("ShortDescription", Messages.getString("TableDataSourceEditor.RemoveColumn.Description"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableEditorPanel.this.table.removeColumn();
            this.setEnabled(false);
        }
    }

    private class AddColumnAction
    extends AbstractAction {
        private AddColumnAction() {
            this.setEnabled(false);
            URL location = TableDataSourceEditor.class.getResource("/org/pentaho/reporting/ui/datasources/table/resources/AddColumn.png");
            if (location != null) {
                this.putValue("SmallIcon", new ImageIcon(location));
            } else {
                this.putValue("Name", Messages.getString("TableDataSourceEditor.AddColumn.Name"));
            }
            this.putValue("ShortDescription", Messages.getString("TableDataSourceEditor.AddColumn.Description"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableEditorPanel.this.table.addColumn(" ");
            TableEditorPanel.this.updateComponents();
        }
    }

    private class AddRowAction
    extends AbstractAction {
        private AddRowAction() {
            this.setEnabled(false);
            URL location = TableDataSourceEditor.class.getResource("/org/pentaho/reporting/ui/datasources/table/resources/AddRow.png");
            if (location != null) {
                this.putValue("SmallIcon", new ImageIcon(location));
            } else {
                this.putValue("Name", Messages.getString("TableDataSourceEditor.AddRow.Name"));
            }
            this.putValue("ShortDescription", Messages.getString("TableDataSourceEditor.AddRow.Description"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableEditorPanel.this.table.addRow();
            TableEditorPanel.this.updateComponents();
        }
    }
}

