/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.table;

import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;

public class TableEditorModel
extends AbstractTableModel {
    private static final int COL_INCREMENT = 50;
    private boolean suspendEvents;
    private ArrayList<String> columnNames = new ArrayList(50);
    private ArrayList<Class> columnTypes = new ArrayList(50);
    private ArrayList<ArrayList<Object>> data = new ArrayList(1000);

    public void setColumnName(int index, String identifier) {
        if (index == 0) {
            throw new IllegalStateException();
        }
        this.columnNames.set(index - 1, identifier);
        this.fireTableStructureChanged();
    }

    public void removeColumn(int column) {
        int size = this.data.size();
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            ArrayList<Object> theRow = this.data.get(rowIndex);
            theRow.remove(column);
        }
        this.columnNames.remove(column);
        this.columnTypes.remove(column);
        this.fireTableStructureChanged();
    }

    public void removeRow(int row) {
        this.data.remove(row);
    }

    public void addColumn(String name, Class type) {
        this.columnNames.add(name);
        this.columnTypes.add(type);
        int colCount = this.getColumnCount();
        for (int theRowIndex = 0; theRowIndex < this.data.size(); ++theRowIndex) {
            ArrayList<Object> row = this.data.get(theRowIndex);
            while (row.size() < colCount) {
                row.add(null);
            }
        }
        this.fireTableStructureChanged();
    }

    public void addRow() {
        int colCount = this.columnNames.size();
        ArrayList<Object> newRow = new ArrayList<Object>(colCount);
        for (int i = 0; i < colCount; ++i) {
            newRow.add(null);
        }
        this.data.add(newRow);
        this.fireTableDataChanged();
    }

    public void addRow(int idx) {
        int colCount = this.columnNames.size();
        ArrayList<Object> newRow = new ArrayList<Object>(colCount);
        for (int i = 0; i < colCount; ++i) {
            newRow.add(null);
        }
        this.data.add(idx, newRow);
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "#";
        }
        return this.columnNames.get(column - 1);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Integer.class;
        }
        return this.columnTypes.get(columnIndex - 1);
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        if (this.columnNames.isEmpty()) {
            return 0;
        }
        return 1 + this.columnNames.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return rowIndex + 1;
        }
        ArrayList<Object> list = this.data.get(rowIndex);
        return list.get(columnIndex - 1);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            throw new IllegalStateException();
        }
        ArrayList<Object> list = this.data.get(rowIndex);
        list.set(columnIndex - 1, aValue);
        this.fireTableCellUpdated(rowIndex, columnIndex - 1);
    }

    public void clear() {
        this.data.clear();
        this.columnNames.clear();
        this.columnTypes.clear();
        this.fireTableStructureChanged();
    }

    public void setColumnClass(int index, Class type) {
        if (index == 0) {
            return;
        }
        if (type == null) {
            throw new NullPointerException();
        }
        int realIndex = index - 1;
        this.columnTypes.set(realIndex, type);
        for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
            Object currentValue = this.getValueAt(rowIndex, index);
            Object newValue = ConverterRegistry.convert((Object)currentValue, (Class)type, null);
            this.setValueAt(newValue, rowIndex, index);
        }
        this.fireTableStructureChanged();
    }

    @Override
    public void fireTableDataChanged() {
        if (this.suspendEvents) {
            return;
        }
        super.fireTableDataChanged();
    }

    @Override
    public void fireTableStructureChanged() {
        if (this.suspendEvents) {
            return;
        }
        super.fireTableStructureChanged();
    }

    @Override
    public void fireTableRowsInserted(int firstRow, int lastRow) {
        if (this.suspendEvents) {
            return;
        }
        super.fireTableRowsInserted(firstRow, lastRow);
    }

    @Override
    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        if (this.suspendEvents) {
            return;
        }
        super.fireTableRowsUpdated(firstRow, lastRow);
    }

    @Override
    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        if (this.suspendEvents) {
            return;
        }
        super.fireTableRowsDeleted(firstRow, lastRow);
    }

    @Override
    public void fireTableCellUpdated(int row, int column) {
        if (this.suspendEvents) {
            return;
        }
        super.fireTableCellUpdated(row, column);
    }

    @Override
    public void fireTableChanged(TableModelEvent e) {
        if (this.suspendEvents) {
            return;
        }
        super.fireTableChanged(e);
    }

    public boolean isSuspendEvents() {
        return this.suspendEvents;
    }

    public void setSuspendEvents(boolean suspendEvents) {
        this.suspendEvents = suspendEvents;
        if (!suspendEvents) {
            this.fireTableStructureChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyInto(TableModel model) {
        try {
            this.setSuspendEvents(true);
            this.clear();
            if (model == null) {
                return;
            }
            int columnCount = model.getColumnCount();
            for (int col = 0; col < columnCount; ++col) {
                this.addColumn(model.getColumnName(col), model.getColumnClass(col));
            }
            int rowCount = model.getRowCount();
            for (int r = 0; r < rowCount; ++r) {
                this.addRow();
                for (int col = 0; col < columnCount; ++col) {
                    Object originalValue = model.getValueAt(r, col);
                    this.setValueAt(originalValue, r, col + 1);
                }
            }
        }
        finally {
            this.setSuspendEvents(false);
        }
    }

    public TableModel createModel() {
        TypedTableModel tableModel = new TypedTableModel();
        int columnCount = this.getColumnCount();
        for (int col = 1; col < columnCount; ++col) {
            tableModel.addColumn(this.getColumnName(col), this.getColumnClass(col));
        }
        int rowCount = this.getRowCount();
        for (int r = 0; r < rowCount; ++r) {
            for (int col = 1; col < columnCount; ++col) {
                tableModel.setValueAt(this.getValueAt(r, col), r, col - 1);
            }
        }
        return tableModel;
    }
}

