/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.poi.ss.usermodel.Workbook;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.ui.datasources.table.Messages;

public class SheetSelectorDialog
extends CommonDialog {
    private Workbook workbook;
    private JComboBox sheetsComboBox;

    public SheetSelectorDialog(Workbook aWorkbook, JDialog aParent) {
        super((Dialog)aParent);
        this.workbook = aWorkbook;
        this.init();
    }

    protected void init() {
        Object[] theSheetsData = new Object[this.workbook.getNumberOfSheets()];
        for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
            theSheetsData[i] = this.workbook.getSheetName(i);
        }
        this.sheetsComboBox = new JComboBox<Object>(theSheetsData);
        this.setTitle(Messages.getString("SheetSelectorDialog.Import"));
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        super.init();
    }

    protected String getDialogId() {
        return "TableDataSourceEditor.SheetSelector";
    }

    protected Component createContentPane() {
        JPanel centerPanel = new JPanel(new FlowLayout(0));
        JLabel theSheetLabel = new JLabel(Messages.getString("SheetSelectorDialog.ChooseSheet"));
        centerPanel.add(theSheetLabel);
        centerPanel.add(this.sheetsComboBox);
        return centerPanel;
    }

    public int getSelectedIndex() {
        return this.sheetsComboBox.getSelectedIndex();
    }

    public boolean performSelection() {
        return super.performEdit();
    }
}

