/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.sequence;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.Sequence;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.SequenceDescription;
import org.pentaho.reporting.libraries.designtime.swing.propertyeditors.FastPropertyEditorManager;
import org.pentaho.reporting.libraries.designtime.swing.table.PropertyTableModel;
import org.pentaho.reporting.ui.datasources.sequence.Messages;

public class SequencePropertyTableModel
extends AbstractTableModel
implements PropertyTableModel {
    private static final Log logger = LogFactory.getLog(SequencePropertyTableModel.class);
    private Sequence sequence;
    private ArrayList<Parameter> properties = new ArrayList();

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setSequence(Sequence sequence) {
        this.properties.clear();
        this.sequence = sequence;
        if (this.sequence != null) {
            SequenceDescription sequenceDescription = this.sequence.getSequenceDescription();
            int parameterCount = sequenceDescription.getParameterCount();
            for (int i = 0; i < parameterCount; ++i) {
                try {
                    Parameter parameter = new Parameter(sequenceDescription.getParameterName(i), sequenceDescription.getParameterDisplayName(i, Locale.getDefault()), sequenceDescription.getParameterType(i), sequenceDescription.getEditor(i));
                    this.properties.add(parameter);
                    continue;
                }
                catch (MissingResourceException mre) {
                    logger.warn((Object)("Unable to process parameter " + i + " for sequence description " + sequenceDescription));
                }
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        if (this.sequence == null) {
            return 0;
        }
        return this.sequence.getSequenceDescription().getParameterCount();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return Messages.getString("SequencePropertyTableModel.Name");
        }
        return Messages.getString("SequencePropertyTableModel.Value");
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Parameter.class;
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 1) {
            return;
        }
        Parameter parameter = this.properties.get(rowIndex);
        if (aValue == null || parameter.getType().isInstance(aValue)) {
            this.sequence.setParameter(parameter.getName(), aValue);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Parameter parameter = this.properties.get(rowIndex);
        if (columnIndex == 0) {
            return parameter;
        }
        return this.sequence.getParameter(parameter.getName());
    }

    public PropertyEditor getEditorForCell(int row, int column) {
        if (column != 1) {
            return null;
        }
        Parameter parameter = this.properties.get(row);
        PropertyEditor editor = parameter.getEditor();
        if (editor != null) {
            return editor;
        }
        if (String.class.equals((Object)parameter.getType())) {
            return null;
        }
        return FastPropertyEditorManager.findEditor((Class)parameter.getType());
    }

    public Class getClassForCell(int row, int column) {
        if (column == 0) {
            return Parameter.class;
        }
        Parameter parameter = this.properties.get(row);
        return parameter.getType();
    }

    private static class Parameter {
        private String name;
        private String displayName;
        private Class type;
        private PropertyEditor editor;

        private Parameter(String name, String displayName, Class type, PropertyEditor editor) {
            this.name = name;
            this.displayName = displayName;
            this.type = type;
            this.editor = editor;
        }

        public PropertyEditor getEditor() {
            return this.editor;
        }

        public Class getType() {
            return this.type;
        }

        public String toString() {
            return this.displayName;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

