/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.util.tracker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ops4j.pax.web.extender.whiteboard.internal.util.tracker.ReplaceableServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceableService<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ReplaceableService.class);
    private final BundleContext context;
    private final Class<T> serviceClass;
    private final ReplaceableServiceListener<T> serviceListener;
    private final ServiceTracker<T, T> serviceTracker;
    private final List<ServiceReference<T>> boundReferences;
    private T service;

    public ReplaceableService(BundleContext context, Class<T> serviceClass, ReplaceableServiceListener<T> serviceListener) {
        this.context = context;
        this.serviceClass = serviceClass;
        this.serviceListener = serviceListener;
        this.serviceTracker = new ServiceTracker(context, serviceClass, (ServiceTrackerCustomizer)new Customizer());
        this.boundReferences = new ArrayList<ServiceReference<T>>();
    }

    public void start() {
        this.serviceTracker.open();
    }

    public void stop() {
        this.serviceTracker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bind(T service) {
        if (this.serviceListener != null) {
            T oldService;
            ReplaceableService replaceableService = this;
            synchronized (replaceableService) {
                oldService = service;
                this.service = service;
            }
            this.serviceListener.serviceChanged(oldService, service);
        }
    }

    private class Customizer
    implements ServiceTrackerCustomizer<T, T> {
        private Customizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T addingService(ServiceReference<T> reference) {
            ServiceReference bind;
            Object service = ReplaceableService.this.context.getService(reference);
            List list = ReplaceableService.this.boundReferences;
            synchronized (list) {
                ReplaceableService.this.boundReferences.add(reference);
                Collections.sort(ReplaceableService.this.boundReferences);
                bind = (ServiceReference)ReplaceableService.this.boundReferences.get(0);
            }
            if (bind == reference) {
                ReplaceableService.this.bind(service);
            } else {
                ReplaceableService.this.bind(ReplaceableService.this.serviceTracker.getService(bind));
            }
            return service;
        }

        public void modifiedService(ServiceReference<T> reference, T service) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<T> reference, T service) {
            ServiceReference bind;
            List list = ReplaceableService.this.boundReferences;
            synchronized (list) {
                ReplaceableService.this.boundReferences.remove(reference);
                bind = ReplaceableService.this.boundReferences.isEmpty() ? null : (ServiceReference)ReplaceableService.this.boundReferences.get(0);
            }
            if (bind == null) {
                ReplaceableService.this.bind(null);
            } else {
                ReplaceableService.this.bind(ReplaceableService.this.serviceTracker.getService(bind));
            }
            try {
                ReplaceableService.this.context.ungetService(reference);
            }
            catch (IllegalStateException ise) {
                LOG.debug("trying to unget service from stoped bundle!");
            }
        }
    }
}

