/*
 * Decompiled with CFR 0.152.
 */
package ofc4j.model.elements;

import java.util.Arrays;
import java.util.Collection;
import ofc4j.model.elements.Element;
import ofc4j.model.metadata.Alias;
import ofc4j.model.metadata.Converter;
import ofc4j.util.ScatterChartPointConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScatterChart
extends Element {
    private String colour;
    @Alias(value="dot-size")
    private Integer dotSize;

    public ScatterChart(String type) {
        super("scatter");
    }

    public ScatterChart addPoints(Point ... points) {
        this.getValues().addAll(Arrays.asList(points));
        return this;
    }

    public ScatterChart addPoint(Number x, Number y) {
        return this.addPoints(new Point(x, y));
    }

    public ScatterChart addPoints(Collection<Point> points) {
        this.getValues().addAll(points);
        return this;
    }

    public String getColour() {
        return this.colour;
    }

    public void setColour(String colour) {
        this.colour = colour;
    }

    public Integer getDotSize() {
        return this.dotSize;
    }

    public void setDotSize(Integer dotSize) {
        this.dotSize = dotSize;
    }

    @Converter(value=ScatterChartPointConverter.class)
    public static class Point {
        private Number x;
        private Number y;

        public Point(Number x, Number y) {
            this.x = x;
            this.y = y;
        }

        public Number getX() {
            return this.x;
        }

        public void setX(Number x) {
            this.x = x;
        }

        public Number getY() {
            return this.y;
        }

        public void setY(Number y) {
            this.y = y;
        }
    }
}

