/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.BitSet;
import java.util.List;
import java.util.SortedSet;
import mondrian.rolap.agg.AbstractSegmentBody;
import mondrian.util.Pair;

class DenseIntSegmentBody
extends AbstractSegmentBody {
    private static final long serialVersionUID = 5391233622968115488L;
    private final int[] values;
    private final BitSet nullValues;

    DenseIntSegmentBody(BitSet nullValues, int[] values, List<Pair<SortedSet<Comparable>, Boolean>> axes) {
        super(axes);
        this.values = values;
        this.nullValues = nullValues;
    }

    @Override
    public Object getValueArray() {
        return this.values;
    }

    @Override
    public BitSet getNullValueIndicators() {
        return this.nullValues;
    }

    @Override
    protected int getSize() {
        return this.values.length;
    }

    @Override
    protected int getEffectiveSize() {
        return this.values.length - this.nullValues.cardinality();
    }

    @Override
    protected Object getObject(int i) {
        int value = this.values[i];
        if (value == 0 && this.nullValues.get(i)) {
            return null;
        }
        return value;
    }
}

