/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.Logger;

class CachedCollection
implements Collection {
    private final Collection innerCollection;
    private final MdrStorage storage;

    public CachedCollection(MdrStorage storage, Collection innerCollection) {
        this.innerCollection = innerCollection;
        this.storage = storage;
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object obj) {
        return this.innerCollection.contains(obj);
    }

    public Object[] toArray(Object[] obj) {
        Object[] result;
        Object[] value = this.toArray();
        if (value.length > (result = obj).length) {
            if (value.getClass() == result.getClass()) {
                return value;
            }
            result = (Object[])Array.newInstance(obj.getClass(), value.length);
        }
        int i = 0;
        while (i < result.length) {
            result[i] = i < value.length ? value[i] : null;
            ++i;
        }
        return result;
    }

    public Iterator iterator() {
        return new CachedIterator(this.innerCollection.iterator());
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public Object[] toArray() {
        Object[] array = this.innerCollection.toArray();
        try {
            int i = 0;
            while (i < array.length) {
                array[i] = this.storage.getObject((MOFID)array[i]);
                ++i;
            }
        }
        catch (Exception e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
        return array;
    }

    public boolean remove(Object obj) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.innerCollection.size();
    }

    public boolean containsAll(Collection collection) {
        return this.innerCollection.containsAll(collection);
    }

    public boolean add(Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        return this.innerCollection.isEmpty();
    }

    private class CachedIterator
    implements Iterator {
        private final Iterator innerIterator;

        private CachedIterator(Iterator innerIterator) {
            this.innerIterator = innerIterator;
        }

        public boolean hasNext() {
            return this.innerIterator.hasNext();
        }

        public Object next() {
            try {
                return CachedCollection.this.storage.getObject((MOFID)this.innerIterator.next());
            }
            catch (StorageException e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

