/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;

import java.io.ByteArrayInputStream;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BigKeyPage;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.Btree;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePage;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePageSource;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.EntryTypeInfo;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeFactory;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeStorage;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.MDRCache;

public class BtreeCacheSource
implements BtreePageSource {
    private MDRCache cache;
    private int pageSize;
    private EntryTypeInfo pageIdInfo;
    private byte[] noPageId;
    private long nextID = 0L;
    private BtreeStorage storage;

    public BtreeCacheSource(MDRCache cache, int pageSize, BtreeStorage storage) throws StorageException {
        this.cache = cache;
        this.pageSize = pageSize;
        this.storage = storage;
        this.pageIdInfo = EntryTypeInfo.getEntryTypeInfo(Storage.EntryType.MOFID, storage);
        this.noPageId = this.storage.getMOFIDData(BtreeFactory.nullMOFID);
    }

    public BtreePage getPage(byte[] pageId, Btree btree) throws StorageException {
        MOFID pageMofId = this.storage.readMOFIDData(new ByteArrayInputStream(pageId));
        return (BtreePage)this.cache.get(pageMofId);
    }

    public BigKeyPage newBigKeyPage(Btree btree) throws StorageException {
        BigKeyPage page = new BigKeyPage();
        this.initNewPage(page, btree);
        return page;
    }

    public BtreePage newPage(Btree btree) throws StorageException {
        BtreePage page = btree.pageFactory();
        this.initNewPage(page, btree);
        return page;
    }

    private void initNewPage(BtreePage page, Btree btree) throws StorageException {
        MOFID pageMOFID = new MOFID(this.storage);
        byte[] mofidBytes = this.storage.getMOFIDData(pageMOFID);
        page.init(btree, mofidBytes, new byte[this.pageSize], true);
        this.cache.put(pageMOFID, page);
        this.cache.setDirty(pageMOFID);
    }

    public void unpinPage(BtreePage page) {
    }

    public void unpinPage(BigKeyPage page) {
    }

    public void dirtyPage(BtreePage page) throws StorageException {
        MOFID dirtyPageMOFId = this.storage.readMOFIDData(new ByteArrayInputStream(page.pageId));
        this.cache.setDirty(dirtyPageMOFId);
    }

    public BtreePage getRootPage(Btree btree) throws StorageException {
        return this.newPage(btree);
    }

    public EntryTypeInfo getPageIdInfo() {
        return this.pageIdInfo;
    }

    public int getPageIdLength() {
        return this.pageIdInfo.getLength();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setNoPage(byte[] pageId) {
        System.arraycopy(this.noPageId, 0, pageId, 0, pageId.length);
    }

    public boolean isNoPage(byte[] pageId) {
        int i = 0;
        while (i < pageId.length) {
            if (pageId[i] != this.noPageId[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public synchronized long getNextMofid() {
        ++this.nextID;
        return this.nextID;
    }

    public String getMofidPrefix() {
        return "01234567-89AB-CDEF-GHIJ-KLMNOPQRSTUV";
    }

    public BtreeStorage getStorage() {
        return this.storage;
    }
}

