/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.plugin.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.pentaho.chart.core.ChartDocument;
import org.pentaho.chart.core.ChartElement;
import org.pentaho.chart.plugin.api.IOutput;
import org.pentaho.chart.plugin.api.PersistenceException;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.common.AttributeMap;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class XmlChartOutput
implements IOutput {
    private ChartDocument document;

    public XmlChartOutput(ChartDocument document) {
        if (document == null) {
            throw new NullPointerException();
        }
        this.document = document;
    }

    @Override
    public OutputStream persistChart(OutputStream outputStream, IOutput.OutputTypes fileType, int width, int height) throws PersistenceException {
        try {
            XmlWriter writer = new XmlWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"));
            writer.writeXmlDeclaration("UTF-8");
            ChartElement chartElement = this.document.getRootElement();
            this.writeElement(writer, chartElement);
            writer.flush();
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        return outputStream;
    }

    private void writeElement(XmlWriter writer, ChartElement chartElement) throws IOException {
        AttributeList list = this.createMainAttributes(chartElement, writer, new AttributeList());
        writer.writeTag(chartElement.getNamespace(), chartElement.getTagName(), list, false);
        for (ChartElement child = chartElement.getFirstChildItem(); child != null; child = child.getNextItem()) {
            this.writeElement(writer, child);
        }
        if (!XmlChartOutput.isEmpty(chartElement.getText(), true)) {
            writer.writeTextNormalized(chartElement.getText(), false);
        }
        writer.writeCloseTag();
    }

    public static boolean isEmpty(String source, boolean trim) {
        if (source == null) {
            return true;
        }
        if (source.length() == 0) {
            return true;
        }
        if (!trim) {
            return false;
        }
        char[] chars = source.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c <= ' ') continue;
            return false;
        }
        return true;
    }

    protected AttributeList createMainAttributes(ChartElement element, XmlWriter writer, AttributeList attList) {
        if (element == null) {
            throw new NullPointerException();
        }
        if (writer == null) {
            throw new NullPointerException();
        }
        if (attList == null) {
            throw new NullPointerException();
        }
        AttributeMap map = element.getAttributeMap();
        String[] attributeNamespaces = map.getNameSpaces();
        for (int i = 0; i < attributeNamespaces.length; ++i) {
            String namespace = attributeNamespaces[i];
            String[] attributeNames = map.getNames(namespace);
            for (int j = 0; j < attributeNames.length; ++j) {
                String name = attributeNames[j];
                Object value = element.getAttribute(namespace, name);
                if (value == null) continue;
                this.ensureNamespaceDefined(writer, attList, namespace);
                attList.setAttribute(namespace, name, String.valueOf(value));
            }
        }
        return attList;
    }

    private void ensureNamespaceDefined(XmlWriter writer, AttributeList attList, String namespace) {
        if (!writer.isNamespaceDefined(namespace) && !attList.isNamespaceUriDefined(namespace)) {
            attList.addNamespaceDeclaration("autoGenNs", namespace);
        }
    }

    @Override
    public Writer persistMap(Writer outputStream, String mapName) throws PersistenceException {
        return outputStream;
    }

    @Override
    public Object getDrawable() {
        return null;
    }
}

