/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.plugin.jfreechart.chart.multi;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.pentaho.chart.ChartDocumentContext;
import org.pentaho.chart.core.ChartDocument;
import org.pentaho.chart.core.ChartElement;
import org.pentaho.chart.css.keys.ChartStyleKeys;
import org.pentaho.chart.css.styles.ChartLineVisibleType;
import org.pentaho.chart.css.styles.ChartMarkerVisibleType;
import org.pentaho.chart.css.styles.ChartMultiStyle;
import org.pentaho.chart.data.ChartTableModel;
import org.pentaho.chart.plugin.jfreechart.chart.JFreeChartGenerator;
import org.pentaho.chart.plugin.jfreechart.utils.ChartMarkerFilledType;
import org.pentaho.chart.plugin.jfreechart.utils.JFreeChartUtils;
import org.pentaho.chart.plugin.jfreechart.utils.ShapeFactory;
import org.pentaho.chart.plugin.jfreechart.utils.StrokeFactory;
import org.pentaho.reporting.libraries.css.keys.border.BorderStyleKeys;
import org.pentaho.reporting.libraries.css.values.CSSConstant;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.util.messages.Messages;

public abstract class JFreeMultiChartGenerator
extends JFreeChartGenerator {
    private static final Log logger = LogFactory.getLog(JFreeMultiChartGenerator.class);

    public JFreeChart createChart(ChartDocumentContext chartDocContext, ChartTableModel data, CSSConstant chartType) {
        ChartDocument chartDocument = chartDocContext.getChartDocument();
        String title = JFreeMultiChartGenerator.getTitle(chartDocument);
        String valueCategoryLabel = JFreeMultiChartGenerator.getValueCategoryLabel(chartDocument);
        String valueAxisLabel = JFreeMultiChartGenerator.getValueAxisLabel(chartDocument);
        PlotOrientation orientation = this.getPlotOrientation(chartDocument);
        boolean legend = JFreeMultiChartGenerator.getShowLegend(chartDocument);
        boolean toolTips = JFreeMultiChartGenerator.getShowToolTips(chartDocument);
        DefaultCategoryDataset categoryDataset = this.datasetGeneratorFactory.createDefaultCategoryDataset(chartDocContext, data);
        if (categoryDataset == null) {
            logger.error((Object)Messages.getErrorString("JFreeChartFactoryEngine.ERROR_0001_DATASET_IS_NULL"));
            return null;
        }
        JFreeChart chart = null;
        if (ChartMultiStyle.MULTI.equals((Object)chartType)) {
            chart = ChartFactory.createBarChart((String)title, (String)valueCategoryLabel, (String)valueAxisLabel, (CategoryDataset)categoryDataset, (PlotOrientation)orientation, (boolean)legend, (boolean)toolTips, (boolean)true);
            CategoryPlot plot = (CategoryPlot)chart.getPlot();
            DefaultCategoryDataset dataset1 = categoryDataset;
            plot.setDataset(1, (CategoryDataset)dataset1);
            DefaultCategoryDataset dataset2 = categoryDataset;
            plot.setDataset(2, (CategoryDataset)dataset2);
            LineAndShapeRenderer renderer1 = new LineAndShapeRenderer();
            renderer1.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
            plot.setRenderer(1, (CategoryItemRenderer)renderer1);
            plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
            AreaRenderer renderer2 = new AreaRenderer();
            renderer2.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
            plot.setRenderer(2, (CategoryItemRenderer)renderer2);
            plot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
        }
        CategoryPlot categoryPlot = chart.getCategoryPlot();
        ChartElement[] seriesElements = chartDocument.getRootElement().findChildrenByName("series");
        if (categoryPlot != null && seriesElements != null) {
            this.setSeriesAttributes(seriesElements, data, categoryPlot);
        }
        return chart;
    }

    private void setSeriesAttributes(ChartElement[] seriesElements, ChartTableModel data, CategoryPlot categoryPlot) {
        this.setSeriesItemLabel(categoryPlot, seriesElements, data);
        this.setSeriesPaint(categoryPlot, seriesElements, data);
        JFreeMultiChartGenerator.setSeriesMarkerStyles(categoryPlot, seriesElements);
        JFreeMultiChartGenerator.setSeriesLineStyles(categoryPlot, seriesElements);
        JFreeMultiChartGenerator.setSeriesBarOutline(categoryPlot, seriesElements, data);
    }

    private static void setSeriesMarkerStyles(CategoryPlot categoryPlot, ChartElement[] seriesElements) {
        int length = seriesElements.length;
        ShapeFactory shapeFacObj = ShapeFactory.getInstance();
        for (int i = 0; i < length; ++i) {
            ChartElement currElement = seriesElements[i];
            if (!(categoryPlot.getRenderer() instanceof LineAndShapeRenderer)) continue;
            LineAndShapeRenderer lineAndShapeRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
            lineAndShapeRenderer.setSeriesShapesVisible(i, JFreeMultiChartGenerator.isMarkerVisible(currElement));
            lineAndShapeRenderer.setSeriesShape(i, shapeFacObj.getShape(currElement));
            lineAndShapeRenderer.setSeriesShapesFilled(i, JFreeMultiChartGenerator.isShapeFilled(currElement));
        }
    }

    private static boolean isMarkerVisible(ChartElement currElement) {
        CSSValue visibleStr = currElement.getLayoutStyle().getValue(ChartStyleKeys.MARKER_VISIBLE);
        return ChartMarkerVisibleType.VISIBLE.equals((Object)visibleStr);
    }

    private static boolean isShapeFilled(ChartElement currElement) {
        CSSValue filledStr = currElement.getLayoutStyle().getValue(ChartStyleKeys.MARKER_FILLED);
        return ChartMarkerFilledType.FILLED.equals((Object)filledStr);
    }

    public static void setSeriesLineStyles(CategoryPlot categoryPlot, ChartElement[] seriesElements) {
        int length = seriesElements.length;
        StrokeFactory strokeFacObj = StrokeFactory.getInstance();
        for (int i = 0; i < length; ++i) {
            ChartElement currElement = seriesElements[i];
            if (!(categoryPlot.getRenderer() instanceof LineAndShapeRenderer)) continue;
            LineAndShapeRenderer lineAndShapeRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
            CSSValue visibleStr = currElement.getLayoutStyle().getValue(ChartStyleKeys.LINE_VISIBLE);
            lineAndShapeRenderer.setSeriesLinesVisible(i, ChartLineVisibleType.VISIBLE.equals((Object)visibleStr));
            BasicStroke lineStyleStroke = strokeFacObj.getLineStroke(currElement);
            if (lineStyleStroke == null) continue;
            lineAndShapeRenderer.setSeriesStroke(i, (Stroke)lineStyleStroke);
        }
    }

    private static void setSeriesBarOutline(CategoryPlot categoryPlot, ChartElement[] seriesElements, ChartTableModel data) {
        int length = seriesElements.length;
        StrokeFactory strokeFacObj = StrokeFactory.getInstance();
        for (int i = 0; i < length; ++i) {
            ChartElement currElement = seriesElements[i];
            int column = JFreeChartUtils.getSeriesColumn(currElement, data, i);
            if (!(categoryPlot.getRenderer() instanceof BarRenderer)) continue;
            BarRenderer barRender = (BarRenderer)categoryPlot.getRenderer();
            BasicStroke borderStyleStroke = strokeFacObj.getBorderStroke(currElement);
            if (borderStyleStroke == null) continue;
            CSSValue borderColorValue = currElement.getLayoutStyle().getValue(BorderStyleKeys.BORDER_TOP_COLOR);
            Color borderColor = JFreeChartUtils.getColorFromCSSValue(borderColorValue);
            if (borderColor != null) {
                barRender.setSeriesOutlinePaint(column, (Paint)borderColor, true);
            }
            barRender.setSeriesOutlineStroke(column, (Stroke)borderStyleStroke, true);
            barRender.setDrawBarOutline(true);
        }
    }
}

