/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.plugin.jfreechart.chart.dial;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.dial.DialBackground;
import org.jfree.chart.plot.dial.DialCap;
import org.jfree.chart.plot.dial.DialFrame;
import org.jfree.chart.plot.dial.DialLayer;
import org.jfree.chart.plot.dial.DialLayerChangeEvent;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.DialPointer;
import org.jfree.chart.plot.dial.DialScale;
import org.jfree.chart.plot.dial.DialTextAnnotation;
import org.jfree.chart.plot.dial.DialValueIndicator;
import org.jfree.chart.plot.dial.StandardDialFrame;
import org.jfree.chart.plot.dial.StandardDialRange;
import org.jfree.chart.plot.dial.StandardDialScale;
import org.jfree.data.general.ValueDataset;
import org.jfree.text.TextUtilities;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.StandardGradientPaintTransformer;
import org.jfree.ui.TextAnchor;
import org.jfree.util.PaintUtilities;
import org.pentaho.chart.ChartDocumentContext;
import org.pentaho.chart.core.ChartDocument;
import org.pentaho.chart.core.ChartElement;
import org.pentaho.chart.css.keys.ChartStyleKeys;
import org.pentaho.chart.data.ChartTableModel;
import org.pentaho.chart.plugin.jfreechart.chart.JFreeChartGenerator;
import org.pentaho.chart.plugin.jfreechart.utils.ColorFactory;
import org.pentaho.chart.plugin.jfreechart.utils.JFreeChartUtils;
import org.pentaho.chart.plugin.jfreechart.utils.StrokeFactory;
import org.pentaho.reporting.libraries.css.keys.border.BorderStyleKeys;
import org.pentaho.reporting.libraries.css.keys.box.BoxStyleKeys;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.css.values.CSSValuePair;

public class JFreeDialChartGenerator
extends JFreeChartGenerator {
    private static final String DIALVALUEINDICATOR = "dialvalueindicator";
    private static final String DIALRANGES = "dialranges";
    private static final String COUNT = "count";
    private static final String MINORTICK = "minortick";
    private static final String INCREMENT = "increment";
    private static final String MAJORTICK = "majortick";
    private static final String TICKLABEL = "ticklabel";
    private static final String EXTENT = "extent";
    private static final String STARTANGLE = "startangle";
    private static final String SCALE = "scale";
    private static final String DIALCAP = "dialcap";
    private static final String ANNOTATION = "annotation";
    private static final String DIALPOINTER = "dialpointer";
    private static final String UPPERBOUND = "upperbound";
    private static final String LOWERBOUND = "lowerbound";
    private static final String DIALRANGE = "dialrange";

    @Override
    protected JFreeChart doCreateChart(ChartDocumentContext chartDocContext, ChartTableModel data) {
        ChartDocument chartDocument = chartDocContext.getChartDocument();
        SquareDialPlot dialPlot = new SquareDialPlot();
        ValueDataset dataset = (ValueDataset)this.datasetGeneratorFactory.createDataset(chartDocContext, data);
        dialPlot.setDataset(dataset);
        this.setDialFrame(chartDocument, dialPlot);
        this.setDialTextAnnotation(chartDocument, dialPlot);
        this.setDialValueIndicator(chartDocument, dialPlot);
        this.setDialScale(chartDocument, dialPlot);
        this.setDialCap(chartDocument, dialPlot);
        this.setDialRange(chartDocument, dialPlot);
        this.setDialBackground(chartDocument, dialPlot);
        this.setDialPointer(chartDocument, dialPlot);
        JFreeChart chart = new JFreeChart(JFreeDialChartGenerator.getTitle(chartDocument), (Plot)dialPlot);
        return chart;
    }

    protected void setDialFrame(ChartDocument chartDocument, DialPlot dialPlot) {
        Color borderBackgroundColorTmp;
        Color innerBorderColorTmp;
        Color outerBorderColor;
        ChartElement plotElement;
        Color frameForegroundPaint = Color.black;
        Color frameInnerForegroundPaint = Color.black;
        Color frameBackgroundPaint = Color.white;
        BasicStroke frameStroke = new BasicStroke(2.0f);
        StrokeFactory strokeFacObj = StrokeFactory.getInstance();
        BasicStroke borderStyleStroke = strokeFacObj.getBorderStroke(plotElement = this.getUniqueElement(chartDocument, "plot"));
        if (borderStyleStroke != null) {
            frameStroke = borderStyleStroke;
        }
        if ((outerBorderColor = ColorFactory.getInstance().getColor(plotElement, BorderStyleKeys.BORDER_TOP_COLOR)) != null) {
            frameForegroundPaint = outerBorderColor;
        }
        if ((innerBorderColorTmp = ColorFactory.getInstance().getColor(plotElement, BorderStyleKeys.BORDER_BOTTOM_COLOR)) != null) {
            frameInnerForegroundPaint = innerBorderColorTmp;
        }
        if ((borderBackgroundColorTmp = ColorFactory.getInstance().getColor(plotElement)) != null) {
            frameBackgroundPaint = borderBackgroundColorTmp;
        }
        DoubleLineDialFrame dialFrame = new DoubleLineDialFrame();
        dialFrame.setForegroundPaint(frameForegroundPaint);
        dialFrame.setInnerForegroundPaint(frameInnerForegroundPaint);
        dialFrame.setStroke(frameStroke);
        dialFrame.setBackgroundPaint(frameBackgroundPaint);
        dialPlot.setDialFrame((DialFrame)dialFrame);
    }

    protected void setDialBackground(ChartDocument chartDocument, DialPlot dialPlot) {
        ChartElement plotElement = this.getUniqueElement(chartDocument, "plot");
        CSSValuePair cssValue = (CSSValuePair)plotElement.getLayoutStyle().getValue(ChartStyleKeys.GRADIENT_COLOR);
        Color beginColor = JFreeChartUtils.getColorFromCSSValue(cssValue.getFirstValue());
        Color endColor = JFreeChartUtils.getColorFromCSSValue(cssValue.getSecondValue());
        GradientPaint gradientpaint = new GradientPaint(new Point(), beginColor, new Point(), endColor);
        DialBackground dialbackground = new DialBackground((Paint)gradientpaint);
        dialbackground.setGradientPaintTransformer((GradientPaintTransformer)new StandardGradientPaintTransformer(GradientPaintTransformType.VERTICAL));
        dialPlot.setBackground((DialLayer)dialbackground);
    }

    protected void setDialRange(ChartDocument chartDocument, DialPlot dialPlot) {
        double rangeInnerRadius = 0.4;
        ChartElement[] rangeElements = this.getElements(chartDocument, DIALRANGE);
        for (int i = 0; i < rangeElements.length; ++i) {
            double lowerBound = Double.parseDouble(rangeElements[i].getAttribute(LOWERBOUND).toString());
            double upperBound = Double.parseDouble(rangeElements[i].getAttribute(UPPERBOUND).toString());
            Color rangeColorTmp = ColorFactory.getInstance().getColor(rangeElements[i]);
            Color rangeColor = Color.BLACK;
            if (rangeColorTmp != null) {
                rangeColor = rangeColorTmp;
            }
            SingleLineDialRange standarddialrange = new SingleLineDialRange(lowerBound, upperBound, rangeColor);
            standarddialrange.setInnerRadius(0.4);
            dialPlot.addLayer((DialLayer)standarddialrange);
        }
    }

    protected void setDialPointer(ChartDocument chartDocument, DialPlot dialPlot) {
        BasicStroke borderStyleStroke;
        double pointerRadiusTmp;
        double pointerWidthRadiusTmp;
        Color pointerBorderColorTmp;
        double pointerRadius = 0.9;
        double pointerWidthRadius = 0.05;
        Color pointerFillPaint = Color.gray;
        Color pointerOutlinePaint = Color.black;
        BasicStroke pointerOutlineStroke = new BasicStroke(2.0f);
        VariableStrokePointer pointer = new VariableStrokePointer();
        ChartElement pointerElement = this.getUniqueElement(chartDocument, DIALPOINTER);
        Color pointerColorTmp = ColorFactory.getInstance().getColor(pointerElement);
        if (pointerColorTmp != null) {
            pointerFillPaint = pointerColorTmp;
        }
        if ((pointerBorderColorTmp = ColorFactory.getInstance().getColor(pointerElement, BorderStyleKeys.BORDER_TOP_COLOR)) != null) {
            pointerOutlinePaint = pointerBorderColorTmp;
        }
        if ((pointerWidthRadiusTmp = this.parseDouble(pointerElement.getLayoutStyle().getValue(BoxStyleKeys.WIDTH)) / 100.0) != 0.0) {
            pointerWidthRadius = pointerWidthRadiusTmp;
        }
        if ((pointerRadiusTmp = this.parseDouble(pointerElement.getLayoutStyle().getValue(BoxStyleKeys.HEIGHT)) / 100.0) != 0.0) {
            pointerRadius = pointerRadiusTmp;
        }
        if ((borderStyleStroke = StrokeFactory.getInstance().getBorderStroke(pointerElement)) != null) {
            pointerOutlineStroke = borderStyleStroke;
        }
        pointer.setRadius(pointerRadius);
        pointer.setOutlineStroke(pointerOutlineStroke);
        pointer.setWidthRadius(pointerWidthRadius);
        pointer.setFillPaint(pointerFillPaint);
        pointer.setOutlinePaint(pointerOutlinePaint);
        dialPlot.addPointer((DialPointer)pointer);
    }

    protected void setDialTextAnnotation(ChartDocument chartDocument, DialPlot dialPlot) {
        Font textAnnotationFont = new Font("Dialog", 1, 14);
        Color textAnnotationPaint = Color.black;
        double textAnnotationRadius = 0.7;
        ChartElement annotationElement = this.getUniqueElement(chartDocument, ANNOTATION);
        if (annotationElement != null && annotationElement.getText() != null) {
            Font annotationFontTmp;
            String annotation = annotationElement.getText();
            Color annotationColorTmp = ColorFactory.getInstance().getColor(annotationElement);
            if (annotationColorTmp != null) {
                textAnnotationPaint = annotationColorTmp;
            }
            if ((annotationFontTmp = JFreeChartUtils.getFont(annotationElement)) != null) {
                textAnnotationFont = annotationFontTmp;
            }
            DialTextAnnotation dialtextannotation = new DialTextAnnotation(annotation);
            dialtextannotation.setFont(textAnnotationFont);
            dialtextannotation.setPaint((Paint)textAnnotationPaint);
            dialtextannotation.setRadius(0.7);
            dialPlot.addLayer((DialLayer)dialtextannotation);
        }
    }

    protected void setDialCap(ChartDocument chartDocument, DialPlot dialPlot) {
        Color capColor;
        Color borderColor;
        ChartElement dialCapElement;
        double capRadius = 0.05;
        Color capFillPaint = Color.white;
        Color capOutlinePaint = Color.black;
        BasicStroke capOutlineStroke = new BasicStroke(2.0f);
        StrokeFactory strokeFacObj = StrokeFactory.getInstance();
        BasicStroke borderStyleStroke = strokeFacObj.getBorderStroke(dialCapElement = this.getUniqueElement(chartDocument, DIALCAP));
        if (borderStyleStroke != null) {
            capOutlineStroke = borderStyleStroke;
        }
        if ((borderColor = ColorFactory.getInstance().getColor(dialCapElement, BorderStyleKeys.BORDER_TOP_COLOR)) != null) {
            capOutlinePaint = borderColor;
        }
        if ((capColor = ColorFactory.getInstance().getColor(dialCapElement)) != null) {
            capFillPaint = capColor;
        }
        capRadius = this.parseDouble(dialCapElement.getLayoutStyle().getValue(BoxStyleKeys.WIDTH)) / 100.0;
        DialCap dialCap = new DialCap();
        dialCap.setRadius(capRadius);
        dialCap.setFillPaint((Paint)capFillPaint);
        dialCap.setOutlinePaint((Paint)capOutlinePaint);
        dialCap.setOutlineStroke((Stroke)capOutlineStroke);
        dialPlot.setCap((DialLayer)dialCap);
    }

    protected double parseDouble(CSSValue value) {
        String trimmedString = value.getCSSText().trim();
        for (int i = 0; i < trimmedString.length(); ++i) {
            char c = trimmedString.charAt(i);
            if (Character.isDigit(c)) continue;
            try {
                double d = Double.parseDouble(trimmedString.substring(0, i));
                return d;
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    protected void setDialScale(ChartDocument chartDocument, DialPlot dialPlot) {
        Color minorTickColorTmp;
        Color majorTickColorTmp;
        double minorTickLengthTmp;
        double majorTickLengthTmp;
        Font tickLabelFontTmp;
        double scaleLowerBound = -40.0;
        double scaleUpperBound = 60.0;
        double scaleStartAngle = -120.0;
        double scaleExtent = -300.0;
        double scaleMajorTickIncrement = 10.0;
        int scaleMinorTickCount = 4;
        double scaleTickRadius = 0.88;
        double scaleTickLabelOffset = 0.15;
        double scaleMajorTickLength = 0.04;
        Color scaleMajorTickPaint = Color.black;
        BasicStroke scaleMajorTickStroke = new BasicStroke(3.0f);
        double scaleMinorTickLength = 0.02;
        Color scaleMinorTickPaint = Color.black;
        BasicStroke scaleMinorTickStroke = new BasicStroke(1.0f);
        Font scaleTickLabelFont = new Font("Dialog", 0, 14);
        Color scaleTickLabelPaint = Color.blue;
        ChartElement scaleElement = this.getUniqueElement(chartDocument, SCALE);
        scaleUpperBound = Double.parseDouble(scaleElement.getAttribute(UPPERBOUND).toString());
        scaleLowerBound = Double.parseDouble(scaleElement.getAttribute(LOWERBOUND).toString());
        scaleStartAngle = Double.parseDouble(scaleElement.getAttribute(STARTANGLE).toString());
        scaleExtent = Double.parseDouble(scaleElement.getAttribute(EXTENT).toString());
        ChartElement tickLabelElement = this.getUniqueElement(chartDocument, TICKLABEL);
        Color tickLabelColorTmp = ColorFactory.getInstance().getColor(tickLabelElement);
        if (tickLabelColorTmp != null) {
            scaleTickLabelPaint = tickLabelColorTmp;
        }
        if ((tickLabelFontTmp = JFreeChartUtils.getFont(tickLabelElement)) != null) {
            scaleTickLabelFont = tickLabelFontTmp;
        }
        ChartElement majorTickElement = this.getUniqueElement(chartDocument, MAJORTICK);
        scaleMajorTickIncrement = Double.parseDouble((String)majorTickElement.getAttribute(INCREMENT));
        float majorTickWidthTmp = (float)this.parseDouble(majorTickElement.getLayoutStyle().getValue(BoxStyleKeys.WIDTH));
        if (majorTickWidthTmp != 0.0f) {
            scaleMajorTickStroke = new BasicStroke(majorTickWidthTmp);
        }
        if ((majorTickLengthTmp = this.parseDouble(majorTickElement.getLayoutStyle().getValue(BoxStyleKeys.HEIGHT)) / 100.0) != 0.0) {
            scaleMajorTickLength = majorTickLengthTmp;
        }
        ChartElement minorTickElement = this.getUniqueElement(chartDocument, MINORTICK);
        scaleMinorTickCount = Integer.parseInt((String)minorTickElement.getAttribute(COUNT));
        float minorTickWidthTmp = (float)this.parseDouble(minorTickElement.getLayoutStyle().getValue(BoxStyleKeys.WIDTH));
        if (minorTickWidthTmp != 0.0f) {
            scaleMinorTickStroke = new BasicStroke(minorTickWidthTmp);
        }
        if ((minorTickLengthTmp = this.parseDouble(minorTickElement.getLayoutStyle().getValue(BoxStyleKeys.HEIGHT)) / 100.0) != 0.0) {
            scaleMinorTickLength = minorTickLengthTmp;
        }
        if ((majorTickColorTmp = ColorFactory.getInstance().getColor(majorTickElement)) != null) {
            scaleMajorTickPaint = majorTickColorTmp;
        }
        if ((minorTickColorTmp = ColorFactory.getInstance().getColor(minorTickElement)) != null) {
            scaleMinorTickPaint = minorTickColorTmp;
        }
        FixedStandardDialScale standardDialScale = new FixedStandardDialScale(scaleLowerBound, scaleUpperBound, scaleStartAngle, scaleExtent, scaleMajorTickIncrement, scaleMinorTickCount);
        standardDialScale.setTickRadius(0.88);
        standardDialScale.setTickLabelOffset(0.15);
        standardDialScale.setTickLabelFont(scaleTickLabelFont);
        standardDialScale.setTickLabelPaint(scaleTickLabelPaint);
        standardDialScale.setMajorTickLength(scaleMajorTickLength);
        standardDialScale.setMajorTickPaint(scaleMajorTickPaint);
        standardDialScale.setMajorTickStroke(scaleMajorTickStroke);
        standardDialScale.setMinorTickLength(scaleMinorTickLength);
        standardDialScale.setMinorTickPaint(scaleMinorTickPaint);
        standardDialScale.setMinorTickStroke(scaleMinorTickStroke);
        dialPlot.addScale(0, (DialScale)standardDialScale);
    }

    protected ChartElement[] getElements(ChartDocument doc, String name) {
        if ("plot".equals(name)) {
            return new ChartElement[]{doc.getPlotElement()};
        }
        if (DIALRANGE.equals(name)) {
            ChartElement plotElem = doc.getPlotElement();
            if (plotElem != null) {
                ChartElement[] dialRanges = plotElem.findChildrenByName(DIALRANGES);
                if (dialRanges.length > 0) {
                    return dialRanges[0].findChildrenByName(name);
                }
                return null;
            }
            return null;
        }
        if (TICKLABEL.equals(name) || MAJORTICK.equals(name) || MINORTICK.equals(name)) {
            return doc.getPlotElement().findChildrenByName(SCALE)[0].findChildrenByName(name);
        }
        ChartElement[] elems = doc.getPlotElement().findChildrenByName(name);
        return elems;
    }

    public void setDialValueIndicator(ChartDocument chartDocument, DialPlot dialPlot) {
        Font valIndicatorFontTmp;
        Color valIndicatorBorderColorTmp;
        BasicStroke borderStyleStroke;
        Color valIndicatorBgColorTmp;
        Font valueIndicatorFont = new Font("Dialog", 1, 14);
        Color valueIndicatorPaint = Color.black;
        Color valueIndicatorBackgroundPaint = Color.white;
        BasicStroke valueIndicatorOutlineStroke = new BasicStroke(1.0f);
        Color valueIndicatorOutlinePaint = Color.blue;
        ChartElement valIndicatorElement = this.getUniqueElement(chartDocument, DIALVALUEINDICATOR);
        Color valIndicatorColorTmp = ColorFactory.getInstance().getColor(valIndicatorElement);
        if (valIndicatorColorTmp != null) {
            valueIndicatorPaint = valIndicatorColorTmp;
        }
        if ((valIndicatorBgColorTmp = ColorFactory.getInstance().getColor(valIndicatorElement, BorderStyleKeys.BACKGROUND_COLOR)) != null) {
            valueIndicatorBackgroundPaint = valIndicatorBgColorTmp;
        }
        if ((borderStyleStroke = StrokeFactory.getInstance().getBorderStroke(valIndicatorElement)) != null) {
            valueIndicatorOutlineStroke = borderStyleStroke;
        }
        if ((valIndicatorBorderColorTmp = ColorFactory.getInstance().getColor(valIndicatorElement, BorderStyleKeys.BORDER_TOP_COLOR)) != null) {
            valueIndicatorOutlinePaint = valIndicatorBorderColorTmp;
        }
        if ((valIndicatorFontTmp = JFreeChartUtils.getFont(valIndicatorElement)) != null) {
            valueIndicatorFont = valIndicatorFontTmp;
        }
        DialValueIndicator dialValueIndicator = new DialValueIndicator(0);
        ChartElement scaleElement = this.getUniqueElement(chartDocument, SCALE);
        if (scaleElement != null) {
            double scaleUpperBound = Double.parseDouble(scaleElement.getAttribute(UPPERBOUND).toString());
            double scaleLowerBound = Double.parseDouble(scaleElement.getAttribute(LOWERBOUND).toString());
            if (Math.abs(scaleUpperBound) > Math.abs(scaleLowerBound)) {
                dialValueIndicator.setTemplateValue((Number)scaleUpperBound);
            } else {
                dialValueIndicator.setTemplateValue((Number)scaleLowerBound);
            }
        }
        dialValueIndicator.setFont(valueIndicatorFont);
        dialValueIndicator.setPaint((Paint)valueIndicatorPaint);
        dialValueIndicator.setBackgroundPaint((Paint)valueIndicatorBackgroundPaint);
        dialValueIndicator.setOutlineStroke((Stroke)valueIndicatorOutlineStroke);
        dialValueIndicator.setOutlinePaint((Paint)valueIndicatorOutlinePaint);
        dialPlot.addLayer((DialLayer)dialValueIndicator);
    }

    protected ChartElement getUniqueElement(ChartDocument doc, String name) {
        ChartElement[] chartElements = this.getElements(doc, name);
        return chartElements.length > 0 ? chartElements[0] : null;
    }

    public static class VariableStrokePointer
    extends DialPointer.Pointer {
        private static final long serialVersionUID = 1L;
        private transient Stroke outlineStroke;

        public Stroke getOutlineStroke() {
            return this.outlineStroke;
        }

        public void setOutlineStroke(Stroke outlineStroke) {
            if (outlineStroke == null) {
                throw new IllegalArgumentException("Null 'stroke' argument.");
            }
            this.outlineStroke = outlineStroke;
            this.notifyListeners(new DialLayerChangeEvent((DialLayer)this));
        }

        public void draw(Graphics2D g2, DialPlot plot, Rectangle2D frame, Rectangle2D view) {
            g2.setPaint(Color.blue);
            g2.setStroke(this.outlineStroke);
            Rectangle2D lengthRect = DialPlot.rectangleByRadius((Rectangle2D)frame, (double)this.getRadius(), (double)this.getRadius());
            Rectangle2D widthRect = DialPlot.rectangleByRadius((Rectangle2D)frame, (double)this.getWidthRadius(), (double)this.getWidthRadius());
            double value = plot.getValue(this.getDatasetIndex());
            DialScale scale = plot.getScaleForDataset(this.getDatasetIndex());
            double angle = scale.valueToAngle(value);
            Arc2D.Double arc1 = new Arc2D.Double(lengthRect, angle, 0.0, 0);
            Point2D pt1 = arc1.getEndPoint();
            Arc2D.Double arc2 = new Arc2D.Double(widthRect, angle - 90.0, 180.0, 0);
            Point2D pt2 = arc2.getStartPoint();
            Point2D pt3 = arc2.getEndPoint();
            Arc2D.Double arc3 = new Arc2D.Double(widthRect, angle - 180.0, 0.0, 0);
            Point2D pt4 = arc3.getStartPoint();
            GeneralPath gp = new GeneralPath();
            gp.moveTo((float)pt1.getX(), (float)pt1.getY());
            gp.lineTo((float)pt2.getX(), (float)pt2.getY());
            gp.lineTo((float)pt4.getX(), (float)pt4.getY());
            gp.lineTo((float)pt3.getX(), (float)pt3.getY());
            gp.closePath();
            g2.setPaint(this.getFillPaint());
            g2.fill(gp);
            g2.setPaint(this.getOutlinePaint());
            Line2D.Double line = new Line2D.Double(frame.getCenterX(), frame.getCenterY(), pt1.getX(), pt1.getY());
            g2.draw(line);
            line.setLine(pt2, pt3);
            g2.draw(line);
            line.setLine(pt3, pt1);
            g2.draw(line);
            line.setLine(pt2, pt1);
            g2.draw(line);
            line.setLine(pt2, pt4);
            g2.draw(line);
            line.setLine(pt3, pt4);
            g2.draw(line);
        }
    }

    public static class FixedStandardDialScale
    extends StandardDialScale {
        private static final long serialVersionUID = 1L;

        public FixedStandardDialScale(double lowerBound, double upperBound, double startAngle, double extent, double majorTickIncrement, int minorTickCount) {
            super(lowerBound, upperBound, startAngle, extent, majorTickIncrement, minorTickCount);
        }

        public void draw(Graphics2D g2, DialPlot plot, Rectangle2D frame, Rectangle2D view) {
            Rectangle2D arcRect = DialPlot.rectangleByRadius((Rectangle2D)frame, (double)this.getTickRadius(), (double)this.getTickRadius());
            Rectangle2D arcRectMajor = DialPlot.rectangleByRadius((Rectangle2D)frame, (double)(this.getTickRadius() - this.getMajorTickLength()), (double)(this.getTickRadius() - this.getMajorTickLength()));
            Rectangle2D arcRectMinor = arcRect;
            if (this.getMinorTickCount() > 0 && this.getMinorTickLength() > 0.0) {
                arcRectMinor = DialPlot.rectangleByRadius((Rectangle2D)frame, (double)(this.getTickRadius() - this.getMinorTickLength()), (double)(this.getTickRadius() - this.getMinorTickLength()));
            }
            Rectangle2D arcRectForLabels = DialPlot.rectangleByRadius((Rectangle2D)frame, (double)(this.getTickRadius() - this.getTickLabelOffset()), (double)(this.getTickRadius() - this.getTickLabelOffset()));
            boolean firstLabel = true;
            Arc2D.Double arc = new Arc2D.Double();
            Line2D.Double workingLine = new Line2D.Double();
            for (double v = this.getLowerBound(); v <= this.getUpperBound(); v += this.getMajorTickIncrement()) {
                double vv;
                arc.setArc(arcRect, this.getStartAngle(), this.valueToAngle(v) - this.getStartAngle(), 0);
                Point2D pt0 = arc.getEndPoint();
                arc.setArc(arcRectMajor, this.getStartAngle(), this.valueToAngle(v) - this.getStartAngle(), 0);
                Point2D pt1 = arc.getEndPoint();
                g2.setPaint(this.getMajorTickPaint());
                g2.setStroke(this.getMajorTickStroke());
                workingLine.setLine(pt0, pt1);
                g2.draw(workingLine);
                arc.setArc(arcRectForLabels, this.getStartAngle(), this.valueToAngle(v) - this.getStartAngle(), 0);
                Point2D pt2 = arc.getEndPoint();
                if (this.getTickLabelsVisible() && (!firstLabel || this.getFirstTickLabelVisible())) {
                    g2.setFont(this.getTickLabelFont());
                    g2.setPaint(this.getTickLabelPaint());
                    TextUtilities.drawAlignedString((String)this.getTickLabelFormatter().format(v), (Graphics2D)g2, (float)((float)pt2.getX()), (float)((float)pt2.getY()), (TextAnchor)TextAnchor.CENTER);
                }
                firstLabel = false;
                if (this.getMinorTickCount() <= 0 || !(this.getMinorTickLength() > 0.0)) continue;
                double minorTickIncrement = this.getMajorTickIncrement() / (double)(this.getMinorTickCount() + 1);
                for (int i = 0; i < this.getMinorTickCount() && !((vv = v + (double)(i + 1) * minorTickIncrement) >= this.getUpperBound()); ++i) {
                    double angle = this.valueToAngle(vv);
                    arc.setArc(arcRect, this.getStartAngle(), angle - this.getStartAngle(), 0);
                    pt0 = arc.getEndPoint();
                    arc.setArc(arcRectMinor, this.getStartAngle(), angle - this.getStartAngle(), 0);
                    Point2D pt3 = arc.getEndPoint();
                    g2.setStroke(this.getMinorTickStroke());
                    g2.setPaint(this.getMinorTickPaint());
                    workingLine.setLine(pt0, pt3);
                    g2.draw(workingLine);
                }
            }
        }
    }

    public static class ImageDialBackground
    extends DialBackground {
        private static final long serialVersionUID = 1L;
        private Image image;

        public ImageDialBackground(Image image) {
            this.image = image;
        }

        public void draw(Graphics2D g2, DialPlot plot, Rectangle2D frame, Rectangle2D view) {
            g2.drawImage(this.image, 20, 20, new ImageObserver(){

                @Override
                public boolean imageUpdate(Image arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
                    return false;
                }
            });
        }
    }

    public static class DoubleLineDialFrame
    extends StandardDialFrame {
        private static final long serialVersionUID = 1L;
        private transient Paint innerForegroundPaint = Color.black;

        public Paint getInnerForegroundPaint() {
            return this.innerForegroundPaint;
        }

        public void setInnerForegroundPaint(Paint paint) {
            if (paint == null) {
                throw new IllegalArgumentException("Null 'paint' argument.");
            }
            this.innerForegroundPaint = paint;
            this.notifyListeners(new DialLayerChangeEvent((DialLayer)this));
        }

        public void draw(Graphics2D g2, DialPlot plot, Rectangle2D frame, Rectangle2D view) {
            Shape window = this.getWindow(frame);
            Rectangle2D f = DialPlot.rectangleByRadius((Rectangle2D)frame, (double)(this.getRadius() + 0.02), (double)(this.getRadius() + 0.02));
            Ellipse2D.Double e = new Ellipse2D.Double(f.getX(), f.getY(), f.getWidth(), f.getHeight());
            Area area = new Area(e);
            Area area2 = new Area(window);
            area.subtract(area2);
            g2.setPaint(this.getBackgroundPaint());
            g2.fill(area);
            g2.setStroke(this.getStroke());
            g2.setPaint(this.getInnerForegroundPaint());
            g2.draw(window);
            g2.setPaint(this.getForegroundPaint());
            g2.draw(e);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof DoubleLineDialFrame)) {
                return false;
            }
            DoubleLineDialFrame that = (DoubleLineDialFrame)((Object)obj);
            if (!PaintUtilities.equal((Paint)this.getBackgroundPaint(), (Paint)that.getBackgroundPaint())) {
                return false;
            }
            if (!PaintUtilities.equal((Paint)this.getForegroundPaint(), (Paint)that.getForegroundPaint())) {
                return false;
            }
            if (!PaintUtilities.equal((Paint)this.getInnerForegroundPaint(), (Paint)that.getInnerForegroundPaint())) {
                return false;
            }
            if (this.getRadius() != that.getRadius()) {
                return false;
            }
            if (!this.getStroke().equals(that.getStroke())) {
                return false;
            }
            return super.equals(obj);
        }
    }

    public static class SingleLineDialRange
    extends StandardDialRange {
        private static final long serialVersionUID = 1L;

        public SingleLineDialRange(double lower, double upper, Paint paint) {
            super(lower, upper, paint);
        }

        public void draw(Graphics2D g2, DialPlot plot, Rectangle2D frame, Rectangle2D view) {
            Rectangle2D arcRectInner = DialPlot.rectangleByRadius((Rectangle2D)frame, (double)this.getInnerRadius(), (double)this.getInnerRadius());
            DialScale scale = plot.getScale(this.getScaleIndex());
            if (scale == null) {
                throw new RuntimeException("No scale for scaleIndex = " + this.getScaleIndex());
            }
            double angleMin = scale.valueToAngle(this.getLowerBound());
            double angleMax = scale.valueToAngle(this.getUpperBound());
            Arc2D.Double arcInner = new Arc2D.Double(arcRectInner, angleMin, angleMax - angleMin, 0);
            double frameWidth = frame.getWidth();
            float strokeWidth = (float)frameWidth * 0.125f;
            g2.setPaint(this.getPaint());
            g2.setStroke(new BasicStroke(strokeWidth, 0, 0));
            g2.draw(arcInner);
        }
    }

    public static class SingleLineDialFrame
    extends StandardDialFrame {
        private static final long serialVersionUID = 1L;

        public void draw(Graphics2D g2, DialPlot plot, Rectangle2D frame, Rectangle2D view) {
            Shape window = this.getWindow(frame);
            g2.setPaint(this.getBackgroundPaint());
            g2.setStroke(this.getStroke());
            g2.setPaint(this.getForegroundPaint());
            g2.draw(window);
        }
    }

    public static class SquareDialPlot
    extends DialPlot {
        public void draw(Graphics2D g2, Rectangle2D area, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
            Rectangle2D.Double squareArea = new Rectangle2D.Double();
            double sideLength = Math.min(area.getWidth(), area.getHeight());
            double distToShiftToCenter = (area.getWidth() - sideLength) / 2.0;
            ((Rectangle2D)squareArea).setRect(area.getX() + distToShiftToCenter, area.getY(), sideLength, sideLength);
            super.draw(g2, (Rectangle2D)squareArea, anchor, parentState, info);
        }
    }
}

