/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.plugin.jfreechart.chart.bar;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.WaterfallBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.pentaho.chart.ChartDocumentContext;
import org.pentaho.chart.core.ChartDocument;
import org.pentaho.chart.core.ChartElement;
import org.pentaho.chart.css.keys.ChartStyleKeys;
import org.pentaho.chart.data.ChartTableModel;
import org.pentaho.chart.plugin.jfreechart.chart.bar.JFreeBarChartGenerator;
import org.pentaho.chart.plugin.jfreechart.utils.JFreeChartUtils;
import org.pentaho.chart.plugin.jfreechart.utils.StrokeFactory;
import org.pentaho.reporting.libraries.css.keys.border.BorderStyleKeys;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class JFreeWaterfallBarChartGenerator
extends JFreeBarChartGenerator {
    @Override
    protected JFreeChart doCreateChart(ChartDocumentContext chartDocContext, ChartTableModel data) {
        ChartDocument chartDocument = chartDocContext.getChartDocument();
        String title = JFreeWaterfallBarChartGenerator.getTitle(chartDocument);
        String valueCategoryLabel = JFreeWaterfallBarChartGenerator.getValueCategoryLabel(chartDocument);
        String valueAxisLabel = JFreeWaterfallBarChartGenerator.getValueAxisLabel(chartDocument);
        PlotOrientation orientation = this.getPlotOrientation(chartDocument);
        boolean legend = JFreeWaterfallBarChartGenerator.getShowLegend(chartDocument);
        boolean toolTips = JFreeWaterfallBarChartGenerator.getShowToolTips(chartDocument);
        DefaultCategoryDataset categoryDataset = this.datasetGeneratorFactory.createDefaultCategoryDataset(chartDocContext, data);
        JFreeChart chart = ChartFactory.createWaterfallChart((String)title, (String)valueCategoryLabel, (String)valueAxisLabel, (CategoryDataset)categoryDataset, (PlotOrientation)orientation, (boolean)legend, (boolean)toolTips, (boolean)toolTips);
        CategoryPlot categoryPlot = chart.getCategoryPlot();
        ChartElement plotElement = chartDocument.getRootElement().findChildrenByName("plot")[0];
        this.setPlotAttributes(categoryPlot, plotElement);
        ChartElement[] seriesElements = chartDocument.getRootElement().findChildrenByName("series");
        if (categoryPlot != null && seriesElements != null) {
            this.setSeriesAttributes(seriesElements, data, categoryPlot);
        }
        return chart;
    }

    private void setPlotAttributes(CategoryPlot categoryPlot, ChartElement plotElement) {
        WaterfallBarRenderer render = (WaterfallBarRenderer)categoryPlot.getRenderer();
        Paint firstColor = (Paint)plotElement.getLayoutStyle().getValue(ChartStyleKeys.FIRST_BAR_COLOR);
        Paint lastColor = (Paint)plotElement.getLayoutStyle().getValue(ChartStyleKeys.LAST_BAR_COLOR);
        Paint positiveColor = (Paint)plotElement.getLayoutStyle().getValue(ChartStyleKeys.POSITIVE_BAR_COLOR);
        Paint negativeColor = (Paint)plotElement.getLayoutStyle().getValue(ChartStyleKeys.NEGATIVE_BAR_COLOR);
        render.setFirstBarPaint(firstColor);
        render.setLastBarPaint(lastColor);
        render.setPositiveBarPaint(positiveColor);
        render.setNegativeBarPaint(negativeColor);
    }

    public void setSeriesAttributes(ChartElement[] seriesElements, ChartTableModel data, CategoryPlot categoryPlot) {
        this.setSeriesItemLabel(categoryPlot, seriesElements, data);
        this.setSeriesPaint(categoryPlot, seriesElements, data);
        JFreeWaterfallBarChartGenerator.setSeriesBarOutline(categoryPlot, seriesElements, data);
    }

    private static void setSeriesBarOutline(CategoryPlot categoryPlot, ChartElement[] seriesElements, ChartTableModel data) {
        int length = seriesElements.length;
        StrokeFactory strokeFacObj = StrokeFactory.getInstance();
        for (int i = 0; i < length; ++i) {
            ChartElement currElement = seriesElements[i];
            int column = JFreeChartUtils.getSeriesColumn(currElement, data, i);
            if (!(categoryPlot.getRenderer() instanceof BarRenderer)) continue;
            BarRenderer barRender = (BarRenderer)categoryPlot.getRenderer();
            BasicStroke borderStyleStroke = strokeFacObj.getBorderStroke(currElement);
            if (borderStyleStroke == null) continue;
            CSSValue borderColorValue = currElement.getLayoutStyle().getValue(BorderStyleKeys.BORDER_TOP_COLOR);
            Color borderColor = JFreeChartUtils.getColorFromCSSValue(borderColorValue);
            if (borderColor != null) {
                barRender.setSeriesOutlinePaint(column, (Paint)borderColor, true);
            }
            barRender.setSeriesOutlineStroke(column, (Stroke)borderStyleStroke, true);
            barRender.setDrawBarOutline(true);
        }
    }
}

