/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.plugin.jfreechart.chart.bar;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.pentaho.chart.ChartDocumentContext;
import org.pentaho.chart.core.ChartDocument;
import org.pentaho.chart.core.ChartElement;
import org.pentaho.chart.css.keys.ChartStyleKeys;
import org.pentaho.chart.data.ChartTableModel;
import org.pentaho.chart.plugin.jfreechart.chart.JFreeChartGenerator;
import org.pentaho.chart.plugin.jfreechart.utils.JFreeChartUtils;
import org.pentaho.chart.plugin.jfreechart.utils.StrokeFactory;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.keys.border.BorderStyleKeys;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.util.messages.Messages;

public abstract class JFreeBarChartGenerator
extends JFreeChartGenerator {
    private static final Log logger = LogFactory.getLog(JFreeBarChartGenerator.class);
    private static final String DOMAIN_AXIS = "domain";

    public JFreeChart createChart(ChartDocumentContext chartDocContext, ChartTableModel data, String chartType) {
        ChartDocument chartDocument = chartDocContext.getChartDocument();
        String title = JFreeBarChartGenerator.getTitle(chartDocument);
        String valueCategoryLabel = JFreeBarChartGenerator.getValueCategoryLabel(chartDocument);
        String valueAxisLabel = JFreeBarChartGenerator.getValueAxisLabel(chartDocument);
        PlotOrientation orientation = this.getPlotOrientation(chartDocument);
        boolean legend = JFreeBarChartGenerator.getShowLegend(chartDocument);
        boolean toolTips = JFreeBarChartGenerator.getShowToolTips(chartDocument);
        DefaultCategoryDataset categoryDataset = null;
        CategoryDataset intervalCategoryDataset = null;
        if ("interval".equalsIgnoreCase(chartType)) {
            logger.error((Object)Messages.getErrorString("JFreeBarChartGenerator.INFO_INTERVAL_CHART_NOT_SUPPORTED"));
        } else {
            categoryDataset = this.datasetGeneratorFactory.createDefaultCategoryDataset(chartDocContext, data);
            if (categoryDataset == null) {
                logger.error((Object)Messages.getErrorString("JFreeChartFactoryEngine.ERROR_0001_DATASET_IS_NULL"));
                return null;
            }
        }
        JFreeChart chart = "stacked".equalsIgnoreCase(chartType) ? ChartFactory.createStackedBarChart((String)title, (String)valueCategoryLabel, (String)valueAxisLabel, (CategoryDataset)categoryDataset, (PlotOrientation)orientation, (boolean)legend, (boolean)toolTips, (boolean)false) : ("interval".equalsIgnoreCase(chartType) ? ChartFactory.createBarChart((String)title, (String)valueCategoryLabel, (String)valueAxisLabel, intervalCategoryDataset, (PlotOrientation)orientation, (boolean)legend, (boolean)toolTips, (boolean)false) : ("waterfall".equalsIgnoreCase(chartType) ? ChartFactory.createBarChart((String)title, (String)valueCategoryLabel, (String)valueAxisLabel, intervalCategoryDataset, (PlotOrientation)orientation, (boolean)legend, (boolean)toolTips, (boolean)false) : ChartFactory.createBarChart((String)title, (String)valueCategoryLabel, (String)valueAxisLabel, (CategoryDataset)categoryDataset, (PlotOrientation)orientation, (boolean)legend, (boolean)toolTips, (boolean)false)));
        ChartElement[] seriesElements = chartDocument.getRootElement().findChildrenByName("series");
        CategoryPlot categoryPlot = chart.getCategoryPlot();
        if (seriesElements != null && categoryPlot != null) {
            this.setSeriesAttributes(seriesElements, data, categoryPlot);
            this.setAxisMargins(chartDocument, categoryPlot);
        }
        return chart;
    }

    private void setSeriesAttributes(ChartElement[] seriesElements, ChartTableModel data, CategoryPlot categoryPlot) {
        this.setSeriesItemLabel(categoryPlot, seriesElements, data);
        this.setSeriesPaint(categoryPlot, seriesElements, data);
        JFreeBarChartGenerator.setSeriesBarOutline(categoryPlot, seriesElements, data);
    }

    private static void setSeriesBarOutline(CategoryPlot categoryPlot, ChartElement[] seriesElements, ChartTableModel data) {
        int length = seriesElements.length;
        StrokeFactory strokeFacObj = StrokeFactory.getInstance();
        for (int i = 0; i < length; ++i) {
            ChartElement currElement = seriesElements[i];
            int column = JFreeChartUtils.getSeriesColumn(currElement, data, i);
            if (!(categoryPlot.getRenderer() instanceof BarRenderer)) continue;
            BarRenderer barRender = (BarRenderer)categoryPlot.getRenderer();
            BasicStroke borderStyleStroke = strokeFacObj.getBorderStroke(currElement);
            if (borderStyleStroke == null) continue;
            CSSValue borderColorValue = currElement.getLayoutStyle().getValue(BorderStyleKeys.BORDER_TOP_COLOR);
            Color borderColor = JFreeChartUtils.getColorFromCSSValue(borderColorValue);
            if (borderColor != null) {
                barRender.setSeriesOutlinePaint(column, (Paint)borderColor, true);
            }
            barRender.setSeriesOutlineStroke(column, (Stroke)borderStyleStroke, true);
            barRender.setDrawBarOutline(true);
        }
    }

    private void setAxisMargins(ChartDocument chartDocument, CategoryPlot categoryPlot) {
        ArrayList<ChartElement> axisElementsList = chartDocument.getAxisSeriesLinkInfo().getDomainAxisElements();
        if (axisElementsList != null) {
            for (ChartElement axisElement : axisElementsList) {
                String axisType;
                if (axisElement == null || (axisType = (String)axisElement.getAttribute("type")) == null || !DOMAIN_AXIS.equalsIgnoreCase(axisType)) continue;
                LayoutStyle layoutStyle = axisElement.getLayoutStyle();
                CSSValue lowerMarginValue = layoutStyle.getValue(ChartStyleKeys.MARGIN_LOWER);
                CSSValue upperMarginValue = layoutStyle.getValue(ChartStyleKeys.MARGIN_UPPER);
                CSSValue itemMarginValue = layoutStyle.getValue(ChartStyleKeys.MARGIN_ITEM);
                CSSValue categoryMarginValue = layoutStyle.getValue(ChartStyleKeys.MARGIN_CATEGORY);
                CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
                if (lowerMarginValue != null) {
                    double lowerMargin = ((CSSNumericValue)lowerMarginValue).getValue() / 100.0;
                    categoryAxis.setLowerMargin(lowerMargin);
                }
                if (upperMarginValue != null) {
                    double upperMargin = ((CSSNumericValue)upperMarginValue).getValue() / 100.0;
                    categoryAxis.setUpperMargin(upperMargin);
                }
                if (categoryMarginValue != null) {
                    double categoryMargin = ((CSSNumericValue)categoryMarginValue).getValue() / 100.0;
                    categoryAxis.setCategoryMargin(categoryMargin);
                }
                if (itemMarginValue == null) continue;
                double itemMargin = ((CSSNumericValue)itemMarginValue).getValue() / 100.0;
                int datasetCount = categoryPlot.getDatasetCount();
                for (int i = 0; i < datasetCount; ++i) {
                    if (!(categoryPlot.getRenderer() instanceof BarRenderer)) continue;
                    BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer(i);
                    barRenderer.setItemMargin(itemMargin);
                }
            }
        }
    }
}

