/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.plugin.jfreechart.chart.area;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.pentaho.chart.ChartDocumentContext;
import org.pentaho.chart.core.ChartDocument;
import org.pentaho.chart.core.ChartElement;
import org.pentaho.chart.css.styles.ChartAreaStyle;
import org.pentaho.chart.data.ChartTableModel;
import org.pentaho.chart.plugin.jfreechart.chart.JFreeChartGenerator;
import org.pentaho.reporting.libraries.css.values.CSSConstant;
import org.pentaho.util.messages.Messages;

public abstract class JFreeAreaChartGenerator
extends JFreeChartGenerator {
    private static final Log logger = LogFactory.getLog(JFreeAreaChartGenerator.class);

    public JFreeChart createChart(ChartDocumentContext chartDocContext, ChartTableModel data, CSSConstant chartType) {
        ChartDocument chartDocument = chartDocContext.getChartDocument();
        String title = JFreeAreaChartGenerator.getTitle(chartDocument);
        String valueCategoryLabel = JFreeAreaChartGenerator.getValueCategoryLabel(chartDocument);
        String valueAxisLabel = JFreeAreaChartGenerator.getValueAxisLabel(chartDocument);
        PlotOrientation orientation = this.getPlotOrientation(chartDocument);
        boolean legend = JFreeAreaChartGenerator.getShowLegend(chartDocument);
        boolean toolTips = JFreeAreaChartGenerator.getShowToolTips(chartDocument);
        DefaultCategoryDataset categoryDataset = this.datasetGeneratorFactory.createDefaultCategoryDataset(chartDocContext, data);
        if (categoryDataset == null) {
            logger.error((Object)Messages.getErrorString("JFreeChartFactoryEngine.ERROR_0001_DATASET_IS_NULL"));
            return null;
        }
        JFreeChart chart = null;
        if (ChartAreaStyle.STACKED.equals((Object)chartType)) {
            chart = ChartFactory.createStackedAreaChart((String)title, (String)valueCategoryLabel, (String)valueAxisLabel, (CategoryDataset)categoryDataset, (PlotOrientation)orientation, (boolean)legend, (boolean)toolTips, (boolean)false);
        } else if (!ChartAreaStyle.XY.equals((Object)chartType)) {
            chart = ChartFactory.createAreaChart((String)title, (String)valueCategoryLabel, (String)valueAxisLabel, (CategoryDataset)categoryDataset, (PlotOrientation)orientation, (boolean)legend, (boolean)toolTips, (boolean)false);
        }
        if (chart != null) {
            ChartElement[] seriesElements = chartDocument.getRootElement().findChildrenByName("series");
            CategoryPlot categoryPlot = chart.getCategoryPlot();
            if (seriesElements != null && categoryPlot != null) {
                this.setSeriesAttributes(seriesElements, data, categoryPlot);
            }
        }
        return chart;
    }

    private void setSeriesAttributes(ChartElement[] seriesElements, ChartTableModel data, CategoryPlot categoryPlot) {
        this.setSeriesItemLabel(categoryPlot, seriesElements, data);
        this.setSeriesPaint(categoryPlot, seriesElements, data);
    }
}

